/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.DEFAULT.getCharSequenceTranslator();

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            switch (printMode) {
                case PRETTY: {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(this.toString()));
                }
            }
            return this.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object e : this) {
            if (e instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)e)));
                sb.append('\"');
            } else {
                sb.append(e);
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }
}

