/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.Jackson3JsonArray;
import com.github.wnameless.json.base.Jackson3JsonValue;
import com.github.wnameless.json.base.JsonObjectCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.TransformIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public final class Jackson3JsonObject
implements JsonObjectCore<Jackson3JsonValue> {
    private final ObjectNode jsonObject;

    public Jackson3JsonObject(ObjectNode jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.jsonObject = jsonObject;
    }

    @Override
    public void set(String name, JsonSource jsonValue) {
        this.jsonObject.set(name, (JsonNode)jsonValue.getSource());
    }

    @Override
    public boolean remove(String name) {
        return this.jsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.jsonObject.has(name);
    }

    @Override
    public Jackson3JsonValue get(String name) {
        JsonNode node = this.jsonObject.get(name);
        return node == null ? null : new Jackson3JsonValue(node);
    }

    @Override
    public int size() {
        return this.jsonObject.size();
    }

    @Override
    public Iterator<String> names() {
        return this.jsonObject.propertyNames().iterator();
    }

    @Override
    public Iterator<Map.Entry<String, Jackson3JsonValue>> iterator() {
        return new TransformIterator<Map.Entry, Map.Entry>(this.jsonObject.properties().iterator(), member -> new AbstractMap.SimpleImmutableEntry<String, Jackson3JsonValue>((String)member.getKey(), new Jackson3JsonValue((JsonNode)member.getValue())));
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Jackson3JsonObject asObject() {
        return this;
    }

    @Override
    public Jackson3JsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Jackson3JsonValue asValue() {
        return new Jackson3JsonValue((JsonNode)this.jsonObject);
    }

    @Override
    public Object getSource() {
        return this.jsonObject;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Jackson3JsonObject)) return false;
        Jackson3JsonObject jo = (Jackson3JsonObject)o;
        if (!Objects.equals(this.jsonObject, jo.jsonObject)) return false;
        return true;
    }

    public String toString() {
        return this.jsonObject.toString();
    }
}

