/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.Jackson3JsonValue;
import com.github.wnameless.json.base.JsonCore;
import java.io.IOException;
import java.io.Reader;
import tools.jackson.databind.ObjectMapper;

public class Jackson3JsonCore
implements JsonCore<Jackson3JsonValue> {
    private ObjectMapper mapper;

    private ObjectMapper getInstance() {
        return this.mapper == null ? LazyHolder.INSTANCE : this.mapper;
    }

    public Jackson3JsonCore() {
        this.mapper = null;
    }

    public Jackson3JsonCore(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        this.mapper = mapper;
    }

    public Jackson3JsonValue parse(String json) {
        return new Jackson3JsonValue(this.getInstance().readTree(json));
    }

    public Jackson3JsonValue parse(Reader jsonReader) throws IOException {
        return new Jackson3JsonValue(this.getInstance().readTree(jsonReader));
    }

    private static class LazyHolder {
        public static final ObjectMapper INSTANCE = new ObjectMapper();

        private LazyHolder() {
        }
    }
}

