/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JsonValueCore;
import com.github.wnameless.json.base.OrgJsonArray;
import com.github.wnameless.json.base.OrgJsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;

public final class OrgJsonValue
implements JsonValueCore<OrgJsonValue> {
    private final Object jsonValue;

    public OrgJsonValue(Object jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException();
        }
        if (!(jsonValue instanceof Boolean || jsonValue instanceof String || jsonValue instanceof Number || jsonValue instanceof JSONArray || jsonValue instanceof JSONObject || jsonValue == JSONObject.NULL)) {
            throw new IllegalArgumentException();
        }
        this.jsonValue = jsonValue;
    }

    public OrgJsonValue(JSONTokener jsonTokener) {
        if (jsonTokener == null) {
            throw new NullPointerException();
        }
        this.jsonValue = jsonTokener.nextValue();
    }

    @Override
    public boolean isObject() {
        return this.jsonValue instanceof JSONObject;
    }

    @Override
    public boolean isArray() {
        return this.jsonValue instanceof JSONArray;
    }

    @Override
    public boolean isString() {
        return this.jsonValue instanceof String;
    }

    @Override
    public boolean isBoolean() {
        return this.jsonValue instanceof Boolean;
    }

    @Override
    public boolean isNumber() {
        return this.jsonValue instanceof Number;
    }

    @Override
    public boolean isNull() {
        return this.jsonValue == JSONObject.NULL;
    }

    @Override
    public String asString() {
        return (String)this.jsonValue;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.jsonValue;
    }

    @Override
    public int asInt() {
        return ((Number)this.jsonValue).intValue();
    }

    @Override
    public long asLong() {
        return ((Number)this.jsonValue).longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return new BigInteger(this.jsonValue.toString());
    }

    @Override
    public double asDouble() {
        return ((Number)this.jsonValue).doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return new BigDecimal(this.jsonValue.toString());
    }

    public int hashCode() {
        return this.jsonValue.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrgJsonValue)) {
            return false;
        }
        if (this.jsonValue instanceof JSONObject) {
            return ((JSONObject)this.jsonValue).similar(((OrgJsonValue)o).jsonValue);
        }
        if (this.jsonValue instanceof JSONArray) {
            return ((JSONArray)this.jsonValue).similar(((OrgJsonValue)o).jsonValue);
        }
        return Objects.equals(this.jsonValue, ((OrgJsonValue)o).jsonValue);
    }

    public String toString() {
        return JSONWriter.valueToString((Object)this.jsonValue);
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    @Override
    public Object getSource() {
        return this.jsonValue;
    }

    @Override
    public OrgJsonObject asObject() {
        return new OrgJsonObject((JSONObject)this.jsonValue);
    }

    @Override
    public OrgJsonArray asArray() {
        return new OrgJsonArray((JSONArray)this.jsonValue);
    }

    @Override
    public OrgJsonValue asValue() {
        return this;
    }
}

