/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

public final class JsonPrinter {
    private JsonPrinter() {
    }

    public static String minimalPrint(String json) {
        if (json == null) {
            new NullPointerException();
        }
        StringBuilder minimalPrintBuilder = new StringBuilder();
        boolean inQuote = false;
        block3: for (char jsonChar : json.toCharArray()) {
            switch (jsonChar) {
                case '\"': {
                    inQuote = !inQuote;
                    minimalPrintBuilder.append(jsonChar);
                    continue block3;
                }
                default: {
                    if (!inQuote && Character.toString(jsonChar).matches("\\s")) continue block3;
                    minimalPrintBuilder.append(jsonChar);
                }
            }
        }
        return minimalPrintBuilder.toString();
    }

    public static String prettyPrint(String json) {
        return JsonPrinter.prettyPrint(json, "  ");
    }

    public static String prettyPrint(String json, String indentStr) {
        if (json == null) {
            new NullPointerException();
        }
        StringBuilder prettyPrintBuilder = new StringBuilder();
        int indentLevel = 0;
        boolean inQuote = false;
        boolean inBracket = false;
        block9: for (char jsonChar : json.toCharArray()) {
            switch (jsonChar) {
                case '\"': {
                    inQuote = !inQuote;
                    prettyPrintBuilder.append(jsonChar);
                    continue block9;
                }
                case '{': {
                    prettyPrintBuilder.append(jsonChar);
                    if (inQuote) continue block9;
                    JsonPrinter.appendNewLine(prettyPrintBuilder, ++indentLevel, indentStr);
                    continue block9;
                }
                case '}': {
                    if (!inQuote) {
                        JsonPrinter.appendNewLine(prettyPrintBuilder, --indentLevel, indentStr);
                    }
                    prettyPrintBuilder.append(jsonChar);
                    continue block9;
                }
                case '[': {
                    prettyPrintBuilder.append(jsonChar);
                    if (inQuote) continue block9;
                    inBracket = true;
                    prettyPrintBuilder.append(' ');
                    continue block9;
                }
                case ']': {
                    if (!inQuote) {
                        inBracket = false;
                        prettyPrintBuilder.append(' ');
                    }
                    prettyPrintBuilder.append(jsonChar);
                    continue block9;
                }
                case ',': {
                    prettyPrintBuilder.append(jsonChar);
                    if (inQuote) continue block9;
                    if (inBracket) {
                        prettyPrintBuilder.append(' ');
                        continue block9;
                    }
                    JsonPrinter.appendNewLine(prettyPrintBuilder, indentLevel, indentStr);
                    continue block9;
                }
                case ':': {
                    if (inQuote) {
                        prettyPrintBuilder.append(jsonChar);
                        continue block9;
                    }
                    prettyPrintBuilder.append(' ');
                    prettyPrintBuilder.append(jsonChar);
                    prettyPrintBuilder.append(' ');
                    continue block9;
                }
                default: {
                    if (!inQuote && Character.toString(jsonChar).matches("\\s")) continue block9;
                    prettyPrintBuilder.append(jsonChar);
                }
            }
        }
        return prettyPrintBuilder.toString();
    }

    private static void appendNewLine(StringBuilder stringBuilder, int indentLevel, String indentStr) {
        stringBuilder.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            stringBuilder.append(indentStr);
        }
    }
}

