/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JComponent;

public class PropertyUtil {
    public static boolean getBooleanProperty(Component c, String property) {
        return PropertyUtil.getBooleanProperty(c, property, false);
    }

    public static boolean getBooleanProperty(Component c, String property, boolean defaultValue) {
        return c instanceof JComponent && PropertyUtil.getBooleanProperty((JComponent)c, property, defaultValue);
    }

    public static boolean getBooleanProperty(JComponent c, String property) {
        return PropertyUtil.getBooleanProperty(c, property, false);
    }

    public static boolean getBooleanProperty(JComponent c, String property, boolean defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        Object obj = c.getClientProperty(property);
        if (!defaultValue) {
            return Boolean.TRUE.equals(obj);
        }
        return !Boolean.FALSE.equals(obj);
    }

    public static <T> boolean isPropertyEqual(Component c, String property, T checkValue) {
        return c instanceof JComponent && PropertyUtil.isPropertyEqual((JComponent)c, property, checkValue);
    }

    public static <T> boolean isPropertyEqual(JComponent c, String property, T checkValue) {
        if (c == null) {
            return false;
        }
        Object obj = c.getClientProperty(property);
        return Objects.equals(checkValue, obj);
    }

    public static <T> T getObject(Component c, String key, Class<T> type, T defaultValue) {
        if (!(c instanceof JComponent)) {
            return defaultValue;
        }
        return PropertyUtil.getObject((JComponent)c, key, type, defaultValue);
    }

    public static <T> T getObject(JComponent c, String key, Class<T> type, T defaultValue) {
        Object obj = c.getClientProperty(key);
        if (type.isInstance(obj)) {
            return (T)obj;
        }
        return defaultValue;
    }

    public static Color getColor(JComponent c, String key, Color defaultValue) {
        return PropertyUtil.getObject(c, key, Color.class, defaultValue);
    }

    public static Color getColor(Component c, String key, Color defaultValue) {
        return PropertyUtil.getObject(c, key, Color.class, defaultValue);
    }

    public static String getString(JComponent c, String key, String defaultValue) {
        return PropertyUtil.getObject(c, key, String.class, defaultValue);
    }

    public static String getString(Component c, String key, String defaultValue) {
        return PropertyUtil.getObject(c, key, String.class, defaultValue);
    }

    public static <T> T getObject(Component c, String key, Class<T> type) {
        return PropertyUtil.getObject(c, key, type, null);
    }

    public static <T> T getObject(JComponent c, String key, Class<T> type) {
        return PropertyUtil.getObject(c, key, type, null);
    }

    public static Color getColor(JComponent c, String key) {
        return PropertyUtil.getColor(c, key, null);
    }

    public static Color getColor(Component c, String key) {
        return PropertyUtil.getColor(c, key, null);
    }

    public static String getString(JComponent c, String key) {
        return PropertyUtil.getString(c, key, null);
    }

    public static String getString(Component c, String key) {
        return PropertyUtil.getString(c, key, null);
    }

    public static Integer getInteger(JComponent c, String key, int defaultValue) {
        return PropertyUtil.getObject(c, key, Integer.class, Integer.valueOf(defaultValue));
    }

    public static Integer getInteger(Component c, String key, int defaultValue) {
        return PropertyUtil.getObject(c, key, Integer.class, Integer.valueOf(defaultValue));
    }

    public static Integer getInteger(Component c, String key) {
        return PropertyUtil.getInteger(c, key, 0);
    }

    public static Integer getInteger(JComponent c, String key) {
        return PropertyUtil.getInteger(c, key, 0);
    }
}

