package com.zhuang.data.autoconfigure;


import com.zhuang.data.DbAccessor;
import com.zhuang.data.mybatis.MyBatisDbAccessor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;


@Configuration
@ConditionalOnBean(SqlSessionFactory.class)
@EnableConfigurationProperties(MyDataProperties.class)
@AutoConfigureAfter(MybatisAutoConfiguration.class)
public class MyDataAutoConfiguration {

    @Autowired
    MyDataProperties myDataProperties;
    @Autowired
    SqlSessionFactory sqlSessionFactory;

    @Bean(name = "dbAccessor")
    public DbAccessor dbAccessor() {
        Properties properties = com.zhuang.data.config.MyDataProperties.getInstance().getProperties();
        if (myDataProperties.getUnderscoreNaming() != null) {
            properties.setProperty(com.zhuang.data.config.MyDataProperties.UNDERSCORE_NAMING, myDataProperties.getUnderscoreNaming().toString());
        } else {

        }
        if (myDataProperties.getDbExecutionHandlers() != null && myDataProperties.getDbExecutionHandlers().size() > 0) {
            String dbExecutionHandlers = String.join(",", myDataProperties.getDbExecutionHandlers());
            properties.setProperty(com.zhuang.data.config.MyDataProperties.DB_EXECUTION_HANDLERS, dbExecutionHandlers);
        }
        DbAccessor dbAccessor = new MyBatisDbAccessor(sqlSessionFactory, true);
        return dbAccessor;
    }

}
