/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.billdownload;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.billdownload.model.GetAllSubMchFundFlowBillRequest;
import com.wechat.pay.java.service.billdownload.model.GetFundFlowBillRequest;
import com.wechat.pay.java.service.billdownload.model.GetSingleSubMchFundFlowBillRequest;
import com.wechat.pay.java.service.billdownload.model.GetTradeBillRequest;
import com.wechat.pay.java.service.billdownload.model.QueryBillEntity;
import com.wechat.pay.java.service.billdownload.model.QueryEncryptBillEntity;
import java.util.Objects;

public class BillDownloadService {
    private final HttpClient httpClient;
    private final HostName hostName;
    private final PrivacyDecryptor decryptor;

    private BillDownloadService(HttpClient httpClient, HostName hostName, PrivacyDecryptor decryptor) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
        this.decryptor = Objects.requireNonNull(decryptor);
    }

    public QueryBillEntity getFundFlowBill(GetFundFlowBillRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/bill/fundflowbill";
        GetFundFlowBillRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getBillDate() != null) {
            queryParameter.add("bill_date", (Object)UrlEncoder.urlEncode((String)realRequest.getBillDate()));
        }
        if (realRequest.getAccountType() != null) {
            queryParameter.add("account_type", (Object)UrlEncoder.urlEncode((String)realRequest.getAccountType().toString()));
        }
        if (realRequest.getTarType() != null) {
            queryParameter.add("tar_type", (Object)UrlEncoder.urlEncode((String)realRequest.getTarType().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryBillEntity.class);
        return (QueryBillEntity)httpResponse.getServiceResponse();
    }

    public QueryEncryptBillEntity getSingleSubMchFundFlowBill(GetSingleSubMchFundFlowBillRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/bill/sub-merchant-fundflowbill";
        GetSingleSubMchFundFlowBillRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getBillDate() != null) {
            queryParameter.add("bill_date", (Object)UrlEncoder.urlEncode((String)realRequest.getBillDate()));
        }
        if (realRequest.getAccountType() != null) {
            queryParameter.add("account_type", (Object)UrlEncoder.urlEncode((String)realRequest.getAccountType().toString()));
        }
        if (realRequest.getAlgorithm() != null) {
            queryParameter.add("algorithm", (Object)UrlEncoder.urlEncode((String)realRequest.getAlgorithm().toString()));
        }
        if (realRequest.getTarType() != null) {
            queryParameter.add("tar_type", (Object)UrlEncoder.urlEncode((String)realRequest.getTarType().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryEncryptBillEntity.class);
        return ((QueryEncryptBillEntity)httpResponse.getServiceResponse()).cloneWithCipher(arg_0 -> ((PrivacyDecryptor)this.decryptor).decrypt(arg_0));
    }

    public QueryEncryptBillEntity getAllSubMchFundFlowBill(GetAllSubMchFundFlowBillRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/bill/fundflowbill";
        GetAllSubMchFundFlowBillRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getBillDate() != null) {
            queryParameter.add("bill_date", (Object)UrlEncoder.urlEncode((String)realRequest.getBillDate()));
        }
        if (realRequest.getAccountType() != null) {
            queryParameter.add("account_type", (Object)UrlEncoder.urlEncode((String)realRequest.getAccountType().toString()));
        }
        if (realRequest.getTarType() != null) {
            queryParameter.add("tar_type", (Object)UrlEncoder.urlEncode((String)realRequest.getTarType().toString()));
        }
        if (realRequest.getAlgorithm() != null) {
            queryParameter.add("algorithm", (Object)UrlEncoder.urlEncode((String)realRequest.getAlgorithm().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryEncryptBillEntity.class);
        return ((QueryEncryptBillEntity)httpResponse.getServiceResponse()).cloneWithCipher(arg_0 -> ((PrivacyDecryptor)this.decryptor).decrypt(arg_0));
    }

    public QueryBillEntity getTradeBill(GetTradeBillRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/bill/tradebill";
        GetTradeBillRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getBillDate() != null) {
            queryParameter.add("bill_date", (Object)UrlEncoder.urlEncode((String)realRequest.getBillDate()));
        }
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getBillType() != null) {
            queryParameter.add("bill_type", (Object)UrlEncoder.urlEncode((String)realRequest.getBillType().toString()));
        }
        if (realRequest.getTarType() != null) {
            queryParameter.add("tar_type", (Object)UrlEncoder.urlEncode((String)realRequest.getTarType().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryBillEntity.class);
        return (QueryBillEntity)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;
        private PrivacyDecryptor decryptor;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            this.decryptor = config.createDecryptor();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder decryptor(PrivacyDecryptor decryptor) {
            this.decryptor = decryptor;
            return this;
        }

        public BillDownloadService build() {
            return new BillDownloadService(this.httpClient, this.hostName, this.decryptor);
        }
    }
}

