/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.payrollcard;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.payrollcard.model.AuthenticationEntity;
import com.wechat.pay.java.service.payrollcard.model.CreateTokenRequest;
import com.wechat.pay.java.service.payrollcard.model.CreateTransferBatchRequest;
import com.wechat.pay.java.service.payrollcard.model.GetAuthenticationRequest;
import com.wechat.pay.java.service.payrollcard.model.GetRelationRequest;
import com.wechat.pay.java.service.payrollcard.model.ListAuthenticationsRequest;
import com.wechat.pay.java.service.payrollcard.model.ListAuthenticationsResponse;
import com.wechat.pay.java.service.payrollcard.model.PreOrderAuthenticationRequest;
import com.wechat.pay.java.service.payrollcard.model.PreOrderAuthenticationResponse;
import com.wechat.pay.java.service.payrollcard.model.PreOrderAuthenticationWithAuthRequest;
import com.wechat.pay.java.service.payrollcard.model.PreOrderAuthenticationWithAuthResponse;
import com.wechat.pay.java.service.payrollcard.model.RelationEntity;
import com.wechat.pay.java.service.payrollcard.model.TokenEntity;
import com.wechat.pay.java.service.payrollcard.model.TransferBatchEntity;
import java.util.Objects;

public class PayrollCardService {
    private final HttpClient httpClient;
    private final HostName hostName;
    private final PrivacyEncryptor encryptor;

    private PayrollCardService(HttpClient httpClient, HostName hostName, PrivacyEncryptor encryptor) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
        this.encryptor = Objects.requireNonNull(encryptor);
    }

    public AuthenticationEntity getAuthentication(GetAuthenticationRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/payroll-card/authentications/{authenticate_number}";
        GetAuthenticationRequest realRequest = request;
        requestPath = requestPath.replace("{authenticate_number}", UrlEncoder.urlEncode((String)realRequest.getAuthenticateNumber()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AuthenticationEntity.class);
        return (AuthenticationEntity)httpResponse.getServiceResponse();
    }

    public ListAuthenticationsResponse listAuthentications(ListAuthenticationsRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/payroll-card/authentications";
        ListAuthenticationsRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOpenid() != null) {
            queryParameter.add("openid", (Object)UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        }
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        if (realRequest.getSubAppid() != null) {
            queryParameter.add("sub_appid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubAppid()));
        }
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getAuthenticateDate() != null) {
            queryParameter.add("authenticate_date", (Object)UrlEncoder.urlEncode((String)realRequest.getAuthenticateDate()));
        }
        if (realRequest.getAuthenticateState() != null) {
            queryParameter.add("authenticate_state", (Object)UrlEncoder.urlEncode((String)realRequest.getAuthenticateState()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ListAuthenticationsResponse.class);
        return (ListAuthenticationsResponse)httpResponse.getServiceResponse();
    }

    public PreOrderAuthenticationResponse preOrderAuthentication(PreOrderAuthenticationRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/payroll-card/authentications/pre-order";
        PreOrderAuthenticationRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, PreOrderAuthenticationResponse.class);
        return (PreOrderAuthenticationResponse)httpResponse.getServiceResponse();
    }

    public PreOrderAuthenticationWithAuthResponse preOrderAuthenticationWithAuth(PreOrderAuthenticationWithAuthRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/payroll-card/authentications/pre-order-with-auth";
        PreOrderAuthenticationWithAuthRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, PreOrderAuthenticationWithAuthResponse.class);
        return (PreOrderAuthenticationWithAuthResponse)httpResponse.getServiceResponse();
    }

    public RelationEntity getRelation(GetRelationRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/payroll-card/relations/{openid}";
        GetRelationRequest realRequest = request;
        requestPath = requestPath.replace("{openid}", UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        if (realRequest.getSubAppid() != null) {
            queryParameter.add("sub_appid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubAppid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, RelationEntity.class);
        return (RelationEntity)httpResponse.getServiceResponse();
    }

    public TokenEntity createToken(CreateTokenRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/payroll-card/tokens";
        CreateTokenRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TokenEntity.class);
        return (TokenEntity)httpResponse.getServiceResponse();
    }

    public TransferBatchEntity createTransferBatch(CreateTransferBatchRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/payroll-card/transfer-batches";
        CreateTransferBatchRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferBatchEntity.class);
        return (TransferBatchEntity)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;
        private PrivacyEncryptor encryptor;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            this.encryptor = config.createEncryptor();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder encryptor(PrivacyEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public PayrollCardService build() {
            return new PayrollCardService(this.httpClient, this.hostName, this.encryptor);
        }
    }
}

