/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.goldplan;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.goldplan.model.ChangeCustomPageStatusRequest;
import com.wechat.pay.java.service.goldplan.model.ChangeCustomPageStatusResponse;
import com.wechat.pay.java.service.goldplan.model.ChangeGoldPlanStatusRequest;
import com.wechat.pay.java.service.goldplan.model.ChangeGoldPlanStatusResponse;
import com.wechat.pay.java.service.goldplan.model.CloseAdvertisingShowRequest;
import com.wechat.pay.java.service.goldplan.model.OpenAdvertisingShowRequest;
import com.wechat.pay.java.service.goldplan.model.SetAdvertisingIndustryFilterRequest;
import java.util.Objects;

public class GoldPlanService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private GoldPlanService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public void closeAdvertisingShow(CloseAdvertisingShowRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/goldplan/merchants/close-advertising-show";
        CloseAdvertisingShowRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        this.httpClient.execute(httpRequest, null);
    }

    public void openAdvertisingShow(OpenAdvertisingShowRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/goldplan/merchants/open-advertising-show";
        OpenAdvertisingShowRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.PATCH).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        this.httpClient.execute(httpRequest, null);
    }

    public void setAdvertisingIndustryFilter(SetAdvertisingIndustryFilterRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/goldplan/merchants/set-advertising-industry-filter";
        SetAdvertisingIndustryFilterRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        this.httpClient.execute(httpRequest, null);
    }

    public ChangeCustomPageStatusResponse changeCustomPageStatus(ChangeCustomPageStatusRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/goldplan/merchants/changecustompagestatus";
        ChangeCustomPageStatusRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ChangeCustomPageStatusResponse.class);
        return (ChangeCustomPageStatusResponse)httpResponse.getServiceResponse();
    }

    public ChangeGoldPlanStatusResponse changeGoldPlanStatus(ChangeGoldPlanStatusRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/goldplan/merchants/changegoldplanstatus";
        ChangeGoldPlanStatusRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ChangeGoldPlanStatusResponse.class);
        return (ChangeGoldPlanStatusResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public GoldPlanService build() {
            return new GoldPlanService(this.httpClient, this.hostName);
        }
    }
}

