/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.slf4j.Logger;
import waffle.apache.GenericWindowsPrincipal;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

abstract class WaffleAuthenticatorBase
extends AuthenticatorBase {
    private static final Set<String> SUPPORTED_PROTOCOLS = new LinkedHashSet<String>(Arrays.asList("Negotiate", "NTLM"));
    protected String info;
    protected Logger log;
    protected PrincipalFormat principalFormat = PrincipalFormat.FQN;
    protected PrincipalFormat roleFormat = PrincipalFormat.FQN;
    protected boolean allowGuestLogin = true;
    protected Set<String> protocols = SUPPORTED_PROTOCOLS;
    protected int continueContextsTimeout = 30;
    protected IWindowsAuthProvider auth;

    WaffleAuthenticatorBase() {
    }

    public int getContinueContextsTimeout() {
        return this.continueContextsTimeout;
    }

    public void setContinueContextsTimeout(int continueContextsTimeout) {
        this.continueContextsTimeout = continueContextsTimeout;
    }

    public IWindowsAuthProvider getAuth() {
        return this.auth;
    }

    public void setAuth(IWindowsAuthProvider provider) {
        this.auth = provider;
    }

    public String getInfo() {
        return this.info;
    }

    public void setPrincipalFormat(String format) {
        this.principalFormat = PrincipalFormat.valueOf((String)format.toUpperCase(Locale.ENGLISH));
        this.log.debug("principal format: {}", (Object)this.principalFormat);
    }

    public PrincipalFormat getPrincipalFormat() {
        return this.principalFormat;
    }

    public void setRoleFormat(String format) {
        this.roleFormat = PrincipalFormat.valueOf((String)format.toUpperCase(Locale.ENGLISH));
        this.log.debug("role format: {}", (Object)this.roleFormat);
    }

    public PrincipalFormat getRoleFormat() {
        return this.roleFormat;
    }

    public boolean isAllowGuestLogin() {
        return this.allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean value) {
        this.allowGuestLogin = value;
    }

    public void setProtocols(String value) {
        String[] protocolNames;
        this.protocols = new LinkedHashSet<String>();
        for (String protocolName : protocolNames = value.split(",")) {
            if ((protocolName = protocolName.trim()).isEmpty()) continue;
            this.log.debug("init protocol: {}", (Object)protocolName);
            if (SUPPORTED_PROTOCOLS.contains(protocolName)) {
                this.protocols.add(protocolName);
                continue;
            }
            this.log.error("unsupported protocol: {}", (Object)protocolName);
            throw new RuntimeException("Unsupported protocol: " + protocolName);
        }
    }

    protected void sendUnauthorized(HttpServletResponse response) {
        try {
            for (String protocol : this.protocols) {
                response.addHeader("WWW-Authenticate", protocol);
            }
            response.setHeader("Connection", "close");
            response.sendError(401);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sendError(HttpServletResponse response, int code) {
        try {
            response.sendError(code);
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            this.log.trace("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String getAuthMethod() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal doLogin(Request request, String username, String password) throws ServletException {
        IWindowsIdentity windowsIdentity;
        this.log.debug("logging in: {}", (Object)username);
        try {
            windowsIdentity = this.auth.logonUser(username, password);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.trace("", (Throwable)e);
            return super.doLogin(request, username, password);
        }
        if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
            this.log.warn("guest login disabled: {}", (Object)windowsIdentity.getFqn());
            return super.doLogin(request, username, password);
        }
        try {
            this.log.debug("successfully logged in {} ({})", (Object)username, (Object)windowsIdentity.getSidString());
            GenericPrincipal genericPrincipal = this.createPrincipal(windowsIdentity);
            this.log.debug("roles: {}", (Object)String.join((CharSequence)", ", genericPrincipal.getRoles()));
            GenericPrincipal genericPrincipal2 = genericPrincipal;
            return genericPrincipal2;
        }
        finally {
            windowsIdentity.dispose();
        }
    }

    protected GenericPrincipal createPrincipal(IWindowsIdentity windowsIdentity) {
        return new GenericWindowsPrincipal(windowsIdentity, this.principalFormat, this.roleFormat);
    }

    public void startInternal() throws LifecycleException {
        this.log.debug("Creating a windows authentication provider with continueContextsTimeout property set to: {}", (Object)this.continueContextsTimeout);
        this.auth = new WindowsAuthProviderImpl(this.continueContextsTimeout);
        super.startInternal();
    }
}

