/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import waffle.servlet.spi.SecurityFilterProviderCollection;

public class NegotiateSecurityFilterEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(NegotiateSecurityFilterEntryPoint.class);
    private SecurityFilterProviderCollection provider;

    public NegotiateSecurityFilterEntryPoint() {
        LOGGER.debug("[waffle.spring.NegotiateEntryPoint] loaded");
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) throws IOException, ServletException {
        LOGGER.debug("[waffle.spring.NegotiateEntryPoint] commence");
        if (this.provider == null) {
            throw new ServletException("Missing NegotiateEntryPoint.Provider");
        }
        response.setStatus(401);
        response.setHeader("Connection", "keep-alive");
        this.provider.sendUnauthorized(response);
        response.flushBuffer();
    }

    public SecurityFilterProviderCollection getProvider() {
        return this.provider;
    }

    public void setProvider(SecurityFilterProviderCollection value) {
        this.provider = value;
    }
}

