/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring.boot;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.GrantedAuthority;
import waffle.servlet.spi.BasicSecurityFilterProvider;
import waffle.servlet.spi.NegotiateSecurityFilterProvider;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.servlet.spi.SecurityFilterProviderCollection;
import waffle.spring.GrantedAuthorityFactory;
import waffle.spring.NegotiateSecurityFilter;
import waffle.spring.NegotiateSecurityFilterEntryPoint;
import waffle.spring.WindowsAuthenticationProvider;
import waffle.spring.WindowsAuthenticationToken;
import waffle.spring.boot.WaffleProperties;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

@Configuration
@EnableConfigurationProperties(value={WaffleProperties.class})
public class WaffleAutoConfiguration {
    private final WaffleProperties properties;

    public WaffleAutoConfiguration(WaffleProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public WindowsAuthProviderImpl waffleWindowsAuthProvider() {
        return new WindowsAuthProviderImpl();
    }

    @Bean
    @ConditionalOnMissingBean(name={"defaultGrantedAuthority"})
    public GrantedAuthority defaultGrantedAuthority() {
        return WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY;
    }

    @Bean
    @ConditionalOnMissingBean
    public GrantedAuthorityFactory grantedAuthorityFactory() {
        return WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY_FACTORY;
    }

    @Bean
    @ConditionalOnMissingBean
    public WindowsAuthenticationProvider waffleSpringAuthenticationProvider(WindowsAuthProviderImpl waffleWindowsAuthProvider, @Qualifier(value="defaultGrantedAuthority") GrantedAuthority defaultGrantedAuthority, GrantedAuthorityFactory grantedAuthorityFactory) {
        WindowsAuthenticationProvider bean = new WindowsAuthenticationProvider();
        bean.setAuthProvider((IWindowsAuthProvider)waffleWindowsAuthProvider);
        bean.setPrincipalFormat(this.properties.getPrincipalFormat());
        bean.setRoleFormat(this.properties.getRoleFormat());
        bean.setAllowGuestLogin(this.properties.isAllowGuestLogin());
        bean.setDefaultGrantedAuthority(defaultGrantedAuthority);
        bean.setGrantedAuthorityFactory(grantedAuthorityFactory);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"waffle.sso.enabled"})
    @ConditionalOnMissingBean
    public NegotiateSecurityFilterProvider negotiateSecurityFilterProvider(WindowsAuthProviderImpl windowsAuthProvider) {
        NegotiateSecurityFilterProvider bean = new NegotiateSecurityFilterProvider((IWindowsAuthProvider)windowsAuthProvider);
        bean.setProtocols(this.properties.getSso().getProtocols());
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"waffle.sso.enabled"})
    @ConditionalOnMissingBean
    public BasicSecurityFilterProvider basicSecurityFilterProvider(WindowsAuthProviderImpl windowsAuthProvider) {
        return new BasicSecurityFilterProvider((IWindowsAuthProvider)windowsAuthProvider);
    }

    @Bean
    @ConditionalOnProperty(value={"waffle.sso.enabled"})
    @ConditionalOnMissingBean
    public SecurityFilterProviderCollection waffleSecurityFilterProviderCollection(NegotiateSecurityFilterProvider negotiateProvider, BasicSecurityFilterProvider basicProvider) {
        SecurityFilterProvider[] providers = this.properties.getSso().isBasicEnabled() ? new SecurityFilterProvider[]{negotiateProvider, basicProvider} : new SecurityFilterProvider[]{negotiateProvider};
        return new SecurityFilterProviderCollection(providers);
    }

    @Bean
    @ConditionalOnProperty(value={"waffle.sso.enabled"})
    @ConditionalOnMissingBean
    public NegotiateSecurityFilterEntryPoint negotiateSecurityFilterEntryPoint(SecurityFilterProviderCollection providers) {
        NegotiateSecurityFilterEntryPoint bean = new NegotiateSecurityFilterEntryPoint();
        bean.setProvider(providers);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"waffle.sso.enabled"})
    @ConditionalOnMissingBean
    public NegotiateSecurityFilter waffleNegotiateSecurityFilter(SecurityFilterProviderCollection providers, @Qualifier(value="defaultGrantedAuthority") GrantedAuthority defaultGrantedAuthority, GrantedAuthorityFactory grantedAuthorityFactory) {
        NegotiateSecurityFilter bean = new NegotiateSecurityFilter();
        bean.setProvider(providers);
        bean.setPrincipalFormat(this.properties.getPrincipalFormat());
        bean.setRoleFormat(this.properties.getRoleFormat());
        bean.setAllowGuestLogin(this.properties.isAllowGuestLogin());
        bean.setImpersonate(this.properties.getSso().isImpersonate());
        bean.setDefaultGrantedAuthority(defaultGrantedAuthority);
        bean.setGrantedAuthorityFactory(grantedAuthorityFactory);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"waffle.sso.enabled"})
    public FilterRegistrationBean waffleNegotiateSecurityFilterRegistrationBean(NegotiateSecurityFilter filter) {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        bean.setEnabled(false);
        return bean;
    }
}

