/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.SspiUtil;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsIdentityImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpersonationContextImpl;

public class WindowsSecurityContextImpl
implements IWindowsSecurityContext {
    private String principalName;
    private String securityPackage;
    private SspiUtil.ManagedSecBufferDesc token;
    private Sspi.CtxtHandle ctx;
    private IWindowsCredentialsHandle credentials;
    private boolean continueFlag;

    @Override
    public IWindowsImpersonationContext impersonate() {
        return new WindowsSecurityContextImpersonationContextImpl(this.ctx);
    }

    @Override
    public IWindowsIdentity getIdentity() {
        WinNT.HANDLEByReference phContextToken = new WinNT.HANDLEByReference();
        int rc = Secur32.INSTANCE.QuerySecurityContextToken(this.ctx, phContextToken);
        if (0 != rc) {
            throw new Win32Exception(rc);
        }
        return new WindowsIdentityImpl(phContextToken.getValue());
    }

    @Override
    public String getSecurityPackage() {
        return this.securityPackage;
    }

    @Override
    public byte[] getToken() {
        return this.token == null || this.token.getBuffer(0).getBytes() == null ? null : (byte[])this.token.getBuffer(0).getBytes().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWindowsSecurityContext getCurrent(String securityPackage, String targetName) {
        IWindowsCredentialsHandle credentialsHandle = WindowsCredentialsHandleImpl.getCurrent(securityPackage);
        credentialsHandle.initialize();
        try {
            WindowsSecurityContextImpl ctx = new WindowsSecurityContextImpl();
            ctx.setPrincipalName(WindowsAccountImpl.getCurrentUsername());
            ctx.setCredentialsHandle(credentialsHandle);
            ctx.setSecurityPackage(securityPackage);
            ctx.initialize(null, null, targetName);
            credentialsHandle = null;
            WindowsSecurityContextImpl windowsSecurityContextImpl = ctx;
            return windowsSecurityContextImpl;
        }
        finally {
            if (credentialsHandle != null) {
                credentialsHandle.dispose();
            }
        }
    }

    @Override
    public void initialize(Sspi.CtxtHandle continueCtx, Sspi.SecBufferDesc continueToken, String targetName) {
        int rc;
        IntByReference attr = new IntByReference();
        this.ctx = new Sspi.CtxtHandle();
        int tokenSize = 12288;
        do {
            this.token = new SspiUtil.ManagedSecBufferDesc(2, tokenSize);
            rc = Secur32.INSTANCE.InitializeSecurityContext(this.credentials.getHandle(), continueCtx, targetName, 2048, 0, 16, continueToken, 0, this.ctx, (Sspi.SecBufferDesc)this.token, attr, null);
            switch (rc) {
                case -2146893056: 
                case -2146893023: {
                    tokenSize += 12288;
                    break;
                }
                case 590610: {
                    this.continueFlag = true;
                    break;
                }
                case 0: {
                    this.continueFlag = false;
                    break;
                }
                default: {
                    throw new Win32Exception(rc);
                }
            }
        } while (rc == -2146893056 || rc == -2146893023);
    }

    @Override
    public void dispose() {
        WindowsSecurityContextImpl.dispose(this.ctx);
        if (this.credentials != null) {
            this.credentials.dispose();
        }
    }

    public static boolean dispose(Sspi.CtxtHandle ctx) {
        if (ctx != null && !ctx.isNull()) {
            int rc = Secur32.INSTANCE.DeleteSecurityContext(ctx);
            if (0 != rc) {
                throw new Win32Exception(rc);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String value) {
        this.principalName = value;
    }

    @Override
    public Sspi.CtxtHandle getHandle() {
        return this.ctx;
    }

    public void setCredentialsHandle(IWindowsCredentialsHandle handle) {
        this.credentials = handle;
    }

    public void setToken(byte[] bytes) {
        this.token = new SspiUtil.ManagedSecBufferDesc(2, bytes);
    }

    public void setSecurityPackage(String value) {
        this.securityPackage = value;
    }

    public void setSecurityContext(Sspi.CtxtHandle phNewServerContext) {
        this.ctx = phNewServerContext;
    }

    @Override
    public boolean isContinue() {
        return this.continueFlag;
    }

    public void setContinue(boolean b) {
        this.continueFlag = b;
    }
}

