/*
 * Decompiled with CFR 0.152.
 */
package com.creative.studio.component.dependency.plugins;

import com.creative.studio.component.dependency.ComponentContainer;
import com.creative.studio.component.dependency.ComponentEntry;
import com.creative.studio.component.dependency.ComponentFormat;
import com.creative.studio.component.dependency.DependencyMediator;
import com.creative.studio.component.dependency.plugins.DefaultDependencyResolver;
import com.creative.studio.component.dependency.plugins.DependencyResolutionResult;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;

@Mojo(name="check", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VERIFY)
public class DependencyMediatorMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private DependencyTreeBuilder dependencyTreeBuilder;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="printIncompatibleDetails", defaultValue="true")
    private boolean printIncompatibleDetails;
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="includes")
    private String includes;
    @Parameter(property="excludes")
    private String excludes;
    @Parameter(defaultValue="true")
    private boolean failOnError;

    public boolean isSkip() {
        return this.skip;
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter = null;
        if (this.scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + this.scope + "'"));
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)(this.project.getArtifactId() + " skipped compatible checking"));
            return;
        }
        this.doExecute();
    }

    private void processPackage() throws MojoExecutionException {
        try {
            ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
            DefaultDependencyResolver dependencyResolver = new DefaultDependencyResolver();
            DependencyNode rootNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, artifactFilter);
            DependencyResolutionResult drr = dependencyResolver.resolve(rootNode);
            Map<String, List<Artifact>> conflictDependencyArtifact = drr.getConflictDependencyArtifact();
            Map<String, Artifact> results = drr.getResolvedDependenciesByName();
            if (!conflictDependencyArtifact.isEmpty()) {
                for (Map.Entry<String, List<Artifact>> conflictEntries : conflictDependencyArtifact.entrySet()) {
                    StringBuilder sb = new StringBuilder("Founded conflicting dependency component:");
                    List<Artifact> conflictArtifacts = conflictEntries.getValue();
                    sb.append(conflictEntries.getKey()).append("\n Resolved version is " + results.get(conflictEntries.getKey())).append("\n But found conflicting artifact ");
                    for (Artifact at : conflictArtifacts) {
                        sb.append(String.format("%s:%s:%s,", at.getGroupId(), at.getArtifactId(), at.getVersion()));
                    }
                    this.getLog().warn(sb.subSequence(0, sb.length() - 1));
                }
            }
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Cannot build project dependency ", (Exception)((Object)e));
        }
    }

    private void doExecute() throws MojoExecutionException {
        Model model = this.project.getModel();
        String packagingType = model.getPackaging();
        if (ComponentFormat.WAR.getValue().equalsIgnoreCase(packagingType)) {
            this.processWarPackage();
            this.printResult();
        } else {
            this.processPackage();
        }
    }

    private void processWarPackage() throws MojoExecutionException {
        File dependencyFolder = new File(new File(new File(this.project.getBuild().getDirectory()), this.project.getBuild().getFinalName()), "WEB-INF/lib");
        if (!dependencyFolder.exists()) {
            throw new MojoExecutionException(dependencyFolder + " not exits, please execute mvn install first");
        }
        File[] jarFiles = this.listFiles(dependencyFolder);
        if (jarFiles == null || jarFiles.length == 0) {
            this.getLog().info((CharSequence)("No dependencies for " + this.project.getArtifactId()));
            System.exit(0);
        }
        try {
            this.processJarFiles(jarFiles);
        }
        catch (IOException e) {
            String message = "Failed to process  " + this.project.getArtifactId();
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    private void processJarFiles(File[] jarFiles) throws IOException {
        for (File file : jarFiles) {
            DependencyMediator.processJarFile((File)file, (boolean)true);
        }
    }

    private void printResult() {
        this.getLog().info((CharSequence)"Output component reactor info......");
        int count = 0;
        for (Map.Entry entry : ComponentContainer.compMaps.entrySet()) {
            if (((TreeSet)entry.getValue()).size() <= 1) continue;
            ++count;
            this.getLog().warn((CharSequence)String.format("Conflicting component  [%s] was founded in the  path : \n", entry.getKey()));
            for (ComponentEntry jar : (TreeSet)entry.getValue()) {
                this.getLog().warn((CharSequence)String.format(" \t%s\n", jar.getPathName()));
            }
        }
        if (count == 0) {
            this.getLog().info((CharSequence)"Congratulations,no conflicting component  exist!");
        }
    }

    private File[] listFiles(File dependencyFolder) {
        return dependencyFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return DependencyMediator.JAR_FILE_PATTERN.matcher(name).matches();
            }
        });
    }
}

