/*
 * Decompiled with CFR 0.152.
 */
package com.github.jfasttext;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.annotation.ByPtrPtr;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.MemberSetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.javacpp.annotation.ValueSetter;

public class FastTextWrapper
extends com.github.jfasttext.config.FastTextWrapper {
    static {
        Loader.load();
    }

    @Namespace(value="FastTextWrapper")
    @NoOffset
    public static class FastTextApi
    extends Pointer {
        public FastTextApi(Pointer p) {
            super(p);
        }

        public FastTextApi(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        private native void allocateArray(long var1);

        public FastTextApi position(long position) {
            return (FastTextApi)super.position(position);
        }

        public FastTextApi() {
            super((Pointer)null);
            this.allocate();
        }

        private native void allocate();

        public native void runCmd(int var1, @Cast(value={"char**"}) PointerPointer var2);

        public native void runCmd(int var1, @Cast(value={"char**"}) @ByPtrPtr BytePointer var2);

        public native void runCmd(int var1, @Cast(value={"char**"}) @ByPtrPtr ByteBuffer var2);

        public native void runCmd(int var1, @Cast(value={"char**"}) @ByPtrPtr byte[] var2);

        @Cast(value={"bool"})
        public native boolean checkModel(@StdString BytePointer var1);

        @Cast(value={"bool"})
        public native boolean checkModel(@StdString String var1);

        public native void loadModel(@StdString BytePointer var1);

        public native void loadModel(@StdString String var1);

        public native void unloadModel();

        public native void test(@StdString BytePointer var1, int var2);

        public native void test(@StdString String var1, int var2);

        @ByVal
        public native StringVector predict(@StdString BytePointer var1, int var2);

        @ByVal
        public native StringVector predict(@StdString String var1, int var2);

        @ByVal
        public native FloatStringPairVector predictProba(@StdString BytePointer var1, int var2);

        @ByVal
        public native FloatStringPairVector predictProba(@StdString String var1, int var2);

        @ByVal
        public native RealVector getVector(@StdString BytePointer var1);

        @ByVal
        public native RealVector getVector(@StdString String var1);

        @ByVal
        public native StringVector getWords();

        @ByVal
        public native StringVector getLabels();

        @StdString
        public native BytePointer getWord(int var1);

        public native int getNWords();

        @StdString
        public native BytePointer getLabel(int var1);

        public native int getNLabels();

        public native double getLr();

        public native int getLrUpdateRate();

        public native int getDim();

        public native int getContextWindowSize();

        public native int getEpoch();

        public native int getMinCount();

        public native int getMinCountLabel();

        public native int getNSampledNegatives();

        public native int getWordNgrams();

        @StdString
        public native BytePointer getLossName();

        @StdString
        public native BytePointer getModelName();

        public native int getBucket();

        public native int getMinn();

        public native int getMaxn();

        public native double getSamplingThreshold();

        @StdString
        public native BytePointer getLabelPrefix();

        @StdString
        public native BytePointer getPretrainedVectorsFileName();

        static {
            Loader.load();
        }
    }

    @NoOffset
    @Name(value={"std::pair<fasttext::real,int32_t>"})
    public static class DoubleIntPair
    extends Pointer {
        public DoubleIntPair(Pointer p) {
            super(p);
        }

        public DoubleIntPair(float firstValue, int secondValue) {
            this();
            this.put(firstValue, secondValue);
        }

        public DoubleIntPair() {
            this.allocate();
        }

        private native void allocate();

        @Name(value={"operator="})
        @ByRef
        public native DoubleIntPair put(@ByRef DoubleIntPair var1);

        @MemberGetter
        @ByRef
        public native float first();

        public native DoubleIntPair first(float var1);

        @MemberGetter
        public native int second();

        public native DoubleIntPair second(int var1);

        public DoubleIntPair put(float firstValue, int secondValue) {
            this.first(firstValue);
            this.second(secondValue);
            return this;
        }

        static {
            Loader.load();
        }
    }

    @NoOffset
    @Name(value={"std::pair<fasttext::real,std::string>"})
    public static class FloatStringPair
    extends Pointer {
        public FloatStringPair(Pointer p) {
            super(p);
        }

        public FloatStringPair(float firstValue, BytePointer secondValue) {
            this();
            this.put(firstValue, secondValue);
        }

        public FloatStringPair(float firstValue, String secondValue) {
            this();
            this.put(firstValue, secondValue);
        }

        public FloatStringPair() {
            this.allocate();
        }

        private native void allocate();

        @Name(value={"operator="})
        @ByRef
        public native FloatStringPair put(@ByRef FloatStringPair var1);

        @MemberGetter
        @ByRef
        public native float first();

        public native FloatStringPair first(float var1);

        @MemberGetter
        @StdString
        public native BytePointer second();

        public native FloatStringPair second(BytePointer var1);

        @MemberSetter
        @Index
        public native FloatStringPair second(@StdString String var1);

        public FloatStringPair put(float firstValue, BytePointer secondValue) {
            this.first(firstValue);
            this.second(secondValue);
            return this;
        }

        public FloatStringPair put(float firstValue, String secondValue) {
            this.first(firstValue);
            this.second(secondValue);
            return this;
        }

        static {
            Loader.load();
        }
    }

    @Name(value={"std::vector<std::pair<fasttext::real,std::string> >"})
    public static class FloatStringPairVector
    extends Pointer {
        public FloatStringPairVector(Pointer p) {
            super(p);
        }

        public FloatStringPairVector(float[] firstValue, BytePointer[] secondValue) {
            this(Math.min(firstValue.length, secondValue.length));
            this.put(firstValue, secondValue);
        }

        public FloatStringPairVector(float[] firstValue, String[] secondValue) {
            this(Math.min(firstValue.length, secondValue.length));
            this.put(firstValue, secondValue);
        }

        public FloatStringPairVector() {
            this.allocate();
        }

        public FloatStringPairVector(long n) {
            this.allocate(n);
        }

        private native void allocate();

        private native void allocate(@Cast(value={"size_t"}) long var1);

        @Name(value={"operator="})
        @ByRef
        public native FloatStringPairVector put(@ByRef FloatStringPairVector var1);

        public native long size();

        public native void resize(@Cast(value={"size_t"}) long var1);

        @Index
        @ByRef
        public native float first(@Cast(value={"size_t"}) long var1);

        public native FloatStringPairVector first(@Cast(value={"size_t"}) long var1, float var3);

        @Index
        @StdString
        public native BytePointer second(@Cast(value={"size_t"}) long var1);

        public native FloatStringPairVector second(@Cast(value={"size_t"}) long var1, BytePointer var3);

        @MemberSetter
        @Index
        public native FloatStringPairVector second(@Cast(value={"size_t"}) long var1, @StdString String var3);

        public FloatStringPairVector put(float[] firstValue, BytePointer[] secondValue) {
            for (int i = 0; i < firstValue.length && i < secondValue.length; ++i) {
                this.first(i, firstValue[i]);
                this.second((long)i, secondValue[i]);
            }
            return this;
        }

        public FloatStringPairVector put(float[] firstValue, String[] secondValue) {
            for (int i = 0; i < firstValue.length && i < secondValue.length; ++i) {
                this.first(i, firstValue[i]);
                this.second((long)i, secondValue[i]);
            }
            return this;
        }

        static {
            Loader.load();
        }
    }

    @Name(value={"std::vector<fasttext::real>"})
    public static class RealVector
    extends Pointer {
        public RealVector(Pointer p) {
            super(p);
        }

        public RealVector(float ... array) {
            this(array.length);
            this.put(array);
        }

        public RealVector() {
            this.allocate();
        }

        public RealVector(long n) {
            this.allocate(n);
        }

        private native void allocate();

        private native void allocate(@Cast(value={"size_t"}) long var1);

        @Name(value={"operator="})
        @ByRef
        public native RealVector put(@ByRef RealVector var1);

        public native long size();

        public native void resize(@Cast(value={"size_t"}) long var1);

        @Index
        @ByRef
        public native float get(@Cast(value={"size_t"}) long var1);

        public native RealVector put(@Cast(value={"size_t"}) long var1, float var3);

        public RealVector put(float ... array) {
            if (this.size() != (long)array.length) {
                this.resize(array.length);
            }
            for (int i = 0; i < array.length; ++i) {
                this.put(i, array[i]);
            }
            return this;
        }

        static {
            Loader.load();
        }
    }

    @Name(value={"std::vector<std::string>"})
    public static class StringVector
    extends Pointer {
        public StringVector(Pointer p) {
            super(p);
        }

        public StringVector(BytePointer ... array) {
            this(array.length);
            this.put(array);
        }

        public StringVector(String ... array) {
            this(array.length);
            this.put(array);
        }

        public StringVector() {
            this.allocate();
        }

        public StringVector(long n) {
            this.allocate(n);
        }

        private native void allocate();

        private native void allocate(@Cast(value={"size_t"}) long var1);

        @Name(value={"operator="})
        @ByRef
        public native StringVector put(@ByRef StringVector var1);

        public native long size();

        public native void resize(@Cast(value={"size_t"}) long var1);

        @Index
        @StdString
        public native BytePointer get(@Cast(value={"size_t"}) long var1);

        public native StringVector put(@Cast(value={"size_t"}) long var1, BytePointer var3);

        @ValueSetter
        @Index
        public native StringVector put(@Cast(value={"size_t"}) long var1, @StdString String var3);

        public StringVector put(BytePointer ... array) {
            if (this.size() != (long)array.length) {
                this.resize(array.length);
            }
            for (int i = 0; i < array.length; ++i) {
                this.put((long)i, array[i]);
            }
            return this;
        }

        public StringVector put(String ... array) {
            if (this.size() != (long)array.length) {
                this.resize(array.length);
            }
            for (int i = 0; i < array.length; ++i) {
                this.put((long)i, array[i]);
            }
            return this;
        }

        static {
            Loader.load();
        }
    }
}

