/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import java.io.IOException;
import org.calrissian.mango.collect.AbstractCloseableIterator;

public class QueryResultIterator<T>
extends AbstractCloseableIterator<T> {
    private final MongoIterable<T> mongoIterable;
    private final MongoCursor<T> mongoCursor;

    public QueryResultIterator(MongoIterable<T> mongoIterable) {
        this.mongoIterable = mongoIterable;
        this.mongoCursor = mongoIterable.iterator();
    }

    public QueryResultIterator(long count) {
        this.mongoIterable = null;
        this.mongoCursor = new LongMongoCursor(count);
    }

    protected T computeNext() {
        if (this.mongoCursor.hasNext()) {
            return (T)this.mongoCursor.next();
        }
        if (this.mongoCursor != null) {
            this.mongoCursor.close();
        }
        return (T)this.endOfData();
    }

    public void close() throws IOException {
        if (this.mongoCursor != null) {
            this.mongoCursor.close();
        }
    }

    private static class LongMongoCursor<T>
    extends AbstractCloseableIterator<T>
    implements MongoCursor<T> {
        private final Long count;
        private boolean returned = false;

        private LongMongoCursor(Long count) {
            this.count = count;
        }

        protected T computeNext() {
            if (!this.returned) {
                this.returned = true;
                return (T)this.count;
            }
            return (T)this.endOfData();
        }

        public T tryNext() {
            return null;
        }

        public ServerCursor getServerCursor() {
            return null;
        }

        public ServerAddress getServerAddress() {
            return null;
        }

        public void close() {
        }
    }
}

