/*
 * Decompiled with CFR 0.152.
 */
package viethoa.com.snackbar;

import android.app.Activity;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.schedulers.Schedulers;
import viethoa.com.snackbar.SnackBar;
import viethoa.com.snackbar.animations.BaseEffects;
import viethoa.com.snackbar.animations.SlideBottom;
import viethoa.com.snackbar.animations.SlideTop;

public class SnackBarMessage<T extends SnackBar>
implements BaseEffects.AnimationListener,
SnackBar.SnackBarListener {
    private final String TAG = SnackBarMessage.class.getSimpleName();
    private Activity context;
    private Subscription timeInterval;
    private LinkedList<T> snackBarMessages;
    private ViewGroup.LayoutParams snackBarParams;
    private SnackBar currentShowingSnackBar;

    public SnackBarMessage(Activity activity) {
        this.context = activity;
        this.snackBarMessages = new LinkedList();
        this.snackBarParams = new ViewGroup.LayoutParams(-1, -1);
    }

    protected synchronized void showNotification(T snackBar) {
        ((SnackBar)snackBar).setListener(this);
        this.snackBarMessages.add(snackBar);
        if (this.currentShowingSnackBar != null && this.currentShowingSnackBar.isCloseable()) {
            return;
        }
        this.startTimeInterval();
    }

    private void startTimeInterval() {
        if (this.timeInterval != null && !this.timeInterval.isUnsubscribed()) {
            return;
        }
        this.timeInterval = Observable.interval((long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Long>(){

            public void call(Long tick) {
                SnackBarMessage.this.performShowNotification(tick);
            }
        });
    }

    private void performShowNotification(long tick) {
        if (tick % 35L != 0L) {
            return;
        }
        if (this.snackBarMessages == null || this.snackBarMessages.size() <= 0) {
            this.stopNotificationInterval();
            return;
        }
        this.currentShowingSnackBar = (SnackBar)this.snackBarMessages.poll();
        if (this.currentShowingSnackBar.isCloseable()) {
            this.stopNotificationInterval();
        }
        this.showSnackBarMessage(this.currentShowingSnackBar);
    }

    private void stopNotificationInterval() {
        if (this.timeInterval == null || this.timeInterval.isUnsubscribed()) {
            return;
        }
        this.timeInterval.unsubscribe();
        this.timeInterval = null;
    }

    public void showSnackBarMessage(SnackBar snackBar) {
        if (snackBar == null || this.context == null || this.context.isFinishing()) {
            return;
        }
        if (snackBar.getParent() != null) {
            return;
        }
        this.context.addContentView(snackBar.getView(), this.snackBarParams);
        if (snackBar.isAnimationFromTop()) {
            SlideTop slideTop = new SlideTop();
            slideTop.setDuration(300L);
            slideTop.setListener(this);
            slideTop.start(snackBar.getView());
        } else {
            SlideBottom slideBottom = new SlideBottom();
            slideBottom.setDuration(300L);
            slideBottom.setListener(this);
            slideBottom.start(snackBar.getView());
        }
    }

    private void dismissSnackBarMessage(View viewGroup) {
        if (viewGroup == null) {
            return;
        }
        ViewGroup parent = (ViewGroup)viewGroup.getParent();
        if (parent == null) {
            return;
        }
        parent.removeView(viewGroup);
    }

    @Override
    public void onAnimationEnd(final View view) {
        if (view == null) {
            return;
        }
        if (this.currentShowingSnackBar != null && this.currentShowingSnackBar.isCloseable()) {
            return;
        }
        int delayTimeInterval = 3100;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SnackBarMessage.this.dismissSnackBarMessage(view);
            }
        }, (long)delayTimeInterval);
    }

    @Override
    public void OnBtnCloseClicked(View snackBar) {
        this.dismissSnackBarMessage(snackBar);
        this.currentShowingSnackBar = null;
        if (this.snackBarMessages == null || this.snackBarMessages.size() <= 0) {
            return;
        }
        this.startTimeInterval();
    }
}

