/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.swagger15;

import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.module.swagger15.SwaggerOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SwaggerModule
implements Module {
    private static final String OPENING_BRACKET = Pattern.quote("(") + '|' + Pattern.quote("[");
    private static final String NUMBER_OR_NEGATIVE_INFINITE = "-?[0-9]+\\.?[0-9]*|-infinity";
    private static final String NUMBER_OR_INFINITE = "-?[0-9]+\\.?[0-9]*|infinity";
    private static final String CLOSING_BRACKET = Pattern.quote(")") + '|' + Pattern.quote("]");
    private static final Pattern ALLOWABLE_VALUES_RANGE = Pattern.compile("range(" + OPENING_BRACKET + ")(" + "-?[0-9]+\\.?[0-9]*|-infinity" + "), *(" + "-?[0-9]+\\.?[0-9]*|infinity" + ")(" + CLOSING_BRACKET + ")");
    private final List<SwaggerOption> options;

    public SwaggerModule(SwaggerOption ... options) {
        this.options = options == null ? Collections.emptyList() : Arrays.asList(options);
    }

    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        SchemaGeneratorConfigPart fieldConfigPart = builder.forFields();
        this.applyToConfigPart(fieldConfigPart);
        if (this.options.contains((Object)SwaggerOption.ENABLE_PROPERTY_NAME_OVERRIDES)) {
            fieldConfigPart.withPropertyNameOverrideResolver(this::resolvePropertyNameOverride);
        }
        this.applyToConfigPart(builder.forMethods());
        if (!this.options.contains((Object)SwaggerOption.NO_APIMODEL_TITLE)) {
            builder.forTypesInGeneral().withTitleResolver(this::resolveTitleForType);
        }
        if (!this.options.contains((Object)SwaggerOption.NO_APIMODEL_DESCRIPTION)) {
            builder.forTypesInGeneral().withDescriptionResolver(this::resolveDescriptionForType);
        }
    }

    private void applyToConfigPart(SchemaGeneratorConfigPart<?> configPart) {
        if (this.options.contains((Object)SwaggerOption.IGNORING_HIDDEN_PROPERTIES)) {
            configPart.withIgnoreCheck(this::shouldIgnore);
        }
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withNumberExclusiveMinimumResolver(this::resolveNumberExclusiveMinimum);
        configPart.withNumberInclusiveMinimumResolver(this::resolveNumberInclusiveMinimum);
        configPart.withNumberExclusiveMaximumResolver(this::resolveNumberExclusiveMaximum);
        configPart.withNumberInclusiveMaximumResolver(this::resolveNumberInclusiveMaximum);
        configPart.withEnumResolver(this::resolveAllowedValues);
    }

    protected boolean shouldIgnore(MemberScope<?, ?> member) {
        ApiModelProperty annotation = (ApiModelProperty)member.getAnnotationConsideringFieldAndGetter(ApiModelProperty.class);
        return annotation != null && annotation.hidden();
    }

    protected String resolvePropertyNameOverride(FieldScope field) {
        return Optional.ofNullable(field.getAnnotationConsideringFieldAndGetter(ApiModelProperty.class)).map(ApiModelProperty::name).filter(name -> !name.isEmpty() && !name.equals(field.getName())).orElse(null);
    }

    protected String resolveDescription(MemberScope<?, ?> member) {
        if (member.isFakeContainerItemScope()) {
            return null;
        }
        return Optional.ofNullable(member.getAnnotationConsideringFieldAndGetter(ApiModelProperty.class)).map(ApiModelProperty::value).filter(value -> !value.isEmpty()).orElse(null);
    }

    protected String resolveDescriptionForType(TypeScope scope) {
        return Optional.ofNullable(scope.getType()).map(type -> type.getErasedType().getAnnotation(ApiModel.class)).map(ApiModel::description).filter(description -> !description.isEmpty()).orElse(null);
    }

    protected String resolveTitleForType(TypeScope scope) {
        return Optional.ofNullable(scope.getType()).map(type -> type.getErasedType().getAnnotation(ApiModel.class)).map(ApiModel::value).filter(title -> !title.isEmpty()).orElse(null);
    }

    private Optional<String> findModelPropertyAllowableValues(MemberScope<?, ?> member) {
        if (member.isFakeContainerItemScope()) {
            return Optional.empty();
        }
        return Optional.ofNullable(member.getAnnotationConsideringFieldAndGetter(ApiModelProperty.class)).map(ApiModelProperty::allowableValues).filter(allowableValues -> !allowableValues.isEmpty());
    }

    protected List<String> resolveAllowedValues(MemberScope<?, ?> member) {
        return this.findModelPropertyAllowableValues(member).filter(allowableValues -> !ALLOWABLE_VALUES_RANGE.matcher((CharSequence)allowableValues).matches()).map(allowableValues -> Arrays.asList(allowableValues.split(", *"))).orElse(null);
    }

    protected BigDecimal resolveNumberInclusiveMinimum(MemberScope<?, ?> member) {
        return this.resolveNumberMinimum(member, "[");
    }

    protected BigDecimal resolveNumberExclusiveMinimum(MemberScope<?, ?> member) {
        return this.resolveNumberMinimum(member, "(");
    }

    private BigDecimal resolveNumberMinimum(MemberScope<?, ?> member, String inclusiveIndicator) {
        Matcher matcher;
        String allowableValues = this.findModelPropertyAllowableValues(member).orElse(null);
        if (allowableValues != null && (matcher = ALLOWABLE_VALUES_RANGE.matcher(allowableValues)).matches() && inclusiveIndicator.equals(matcher.group(1)) && !"-infinity".equals(matcher.group(2))) {
            return new BigDecimal(matcher.group(2));
        }
        return null;
    }

    protected BigDecimal resolveNumberInclusiveMaximum(MemberScope<?, ?> member) {
        return this.resolveNumberMaximum(member, "]");
    }

    protected BigDecimal resolveNumberExclusiveMaximum(MemberScope<?, ?> member) {
        return this.resolveNumberMaximum(member, ")");
    }

    private BigDecimal resolveNumberMaximum(MemberScope<?, ?> member, String inclusiveIndicator) {
        Matcher matcher;
        String allowableValues = this.findModelPropertyAllowableValues(member).orElse(null);
        if (allowableValues != null && (matcher = ALLOWABLE_VALUES_RANGE.matcher(allowableValues)).matches() && inclusiveIndicator.equals(matcher.group(4)) && !"infinity".equals(matcher.group(3))) {
            return new BigDecimal(matcher.group(3));
        }
        return null;
    }
}

