/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.victools.jsonschema.generator.AnnotationHelper;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.impl.PropertySortUtils;
import com.github.victools.jsonschema.module.jackson.JacksonSchemaModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonPropertySorter
implements Comparator<MemberScope<?, ?>> {
    private final boolean sortAlphabeticallyIfNotAnnotated;
    private final Map<Class<?>, List<String>> propertyOrderPerDeclaringType = new HashMap();
    private final Map<Class<?>, Boolean> enabledAlphabeticSorting = new HashMap();

    public JsonPropertySorter(boolean sortAlphabeticallyIfNotAnnotated) {
        this.sortAlphabeticallyIfNotAnnotated = sortAlphabeticallyIfNotAnnotated;
    }

    @Override
    public int compare(MemberScope<?, ?> first, MemberScope<?, ?> second) {
        int result = PropertySortUtils.SORT_PROPERTIES_FIELDS_BEFORE_METHODS.compare(first, second);
        if (result == 0) {
            result = this.getPropertyIndex(first) - this.getPropertyIndex(second);
        }
        if (result == 0 && Stream.of(first, second).map(property -> property.getDeclaringType().getErasedType()).anyMatch(parentType -> this.enabledAlphabeticSorting.computeIfAbsent((Class<?>)parentType, this::shouldSortPropertiesAlphabetically))) {
            result = PropertySortUtils.SORT_PROPERTIES_BY_NAME_ALPHABETICALLY.compare(first, second);
        }
        return result;
    }

    protected int getPropertyIndex(MemberScope<?, ?> property) {
        String fieldName;
        HierarchicType topMostHierarchyType = (HierarchicType)property.getDeclaringTypeMembers().allTypesAndOverrides().get(0);
        List sortedProperties = this.propertyOrderPerDeclaringType.computeIfAbsent(topMostHierarchyType.getErasedType(), this::getAnnotatedPropertyOrder);
        if (property instanceof MethodScope) {
            MethodScope method = (MethodScope)property;
            fieldName = Optional.ofNullable(method.findGetterField()).orElse((FieldScope)property).getSchemaPropertyName();
        } else {
            fieldName = property.getSchemaPropertyName();
        }
        int propertyIndex = sortedProperties.indexOf(fieldName);
        if (propertyIndex == -1) {
            propertyIndex = Integer.MAX_VALUE;
        }
        return propertyIndex;
    }

    protected boolean shouldSortPropertiesAlphabetically(Class<?> declaringType) {
        return AnnotationHelper.resolveAnnotation(declaringType, JsonPropertyOrder.class, JacksonSchemaModule.NESTED_ANNOTATION_CHECK).map(JsonPropertyOrder::alphabetic).orElse(this.sortAlphabeticallyIfNotAnnotated);
    }

    private List<String> getAnnotatedPropertyOrder(Class<?> declaringType) {
        return AnnotationHelper.resolveAnnotation(declaringType, JsonPropertyOrder.class, JacksonSchemaModule.NESTED_ANNOTATION_CHECK).map(JsonPropertyOrder::value).filter(valueArray -> ((String[])valueArray).length != 0).map(Arrays::asList).orElseGet(Collections::emptyList);
    }
}

