/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.plugin.maven;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public class GlobHandler {
    public static Predicate<String> createClassOrPackageNameFilter(String input, boolean forPackage) {
        return className -> GlobHandler.createClassOrPackageNamePattern(input, forPackage).matcher((CharSequence)className).matches();
    }

    public static Pattern createClassOrPackageNamePattern(String input, boolean forPackage) {
        String inputRegex = input.chars().anyMatch(c -> c == 47 || c == 42 || c == 63 || c == 43 || c == 91 || c == 123 || c == 92) ? GlobHandler.convertGlobToRegex(input) : input.replace('.', '/');
        if (forPackage) {
            inputRegex = inputRegex + (inputRegex.charAt(inputRegex.length() - 1) == '/' ? ".+" : "/.+");
        }
        return Pattern.compile(inputRegex);
    }

    private static String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append("\\\\");
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass != 0) {
                        sb.append('*');
                        continue block16;
                    }
                    if (i + 1 < arr.length && arr[i + 1] == '*') {
                        ++i;
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append("[^/]*");
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append("[^/]");
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

