/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.CustomPropertyDefinitionProvider;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.impl.MemberCollectionContextImpl;
import com.github.victools.jsonschema.generator.impl.Util;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;

public class SchemaGenerationContextImpl
implements SchemaGenerationContext {
    private static final Logger logger = LoggerFactory.getLogger(SchemaGenerationContextImpl.class);
    private final SchemaGeneratorConfig generatorConfig;
    private final TypeContext typeContext;
    private final Map<DefinitionKey, ObjectNode> definitions = new LinkedHashMap<DefinitionKey, ObjectNode>();
    private final Map<DefinitionKey, List<ObjectNode>> references = new HashMap<DefinitionKey, List<ObjectNode>>();
    private final Map<DefinitionKey, List<ObjectNode>> nullableReferences = new HashMap<DefinitionKey, List<ObjectNode>>();
    private final Set<DefinitionKey> neverInlinedDefinitions = new HashSet<DefinitionKey>();

    public SchemaGenerationContextImpl(SchemaGeneratorConfig generatorConfig, TypeContext typeContext) {
        this.generatorConfig = generatorConfig;
        this.typeContext = typeContext;
    }

    @Override
    public SchemaGeneratorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    @Override
    public TypeContext getTypeContext() {
        return this.typeContext;
    }

    public DefinitionKey parseType(ResolvedType type) {
        this.traverseGenericType(type, null);
        return new DefinitionKey(type, null);
    }

    SchemaGenerationContextImpl putDefinition(ResolvedType javaType, ObjectNode definitionNode, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        this.definitions.put(new DefinitionKey(javaType, ignoredDefinitionProvider), definitionNode);
        return this;
    }

    SchemaGenerationContextImpl markDefinitionAsNeverInlinedIfRequired(CustomDefinition customDefinition, ResolvedType javaType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        if (customDefinition.shouldAlwaysProduceDefinition()) {
            this.neverInlinedDefinitions.add(new DefinitionKey(javaType, ignoredDefinitionProvider));
        }
        return this;
    }

    public boolean containsDefinition(ResolvedType javaType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        return this.definitions.containsKey(new DefinitionKey(javaType, ignoredDefinitionProvider));
    }

    public ObjectNode getDefinition(DefinitionKey key) {
        return this.definitions.get(key);
    }

    public Set<DefinitionKey> getDefinedTypes() {
        return Collections.unmodifiableSet(this.definitions.keySet());
    }

    public SchemaGenerationContextImpl addReference(ResolvedType javaType, ObjectNode referencingNode, CustomDefinitionProviderV2 ignoredDefinitionProvider, boolean isNullable) {
        if (referencingNode == null) {
            return this;
        }
        Map<DefinitionKey, List<ObjectNode>> targetMap = isNullable ? this.nullableReferences : this.references;
        DefinitionKey key = new DefinitionKey(javaType, ignoredDefinitionProvider);
        List valueList = targetMap.computeIfAbsent(key, k -> new ArrayList());
        valueList.add(referencingNode);
        return this;
    }

    public List<ObjectNode> getReferences(DefinitionKey key) {
        return Collections.unmodifiableList(this.references.getOrDefault(key, Collections.emptyList()));
    }

    public List<ObjectNode> getNullableReferences(DefinitionKey key) {
        return Collections.unmodifiableList(this.nullableReferences.getOrDefault(key, Collections.emptyList()));
    }

    public boolean shouldNeverInlineDefinition(DefinitionKey key) {
        return this.neverInlinedDefinitions.contains(key);
    }

    @Override
    public ObjectNode createDefinition(ResolvedType targetType) {
        return this.createStandardDefinition(targetType, null);
    }

    @Override
    public ObjectNode createDefinitionReference(ResolvedType targetType) {
        return this.createStandardDefinitionReference(targetType, null);
    }

    @Override
    public ObjectNode createStandardDefinition(ResolvedType targetType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        ObjectNode definition = this.generatorConfig.createObjectNode();
        TypeScope scope = this.typeContext.createTypeScope(targetType);
        GenericTypeDetails typeDetails = new GenericTypeDetails(scope, false, true, ignoredDefinitionProvider);
        this.traverseGenericType(definition, typeDetails);
        return definition;
    }

    @Override
    public ObjectNode createStandardDefinition(FieldScope targetScope, CustomPropertyDefinitionProvider<FieldScope> ignoredDefinitionProvider) {
        return this.createFieldSchema(new MemberDetails<FieldScope>(targetScope, false, true, ignoredDefinitionProvider));
    }

    @Override
    public JsonNode createStandardDefinition(MethodScope targetScope, CustomPropertyDefinitionProvider<MethodScope> ignoredDefinitionProvider) {
        return this.createMethodSchema(new MemberDetails<MethodScope>(targetScope, false, true, ignoredDefinitionProvider));
    }

    @Override
    public ObjectNode createStandardDefinitionReference(ResolvedType targetType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        ObjectNode definition = this.generatorConfig.createObjectNode();
        TypeScope scope = this.typeContext.createTypeScope(targetType);
        GenericTypeDetails typeDetails = new GenericTypeDetails(scope, false, false, ignoredDefinitionProvider);
        this.traverseGenericType(definition, typeDetails);
        return definition;
    }

    @Override
    public ObjectNode createStandardDefinitionReference(FieldScope targetScope, CustomPropertyDefinitionProvider<FieldScope> ignoredDefinitionProvider) {
        return this.createFieldSchema(new MemberDetails<FieldScope>(targetScope, false, false, ignoredDefinitionProvider));
    }

    @Override
    public JsonNode createStandardDefinitionReference(MethodScope targetScope, CustomPropertyDefinitionProvider<MethodScope> ignoredDefinitionProvider) {
        return this.createMethodSchema(new MemberDetails<MethodScope>(targetScope, false, false, ignoredDefinitionProvider));
    }

    protected void traverseGenericType(ResolvedType targetType, ObjectNode targetNode) {
        TypeScope scope = this.typeContext.createTypeScope(targetType);
        GenericTypeDetails typeDetails = new GenericTypeDetails(scope, false, false, null);
        this.traverseGenericType(targetNode, typeDetails);
    }

    private void traverseGenericType(ObjectNode targetNode, GenericTypeDetails typeDetails) {
        Map.Entry<ObjectNode, Boolean> definitionAndTypeAttributeInclusionFlag;
        ResolvedType targetType = typeDetails.getScope().getType();
        if (this.shouldAddReferenceForExistingDefinition(typeDetails)) {
            logger.debug("adding reference to existing definition of {}", (Object)targetType);
            this.addReference(targetType, targetNode, typeDetails.getIgnoredDefinitionProvider(), typeDetails.isNullable());
            return;
        }
        CustomDefinition customDefinition = this.generatorConfig.getCustomDefinition(targetType, (SchemaGenerationContext)this, typeDetails.getIgnoredDefinitionProvider());
        if (customDefinition == null) {
            GenericTypeDetails typeDetailsWithInlineArrays = typeDetails.withAlternativeReasonToInline(this.typeContext.isContainerType(targetType) && targetNode != null);
            definitionAndTypeAttributeInclusionFlag = this.applyStandardDefinition(targetNode, typeDetailsWithInlineArrays);
        } else {
            GenericTypeDetails typeDetailsWithCustomPreference = typeDetails.withAlternativeReasonToInline(customDefinition.isMeantToBeInline());
            definitionAndTypeAttributeInclusionFlag = this.applyCustomDefinition(customDefinition, targetNode, typeDetailsWithCustomPreference);
        }
        ObjectNode definition = definitionAndTypeAttributeInclusionFlag.getKey();
        if (definitionAndTypeAttributeInclusionFlag.getValue().booleanValue()) {
            Set<String> allowedSchemaTypes = this.collectAllowedSchemaTypes(definition);
            ObjectNode typeAttributes = AttributeCollector.collectTypeAttributes(typeDetails.getScope(), this, allowedSchemaTypes);
            typeAttributes.setAll(definition);
            definition.setAll(typeAttributes);
        }
        this.generatorConfig.getTypeAttributeOverrides().forEach(override -> override.overrideTypeAttributes(definition, typeDetails.getScope(), this));
    }

    private boolean shouldAddReferenceForExistingDefinition(GenericTypeDetails typeDetails) {
        return !typeDetails.isInlineDefinition() && this.containsDefinition(typeDetails.getScope().getType(), typeDetails.getIgnoredDefinitionProvider());
    }

    private Map.Entry<ObjectNode, Boolean> applyCustomDefinition(CustomDefinition customDefinition, ObjectNode targetNode, GenericTypeDetails typeDetails) {
        ObjectNode definition;
        ResolvedType targetType = typeDetails.getScope().getType();
        if (!typeDetails.isInlineDefinition()) {
            ObjectNode definition2 = this.generatorConfig.createObjectNode();
            this.putDefinition(targetType, definition2, typeDetails.getIgnoredDefinitionProvider());
            this.addReference(targetType, targetNode, typeDetails.getIgnoredDefinitionProvider(), typeDetails.isNullable());
            this.markDefinitionAsNeverInlinedIfRequired(customDefinition, targetType, typeDetails.getIgnoredDefinitionProvider());
            logger.debug("applying configured custom definition for {}", (Object)targetType);
            definition2.setAll(customDefinition.getValue());
            return new AbstractMap.SimpleEntry<ObjectNode, Boolean>(definition2, customDefinition.shouldIncludeAttributes());
        }
        if (targetNode == null) {
            logger.debug("storing configured custom inline type for {} as definition (since it is the main schema \"#\")", (Object)targetType);
            definition = customDefinition.getValue();
            this.putDefinition(targetType, definition, typeDetails.getIgnoredDefinitionProvider());
        } else {
            logger.debug("directly applying configured custom inline type for {}", (Object)targetType);
            targetNode.setAll(customDefinition.getValue());
            definition = targetNode;
        }
        if (typeDetails.isNullable()) {
            this.makeNullable(definition);
        }
        return new AbstractMap.SimpleEntry<ObjectNode, Boolean>(definition, customDefinition.shouldIncludeAttributes());
    }

    private Map.Entry<ObjectNode, Boolean> applyStandardDefinition(ObjectNode targetNode, GenericTypeDetails typeDetails) {
        boolean includeTypeAttributes;
        ObjectNode definition;
        ResolvedType targetType = typeDetails.getScope().getType();
        if (typeDetails.isInlineDefinition()) {
            definition = targetNode;
        } else {
            definition = this.generatorConfig.createObjectNode();
            this.putDefinition(targetType, definition, typeDetails.getIgnoredDefinitionProvider());
            this.addReference(targetType, targetNode, typeDetails.getIgnoredDefinitionProvider(), typeDetails.isNullable());
        }
        if (this.typeContext.isContainerType(targetType)) {
            logger.debug("generating array definition for {}", (Object)targetType);
            this.generateArrayDefinition(typeDetails, definition);
            includeTypeAttributes = true;
        } else {
            logger.debug("generating definition for {}", (Object)targetType);
            includeTypeAttributes = !this.addSubtypeReferencesInDefinition(targetType, definition);
        }
        return new AbstractMap.SimpleEntry<ObjectNode, Boolean>(definition, includeTypeAttributes);
    }

    private boolean addSubtypeReferencesInDefinition(ResolvedType targetType, ObjectNode definition) {
        List<ResolvedType> subtypes = this.generatorConfig.resolveSubtypes(targetType, this);
        if (subtypes.isEmpty()) {
            this.generateObjectDefinition(targetType, definition);
            return false;
        }
        SchemaKeyword arrayNodeName = subtypes.size() == 1 ? SchemaKeyword.TAG_ALLOF : SchemaKeyword.TAG_ANYOF;
        ArrayNode subtypeDefinitionArrayNode = definition.withArray(this.getKeyword(arrayNodeName));
        subtypes.stream().map(this::createDefinitionReference).forEach(arg_0 -> ((ArrayNode)subtypeDefinitionArrayNode).add(arg_0));
        return true;
    }

    private Set<String> collectAllowedSchemaTypes(ObjectNode definition) {
        JsonNode declaredTypes = definition.get(this.getKeyword(SchemaKeyword.TAG_TYPE));
        Set<String> allowedSchemaTypes = declaredTypes == null ? Collections.emptySet() : (declaredTypes.isString() ? Collections.singleton(declaredTypes.stringValue()) : StreamSupport.stream(declaredTypes.spliterator(), false).map(JsonNode::stringValue).collect(Collectors.toSet()));
        return allowedSchemaTypes;
    }

    private void generateArrayDefinition(GenericTypeDetails typeDetails, ObjectNode definition) {
        definition.put(this.getKeyword(SchemaKeyword.TAG_TYPE), this.getKeyword(SchemaKeyword.TAG_TYPE_ARRAY));
        definition.set(this.getKeyword(SchemaKeyword.TAG_ITEMS), this.populateItemMemberSchema(typeDetails.getScope()));
        if (typeDetails.isNullable()) {
            this.makeNullable(definition);
        }
    }

    private JsonNode populateItemMemberSchema(TypeScope targetScope) {
        MethodScope method;
        FieldScope field;
        if (targetScope instanceof FieldScope && !(field = (FieldScope)targetScope).isFakeContainerItemScope()) {
            return this.populateFieldSchema(field.asFakeContainerItemScope());
        }
        if (targetScope instanceof MethodScope && !(method = (MethodScope)targetScope).isFakeContainerItemScope()) {
            return this.populateMethodSchema(method.asFakeContainerItemScope());
        }
        ObjectNode arrayItemDefinition = this.generatorConfig.createObjectNode();
        this.traverseGenericType(targetScope.getContainerItemType(), arrayItemDefinition);
        return arrayItemDefinition;
    }

    private void generateObjectDefinition(ResolvedType targetType, ObjectNode definition) {
        definition.put(this.getKeyword(SchemaKeyword.TAG_TYPE), this.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT));
        MemberCollectionContextImpl memberCollectionContext = new MemberCollectionContextImpl(targetType, this.generatorConfig, this.typeContext);
        memberCollectionContext.collectProperties();
        List<MemberScope<?, ?>> sortedProperties = memberCollectionContext.getSortedProperties();
        if (!sortedProperties.isEmpty()) {
            this.addPropertiesToDefinition(definition, sortedProperties, memberCollectionContext.getRequiredPropertyNames());
        }
    }

    private void addPropertiesToDefinition(ObjectNode definition, List<MemberScope<?, ?>> sortedProperties, Set<String> requiredPropertyNames) {
        ObjectNode propertiesNode = definition.putObject(this.getKeyword(SchemaKeyword.TAG_PROPERTIES));
        LinkedHashMap<String, List<String>> dependentRequires = new LinkedHashMap<String, List<String>>();
        for (MemberScope<?, ?> property : sortedProperties) {
            this.addPropertiesEntry(propertiesNode, dependentRequires, property);
        }
        if (!requiredPropertyNames.isEmpty()) {
            ArrayNode requiredNode = definition.putArray(this.getKeyword(SchemaKeyword.TAG_REQUIRED));
            sortedProperties.stream().map(MemberScope::getSchemaPropertyName).filter(requiredPropertyNames::contains).forEach(arg_0 -> ((ArrayNode)requiredNode).add(arg_0));
        }
        if (!dependentRequires.isEmpty()) {
            ObjectNode dependentRequiredNode = definition.putObject(this.getKeyword(SchemaKeyword.TAG_DEPENDENT_REQUIRED));
            dependentRequires.forEach((leadName, dependentNames) -> dependentNames.forEach(arg_0 -> ((ArrayNode)dependentRequiredNode.withArray(leadName)).add(arg_0)));
        }
    }

    private void addPropertiesEntry(ObjectNode propertiesNode, Map<String, List<String>> dependentRequires, MemberScope<?, ?> property) {
        String propertyName = property.getSchemaPropertyName();
        JsonNode subSchema = this.typeContext.performActionOnMember(property, this::populateFieldSchema, this::populateMethodSchema);
        propertiesNode.set(propertyName, subSchema);
        List dependentRequiredForProperty = this.typeContext.performActionOnMember(property, this.generatorConfig::resolveDependentRequires, this.generatorConfig::resolveDependentRequires);
        if (!Util.isNullOrEmpty(dependentRequiredForProperty)) {
            dependentRequires.put(propertyName, dependentRequiredForProperty);
        }
    }

    private JsonNode populateFieldSchema(FieldScope field) {
        boolean isNullable;
        List<ResolvedType> typeOverrides = this.generatorConfig.resolveTargetTypeOverrides(field);
        if (typeOverrides == null && this.generatorConfig.shouldTransparentlyResolveSubtypesOfMembers()) {
            typeOverrides = this.generatorConfig.resolveSubtypes(field.getType(), this);
        }
        List<FieldScope> fieldOptions = Util.isNullOrEmpty(typeOverrides) ? Collections.singletonList(field) : typeOverrides.stream().map(field::withOverriddenType).collect(Collectors.toList());
        boolean bl = isNullable = !((Field)field.getRawMember()).isEnumConstant() && (!field.isFakeContainerItemScope() || this.generatorConfig.shouldAllowNullableArrayItems()) && this.generatorConfig.isNullable(field);
        if (fieldOptions.size() == 1) {
            return this.createFieldSchema(new MemberDetails<FieldScope>(fieldOptions.get(0), isNullable, false, null));
        }
        return this.createMemberSchemaWithMultipleOptions(fieldOptions, isNullable, this::createFieldSchema);
    }

    private <M extends MemberScope<?, ?>> JsonNode createMemberSchemaWithMultipleOptions(List<M> memberOptions, boolean isNullable, Function<MemberDetails<M>, JsonNode> createMemberSchema) {
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        ArrayNode anyOfArray = subSchema.withArray(this.getKeyword(SchemaKeyword.TAG_ANYOF));
        if (isNullable) {
            anyOfArray.addObject().put(this.getKeyword(SchemaKeyword.TAG_TYPE), this.getKeyword(SchemaKeyword.TAG_TYPE_NULL));
        }
        memberOptions.stream().map(option -> new MemberDetails<MemberScope>((MemberScope)option, false, false, null)).map(createMemberSchema).forEach(arg_0 -> ((ArrayNode)anyOfArray).add(arg_0));
        return subSchema;
    }

    private ObjectNode createFieldSchema(MemberDetails<FieldScope> fieldDetails) {
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        ObjectNode fieldAttributes = AttributeCollector.collectFieldAttributes(fieldDetails.getScope(), this);
        this.populateMemberSchema(subSchema, fieldDetails, fieldAttributes);
        return subSchema;
    }

    private JsonNode populateMethodSchema(MethodScope method) {
        boolean isNullable;
        List<ResolvedType> typeOverrides = this.generatorConfig.resolveTargetTypeOverrides(method);
        if (typeOverrides == null && !method.isVoid()) {
            typeOverrides = this.generatorConfig.resolveSubtypes(method.getType(), this);
        }
        List<MethodScope> methodOptions = Util.isNullOrEmpty(typeOverrides) ? Collections.singletonList(method) : typeOverrides.stream().map(method::withOverriddenType).collect(Collectors.toList());
        boolean bl = isNullable = method.isVoid() || (!method.isFakeContainerItemScope() || this.generatorConfig.shouldAllowNullableArrayItems()) && this.generatorConfig.isNullable(method);
        if (methodOptions.size() == 1) {
            return this.createMethodSchema(new MemberDetails<MethodScope>(methodOptions.get(0), isNullable, false, null));
        }
        return this.createMemberSchemaWithMultipleOptions(methodOptions, isNullable, this::createMethodSchema);
    }

    private JsonNode createMethodSchema(MemberDetails<MethodScope> methodDetails) {
        CustomDefinition customDefinition;
        if (methodDetails.getScope().isVoid() && (customDefinition = this.generatorConfig.getCustomDefinition(methodDetails.getScope(), (SchemaGenerationContext)this, methodDetails.getIgnoredDefinitionProvider())) == null) {
            return BooleanNode.FALSE;
        }
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        ObjectNode methodAttributes = AttributeCollector.collectMethodAttributes(methodDetails.getScope(), this);
        this.populateMemberSchema(subSchema, methodDetails, methodAttributes);
        return subSchema;
    }

    private <M extends MemberScope<?, ?>> void populateMemberSchema(ObjectNode targetNode, MemberDetails<M> memberDetails, ObjectNode collectedMemberAttributes) {
        CustomDefinition customDefinition = this.generatorConfig.getCustomDefinition(memberDetails.getScope(), (SchemaGenerationContext)this, memberDetails.getIgnoredDefinitionProvider());
        boolean isInlineCustomDefinition = customDefinition != null && customDefinition.isMeantToBeInline();
        GenericTypeDetails typeDetails = memberDetails.toTypeDetails().withAlternativeReasonToInline(isInlineCustomDefinition);
        if (isInlineCustomDefinition) {
            this.populateMemberSchemaWithInlineCustomDefinition(targetNode, typeDetails, collectedMemberAttributes, customDefinition);
        } else {
            this.populateMemberSchemaWithReference(targetNode, typeDetails, collectedMemberAttributes, customDefinition);
        }
    }

    private void populateMemberSchemaWithInlineCustomDefinition(ObjectNode targetNode, GenericTypeDetails typeDetails, ObjectNode collectedMemberAttributes, CustomDefinition customDefinition) {
        if (customDefinition.getValue().isEmpty()) {
            targetNode.withArray(this.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)customDefinition.getValue());
        } else {
            targetNode.setAll(customDefinition.getValue());
        }
        if (customDefinition.shouldIncludeAttributes()) {
            AttributeCollector.mergeMissingAttributes(targetNode, collectedMemberAttributes);
            Set<String> allowedSchemaTypes = this.collectAllowedSchemaTypes(targetNode);
            ObjectNode typeAttributes = AttributeCollector.collectTypeAttributes(typeDetails.getScope(), this, allowedSchemaTypes);
            AttributeCollector.mergeMissingAttributes(targetNode, typeAttributes);
        }
        if (typeDetails.isNullable()) {
            this.makeNullable(targetNode);
        }
    }

    private void populateMemberSchemaWithReference(ObjectNode targetNode, GenericTypeDetails typeDetails, ObjectNode collectedMemberAttributes, CustomDefinition customDefinition) {
        ObjectNode referenceContainer;
        boolean ignoreCollectedAttributes;
        boolean bl = ignoreCollectedAttributes = customDefinition != null && !customDefinition.shouldIncludeAttributes() || Util.isNullOrEmpty((JsonNode)collectedMemberAttributes);
        if (ignoreCollectedAttributes) {
            referenceContainer = targetNode;
        } else if (customDefinition == null && typeDetails.getScope().isContainerType()) {
            referenceContainer = targetNode;
            AttributeCollector.mergeMissingAttributes(targetNode, collectedMemberAttributes);
        } else {
            referenceContainer = this.generatorConfig.createObjectNode();
            targetNode.putArray(this.getKeyword(SchemaKeyword.TAG_ALLOF)).add((JsonNode)referenceContainer).add((JsonNode)collectedMemberAttributes);
        }
        try {
            this.traverseGenericType(referenceContainer, typeDetails);
        }
        catch (UnsupportedOperationException ex) {
            logger.warn("Skipping type definition due to error", (Throwable)ex);
        }
    }

    @Override
    public String getKeyword(SchemaKeyword keyword) {
        return this.generatorConfig.getKeyword(keyword);
    }

    @Override
    public ObjectNode makeNullable(ObjectNode node) {
        return SchemaGenerationContextImpl.makeNullable(node, this.generatorConfig);
    }

    static ObjectNode makeNullable(ObjectNode node, SchemaGeneratorConfig config) {
        if (SchemaGenerationContextImpl.canExtendTypeDeclarationToIncludeNull(node, config)) {
            SchemaGenerationContextImpl.extendTypeDeclarationToIncludeNull(node, config);
        } else {
            SchemaGenerationContextImpl.addAnyOfNullSchema(node, config);
        }
        return node;
    }

    private static boolean canExtendTypeDeclarationToIncludeNull(ObjectNode node, SchemaGeneratorConfig config) {
        if (config.shouldAlwaysWrapNullSchemaInAnyOf()) {
            return false;
        }
        Stream<SchemaKeyword> requiringAnyOfWrapper = Stream.of(SchemaKeyword.TAG_REF, SchemaKeyword.TAG_ALLOF, SchemaKeyword.TAG_ANYOF, SchemaKeyword.TAG_ONEOF, SchemaKeyword.TAG_CONST, SchemaKeyword.TAG_ENUM);
        return requiringAnyOfWrapper.map(config::getKeyword).noneMatch(arg_0 -> ((ObjectNode)node).has(arg_0));
    }

    private static void extendTypeDeclarationToIncludeNull(ObjectNode node, SchemaGeneratorConfig config) {
        JsonNode fixedJsonSchemaType = node.get(config.getKeyword(SchemaKeyword.TAG_TYPE));
        String nullTypeName = config.getKeyword(SchemaKeyword.TAG_TYPE_NULL);
        if (fixedJsonSchemaType instanceof ArrayNode) {
            ArrayNode arrayOfTypes = (ArrayNode)fixedJsonSchemaType;
            for (JsonNode arrayEntry : arrayOfTypes) {
                if (!nullTypeName.equals(arrayEntry.stringValue())) continue;
                return;
            }
            node.putArray(config.getKeyword(SchemaKeyword.TAG_TYPE)).addAll(arrayOfTypes).add(nullTypeName);
        } else if (fixedJsonSchemaType instanceof StringNode && !nullTypeName.equals(fixedJsonSchemaType.stringValue())) {
            node.putArray(config.getKeyword(SchemaKeyword.TAG_TYPE)).add(fixedJsonSchemaType).add(nullTypeName);
        }
    }

    private static void addAnyOfNullSchema(ObjectNode node, SchemaGeneratorConfig config) {
        ObjectNode nullSchema = config.createObjectNode().put(config.getKeyword(SchemaKeyword.TAG_TYPE), config.getKeyword(SchemaKeyword.TAG_TYPE_NULL));
        String anyOfTagName = config.getKeyword(SchemaKeyword.TAG_ANYOF);
        JsonNode existingAnyOf = node.get(anyOfTagName);
        if (existingAnyOf instanceof ArrayNode) {
            Iterator anyOfIterator = existingAnyOf.iterator();
            while (anyOfIterator.hasNext()) {
                if (!nullSchema.equals(anyOfIterator.next())) continue;
                anyOfIterator.remove();
                break;
            }
        }
        ArrayNode newAnyOf = config.createArrayNode().add((JsonNode)nullSchema).add((JsonNode)config.createObjectNode().setAll(node));
        node.removeAll();
        node.set(anyOfTagName, (JsonNode)newAnyOf);
    }

    private static class GenericTypeDetails {
        private final TypeScope scope;
        private final boolean nullable;
        private final boolean inlineDefinition;
        private final CustomDefinitionProviderV2 ignoredDefinitionProvider;

        GenericTypeDetails(TypeScope scope, boolean nullable, boolean inlineDefinition, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
            this.scope = scope;
            this.nullable = nullable;
            this.inlineDefinition = inlineDefinition;
            this.ignoredDefinitionProvider = ignoredDefinitionProvider;
        }

        GenericTypeDetails withAlternativeReasonToInline(boolean alternativeReasonToInline) {
            return new GenericTypeDetails(this.getScope(), this.isNullable(), this.isInlineDefinition() || alternativeReasonToInline, this.getIgnoredDefinitionProvider());
        }

        public TypeScope getScope() {
            return this.scope;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isInlineDefinition() {
            return this.inlineDefinition;
        }

        public CustomDefinitionProviderV2 getIgnoredDefinitionProvider() {
            return this.ignoredDefinitionProvider;
        }
    }

    private static class MemberDetails<M extends MemberScope<?, ?>> {
        private final M scope;
        private final boolean nullable;
        private final boolean inlineDefinition;
        private final CustomPropertyDefinitionProvider<M> ignoredDefinitionProvider;

        MemberDetails(M scope, boolean nullable, boolean inlineDefinition, CustomPropertyDefinitionProvider<M> ignoredDefinitionProvider) {
            this.scope = scope;
            this.nullable = nullable;
            this.inlineDefinition = inlineDefinition;
            this.ignoredDefinitionProvider = ignoredDefinitionProvider;
        }

        GenericTypeDetails toTypeDetails() {
            return new GenericTypeDetails((TypeScope)this.getScope(), this.isNullable(), this.isInlineDefinition(), null);
        }

        public M getScope() {
            return this.scope;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isInlineDefinition() {
            return this.inlineDefinition;
        }

        public CustomPropertyDefinitionProvider<M> getIgnoredDefinitionProvider() {
            return this.ignoredDefinitionProvider;
        }
    }
}

