/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.impl.SchemaCleanUpUtils;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContextImpl;
import com.github.victools.jsonschema.generator.naming.CleanSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.DefaultSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class SchemaBuilder {
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;
    private final SchemaGenerationContextImpl generationContext;
    private final List<ObjectNode> schemaNodes;
    private final CleanSchemaDefinitionNamingStrategy definitionNamingStrategy;

    static ObjectNode createSingleTypeSchema(SchemaGeneratorConfig config, TypeContext typeContext, Type mainTargetType, Type ... typeParameters) {
        SchemaBuilder instance = new SchemaBuilder(config, typeContext);
        return instance.createSchemaForSingleType(mainTargetType, typeParameters);
    }

    static SchemaBuilder forMultipleTypes(SchemaGeneratorConfig config, TypeContext typeContext) {
        return new SchemaBuilder(config, typeContext);
    }

    SchemaBuilder(SchemaGeneratorConfig config, TypeContext typeContext) {
        this.config = config;
        this.typeContext = typeContext;
        this.generationContext = new SchemaGenerationContextImpl(this.config, this.typeContext);
        this.schemaNodes = new ArrayList<ObjectNode>();
        SchemaDefinitionNamingStrategy baseNamingStrategy = Optional.ofNullable(config.getDefinitionNamingStrategy()).orElseGet(DefaultSchemaDefinitionNamingStrategy::new);
        SchemaCleanUpUtils cleanupUtils = new SchemaCleanUpUtils(config);
        Function<String, String> definitionCleanUpTask = config.shouldUsePlainDefinitionKeys() ? cleanupUtils::ensureDefinitionKeyIsPlain : cleanupUtils::ensureDefinitionKeyIsUriCompatible;
        this.definitionNamingStrategy = new CleanSchemaDefinitionNamingStrategy(baseNamingStrategy, definitionCleanUpTask);
    }

    private ObjectNode createSchemaForSingleType(Type mainTargetType, Type ... typeParameters) {
        String definitionsTagName;
        String referenceKeyPrefix;
        ObjectNode definitionsNode;
        boolean createDefinitionForMainSchema;
        ResolvedType mainType = this.typeContext.resolve(mainTargetType, typeParameters);
        DefinitionKey mainKey = this.generationContext.parseType(mainType);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put(this.config.getKeyword(SchemaKeyword.TAG_SCHEMA), this.config.getKeyword(SchemaKeyword.TAG_SCHEMA_VALUE));
        }
        if (createDefinitionForMainSchema = this.config.shouldCreateDefinitionForMainSchema()) {
            this.generationContext.addReference(mainType, jsonSchemaResult, null, false);
        }
        if (!(definitionsNode = this.buildDefinitionsAndResolveReferences(referenceKeyPrefix = this.getReferenceKeyPrefix(definitionsTagName = this.config.getKeyword(SchemaKeyword.TAG_DEFINITIONS)), mainKey)).isEmpty()) {
            jsonSchemaResult.set(definitionsTagName, (JsonNode)definitionsNode);
        }
        if (!createDefinitionForMainSchema) {
            ObjectNode mainSchemaNode = this.generationContext.getDefinition(mainKey);
            jsonSchemaResult.setAll(mainSchemaNode);
            this.schemaNodes.add(jsonSchemaResult);
        }
        this.performCleanup(definitionsNode, referenceKeyPrefix);
        this.config.resetAfterSchemaGenerationFinished();
        return jsonSchemaResult;
    }

    public ObjectNode createSchemaReference(Type targetType, Type ... typeParameters) {
        ResolvedType resolvedTargetType = this.typeContext.resolve(targetType, typeParameters);
        ObjectNode node = this.generationContext.createDefinitionReference(resolvedTargetType);
        this.schemaNodes.add(node);
        this.config.resetAfterSchemaGenerationFinished();
        return node;
    }

    public ObjectNode collectDefinitions(String designatedDefinitionPath) {
        String referenceKeyPrefix = this.getReferenceKeyPrefix(designatedDefinitionPath);
        ObjectNode definitionsNode = this.buildDefinitionsAndResolveReferences(referenceKeyPrefix, null);
        this.performCleanup(definitionsNode, referenceKeyPrefix);
        return definitionsNode;
    }

    private String getReferenceKeyPrefix(String designatedDefinitionPath) {
        return this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN) + "/" + designatedDefinitionPath + "/";
    }

    private void performCleanup(ObjectNode definitionsNode, String referenceKeyPrefix) {
        SchemaCleanUpUtils cleanUpUtils = new SchemaCleanUpUtils(this.config);
        if (this.config.shouldCleanupUnnecessaryAllOfElements()) {
            cleanUpUtils.reduceAllOfNodes(this.schemaNodes);
        }
        cleanUpUtils.reduceAnyOfNodes(this.schemaNodes);
        if (this.config.shouldDiscardDuplicateMemberAttributes()) {
            cleanUpUtils.reduceRedundantMemberAttributes(this.schemaNodes, definitionsNode, referenceKeyPrefix);
        }
        if (this.config.shouldIncludeStrictTypeInfo()) {
            cleanUpUtils.setStrictTypeInfo(this.schemaNodes, true);
            cleanUpUtils.reduceAnyOfNodes(this.schemaNodes);
        }
    }

    private ObjectNode buildDefinitionsAndResolveReferences(String referenceKeyPrefix, DefinitionKey mainSchemaKey) {
        ObjectNode definitionsNode = this.config.createObjectNode();
        AtomicBoolean considerOnlyDirectReferences = new AtomicBoolean(false);
        Predicate<DefinitionKey> shouldProduceDefinition = this.getShouldProduceDefinitionCheck(mainSchemaKey, considerOnlyDirectReferences);
        DefinitionCollectionDetails definitionCollectionDetails = new DefinitionCollectionDetails(mainSchemaKey, referenceKeyPrefix, shouldProduceDefinition, definitionsNode);
        Map<DefinitionKey, String> baseReferenceKeys = this.getReferenceKeys(mainSchemaKey, shouldProduceDefinition);
        considerOnlyDirectReferences.set(true);
        for (Map.Entry<DefinitionKey, String> baseReferenceKey : baseReferenceKeys.entrySet()) {
            DefinitionKey definitionKey = baseReferenceKey.getKey();
            List<ObjectNode> references = this.generationContext.getReferences(definitionKey);
            List<ObjectNode> nullableReferences = this.generationContext.getNullableReferences(definitionKey);
            String referenceKey = this.updateReferences(references, definitionCollectionDetails, baseReferenceKey);
            if (nullableReferences.isEmpty()) continue;
            this.updateNullableReferences(nullableReferences, definitionCollectionDetails, referenceKey, baseReferenceKey);
        }
        definitionsNode.forEach(node -> this.schemaNodes.add((ObjectNode)node));
        return definitionsNode;
    }

    private String updateReferences(List<ObjectNode> references, DefinitionCollectionDetails definitionCollectionDetails, Map.Entry<DefinitionKey, String> baseReferenceKey) {
        if (definitionCollectionDetails.shouldProduceDefinition(baseReferenceKey.getKey())) {
            String referenceKey;
            if (definitionCollectionDetails.isMainSchemaKey(baseReferenceKey.getKey()) && !this.config.shouldCreateDefinitionForMainSchema()) {
                referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN);
            } else {
                definitionCollectionDetails.getDefinitionsNode().set(baseReferenceKey.getValue(), (JsonNode)this.generationContext.getDefinition(baseReferenceKey.getKey()));
                referenceKey = definitionCollectionDetails.getReferenceKey(baseReferenceKey.getValue());
            }
            references.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey));
            return referenceKey;
        }
        ObjectNode definition = this.generationContext.getDefinition(baseReferenceKey.getKey());
        references.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
        return null;
    }

    private void updateNullableReferences(List<ObjectNode> nullableReferences, DefinitionCollectionDetails definitionCollectionDetails, String nonNullableReferenceKey, Map.Entry<DefinitionKey, String> baseReferenceKey) {
        DefinitionKey definitionKey = baseReferenceKey.getKey();
        ObjectNode definition = nonNullableReferenceKey == null ? this.generationContext.getDefinition(definitionKey) : this.config.createObjectNode().put(this.config.getKeyword(SchemaKeyword.TAG_REF), nonNullableReferenceKey);
        this.generationContext.makeNullable(definition);
        if (this.shouldCreateNullableDefinition(this.generationContext, definitionKey, nullableReferences)) {
            String nullableDefinitionName = this.definitionNamingStrategy.adjustNullableName(definitionKey, baseReferenceKey.getValue(), this.generationContext);
            definitionCollectionDetails.getDefinitionsNode().set(nullableDefinitionName, (JsonNode)definition);
            nullableReferences.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), definitionCollectionDetails.getReferenceKey(nullableDefinitionName)));
        } else {
            nullableReferences.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
        }
    }

    private boolean shouldCreateNullableDefinition(SchemaGenerationContextImpl generationContext, DefinitionKey definitionKey, List<ObjectNode> nullableReferences) {
        if (this.config.shouldInlineNullableSchemas()) {
            return false;
        }
        if (generationContext.shouldNeverInlineDefinition(definitionKey)) {
            return true;
        }
        if (this.config.shouldInlineAllSchemas()) {
            return false;
        }
        return this.config.shouldCreateDefinitionsForAllObjects() || nullableReferences.size() > 1;
    }

    private Predicate<DefinitionKey> getShouldProduceDefinitionCheck(DefinitionKey mainSchemaKey, AtomicBoolean considerOnlyDirectReferences) {
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        boolean inlineAllSchemas = this.config.shouldInlineAllSchemas();
        return definitionKey -> {
            if (this.generationContext.shouldNeverInlineDefinition((DefinitionKey)definitionKey)) {
                return true;
            }
            if (inlineAllSchemas) {
                return false;
            }
            if (createDefinitionsForAll || definitionKey.equals(mainSchemaKey)) {
                return true;
            }
            List<ObjectNode> references = this.generationContext.getReferences((DefinitionKey)definitionKey);
            if (considerOnlyDirectReferences.get() && references.isEmpty()) {
                return false;
            }
            return references.size() > 1 || references.size() + this.generationContext.getNullableReferences((DefinitionKey)definitionKey).size() > 1;
        };
    }

    private Map<DefinitionKey, String> getReferenceKeys(DefinitionKey mainSchemaKey, Predicate<DefinitionKey> shouldProduceDefinition) {
        Function<DefinitionKey, String> definitionNameForKey = key -> this.definitionNamingStrategy.getDefinitionNameForKey((DefinitionKey)key, this.generationContext);
        Map aliases = this.generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(definitionNameForKey, TreeMap::new, Collectors.toList()));
        LinkedHashMap<DefinitionKey, String> referenceKeys = new LinkedHashMap<DefinitionKey, String>();
        for (Map.Entry<String, List<DefinitionKey>> entry2 : aliases.entrySet()) {
            this.collectReferenceKeysFromGroup(referenceKeys, entry2, mainSchemaKey, shouldProduceDefinition);
        }
        String remainingDuplicateKeys = referenceKeys.values().stream().filter(value -> !value.isEmpty()).collect(Collectors.groupingBy(key -> key, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(", "));
        if (!remainingDuplicateKeys.isEmpty()) {
            throw new IllegalStateException(SchemaDefinitionNamingStrategy.class.getSimpleName() + " of type " + this.definitionNamingStrategy.getClass().getSimpleName() + " produced duplicate keys: " + remainingDuplicateKeys);
        }
        return referenceKeys;
    }

    private void collectReferenceKeysFromGroup(Map<DefinitionKey, String> referenceKeys, Map.Entry<String, List<DefinitionKey>> group, DefinitionKey mainSchemaKey, Predicate<DefinitionKey> shouldProduceDefinition) {
        String baseDefinitionName = group.getKey();
        List<DefinitionKey> definitionKeys = group.getValue().stream().peek(key -> referenceKeys.put((DefinitionKey)key, "")).filter(shouldProduceDefinition).collect(Collectors.toList());
        if (this.areDefinitionKeysDistinct(mainSchemaKey, definitionKeys)) {
            definitionKeys.forEach(key -> referenceKeys.put((DefinitionKey)key, baseDefinitionName));
        } else {
            Map referenceKeyGroup = definitionKeys.stream().collect(Collectors.toMap(key -> key, _key -> baseDefinitionName, (val1, _val2) -> val1, LinkedHashMap::new));
            this.definitionNamingStrategy.adjustDuplicateNames(referenceKeyGroup, this.generationContext);
            if (definitionKeys.size() != referenceKeyGroup.size()) {
                throw new IllegalStateException(SchemaDefinitionNamingStrategy.class.getSimpleName() + " of type " + this.definitionNamingStrategy.getClass().getSimpleName() + " altered list of subschemas with duplicate names.");
            }
            referenceKeys.putAll(referenceKeyGroup);
        }
    }

    private boolean areDefinitionKeysDistinct(DefinitionKey mainSchemaKey, List<DefinitionKey> definitionKeys) {
        return definitionKeys.size() == 1 || definitionKeys.size() == 2 && !this.config.shouldCreateDefinitionForMainSchema() && definitionKeys.contains(mainSchemaKey);
    }

    private static class DefinitionCollectionDetails {
        private final DefinitionKey mainSchemaKey;
        private final String referenceKeyPrefix;
        private final Predicate<DefinitionKey> shouldProduceDefinition;
        private final ObjectNode definitionsNode;

        DefinitionCollectionDetails(DefinitionKey mainSchemaKey, String referenceKeyPrefix, Predicate<DefinitionKey> shouldProduceDefinition, ObjectNode definitionsNode) {
            this.mainSchemaKey = mainSchemaKey;
            this.referenceKeyPrefix = referenceKeyPrefix;
            this.shouldProduceDefinition = shouldProduceDefinition;
            this.definitionsNode = definitionsNode;
        }

        boolean isMainSchemaKey(DefinitionKey key) {
            return key.equals(this.mainSchemaKey);
        }

        String getReferenceKey(String definitionName) {
            return this.referenceKeyPrefix + definitionName;
        }

        boolean shouldProduceDefinition(DefinitionKey key) {
            return this.shouldProduceDefinition.test(key);
        }

        ObjectNode getDefinitionsNode() {
            return this.definitionsNode;
        }
    }
}

