/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedMember;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Optional;

public abstract class MemberScope<M extends ResolvedMember<T>, T extends Member>
extends TypeScope {
    private final M member;
    private final ResolvedType overriddenType;
    private final String overriddenName;
    private final ResolvedTypeWithMembers declaringTypeMembers;
    private boolean fakeContainerItemScope;
    private final TypeContext context;

    protected MemberScope(M member, ResolvedType overriddenType, String overriddenName, ResolvedTypeWithMembers declaringTypeMembers, boolean fakeContainerItemScope, TypeContext context) {
        super(Optional.ofNullable(overriddenType).orElseGet(() -> member.getType()), context);
        this.member = member;
        this.overriddenType = overriddenType;
        this.overriddenName = overriddenName;
        this.declaringTypeMembers = declaringTypeMembers;
        this.fakeContainerItemScope = fakeContainerItemScope;
        this.context = context;
    }

    protected void markAsFakeContainerItemScope() {
        this.fakeContainerItemScope = true;
    }

    public abstract MemberScope<M, T> withOverriddenType(ResolvedType var1);

    public MemberScope<M, T> asFakeContainerItemScope() {
        if (!this.isContainerType()) {
            return this.withOverriddenType(this.getOverriddenType());
        }
        MemberScope<M, T> result = this.withOverriddenType(this.getContainerItemType());
        result.markAsFakeContainerItemScope();
        return result;
    }

    public abstract MemberScope<M, T> withOverriddenName(String var1);

    public M getMember() {
        return this.member;
    }

    public ResolvedTypeWithMembers getDeclaringTypeMembers() {
        return this.declaringTypeMembers;
    }

    public ResolvedType getDeclaredType() {
        return this.member.getType();
    }

    public ResolvedType getOverriddenType() {
        return this.overriddenType;
    }

    public boolean isFakeContainerItemScope() {
        return this.fakeContainerItemScope;
    }

    public String getDeclaredName() {
        return this.member.getName();
    }

    public String getOverriddenName() {
        return this.overriddenName;
    }

    public String getName() {
        return Optional.ofNullable(this.getOverriddenName()).orElseGet(this::getDeclaredName);
    }

    public final ResolvedType getDeclaringType() {
        return this.member.getDeclaringType();
    }

    public T getRawMember() {
        return (T)this.member.getRawMember();
    }

    public boolean isStatic() {
        return this.member.isStatic();
    }

    public boolean isFinal() {
        return this.member.isFinal();
    }

    public boolean isPrivate() {
        return this.member.isPrivate();
    }

    public boolean isProtected() {
        return this.member.isProtected();
    }

    public boolean isPublic() {
        return this.member.isPublic();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)this.member.get(annotationClass);
    }

    public abstract <A extends Annotation> A getContainerItemAnnotation(Class<A> var1);

    public abstract <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> var1);

    public abstract <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> var1);

    public abstract String getSchemaPropertyName();

    @Override
    public String toString() {
        return this.getSimpleTypeDescription() + " " + this.getSchemaPropertyName();
    }
}

