/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContextImpl;
import com.github.victools.jsonschema.generator.impl.TypeContextFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SchemaGenerator {
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;

    public SchemaGenerator(SchemaGeneratorConfig config) {
        this(config, TypeContextFactory.createDefaultTypeContext());
    }

    public SchemaGenerator(SchemaGeneratorConfig config, TypeContext context) {
        this.config = config;
        this.typeContext = context;
    }

    public JsonNode generateSchema(Type mainTargetType, Type ... typeParameters) {
        ObjectNode definitionsNode;
        SchemaGenerationContextImpl generationContext = new SchemaGenerationContextImpl(this.config, this.typeContext);
        ResolvedType mainType = this.typeContext.resolve(mainTargetType, typeParameters);
        generationContext.parseType(mainType);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put(this.config.getKeyword(SchemaKeyword.TAG_SCHEMA), this.config.getKeyword(SchemaKeyword.TAG_SCHEMA_VALUE));
        }
        if ((definitionsNode = this.buildDefinitionsAndResolveReferences(mainType, generationContext)).size() > 0) {
            jsonSchemaResult.set(this.config.getKeyword(SchemaKeyword.TAG_DEFINITIONS), (JsonNode)definitionsNode);
        }
        ObjectNode mainSchemaNode = generationContext.getDefinition(mainType);
        jsonSchemaResult.setAll(mainSchemaNode);
        if (this.config.shouldCleanupUnnecessaryAllOfElements()) {
            this.discardUnnecessaryAllOfWrappers(jsonSchemaResult);
        }
        return jsonSchemaResult;
    }

    private ObjectNode buildDefinitionsAndResolveReferences(ResolvedType mainSchemaTarget, SchemaGenerationContextImpl generationContext) {
        Map aliases = generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(this.typeContext::getSchemaDefinitionName, TreeMap::new, Collectors.toList()));
        ObjectNode definitionsNode = this.config.createObjectNode();
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        for (Map.Entry aliasEntry : aliases.entrySet()) {
            String referenceKey;
            boolean referenceInline;
            List types = (List)aliasEntry.getValue();
            List<ObjectNode> referencingNodes = types.stream().flatMap(type -> generationContext.getReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            List<ObjectNode> nullableReferences = types.stream().flatMap(type -> generationContext.getNullableReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            String alias = ((String)aliasEntry.getKey()).replaceAll("[ ]+", "").replaceAll("\\[\\]", "*").replaceAll("<", "(").replaceAll(">", ")");
            boolean bl = referenceInline = !types.contains(mainSchemaTarget) && (referencingNodes.isEmpty() || !createDefinitionsForAll && referencingNodes.size() + nullableReferences.size() < 2);
            if (referenceInline) {
                referencingNodes.forEach(node -> node.setAll(generationContext.getDefinition((ResolvedType)types.get(0))));
                referenceKey = null;
            } else {
                if (types.contains(mainSchemaTarget)) {
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN);
                } else {
                    definitionsNode.set(alias, (JsonNode)generationContext.getDefinition((ResolvedType)types.get(0)));
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_PREFIX) + alias;
                }
                referencingNodes.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey));
            }
            if (nullableReferences.isEmpty()) continue;
            ObjectNode definition = referenceInline ? generationContext.getDefinition((ResolvedType)types.get(0)) : this.config.createObjectNode().put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey);
            generationContext.makeNullable(definition);
            if (createDefinitionsForAll || nullableReferences.size() > 1) {
                String nullableAlias = alias + "-nullable";
                String nullableReferenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_PREFIX) + nullableAlias;
                definitionsNode.set(nullableAlias, (JsonNode)definition);
                nullableReferences.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), nullableReferenceKey));
                continue;
            }
            nullableReferences.forEach(node -> node.setAll(definition));
        }
        return definitionsNode;
    }

    private Set<String> getTagNamesContainingSchema() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ADDITIONAL_PROPERTIES, SchemaKeyword.TAG_ITEMS).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaArray() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ALLOF, SchemaKeyword.TAG_ANYOF, SchemaKeyword.TAG_ONEOF).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaObject() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_PATTERN_PROPERTIES, SchemaKeyword.TAG_PROPERTIES).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private void discardUnnecessaryAllOfWrappers(ObjectNode schemaNode) {
        ArrayList<ObjectNode> nextNodesToCheck = new ArrayList<ObjectNode>();
        Consumer<JsonNode> addNodeToCheck = node -> {
            if (node instanceof ObjectNode) {
                nextNodesToCheck.add((ObjectNode)node);
            }
        };
        nextNodesToCheck.add(schemaNode);
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        Optional.ofNullable(schemaNode.get(SchemaKeyword.TAG_DEFINITIONS.forVersion(schemaVersion))).filter(definitions -> definitions instanceof ObjectNode).ifPresent(definitions -> ((ObjectNode)definitions).forEach(addNodeToCheck));
        String allOfTagName = SchemaKeyword.TAG_ALLOF.forVersion(schemaVersion);
        Set<String> tagsWithSchemas = this.getTagNamesContainingSchema();
        Set<String> tagsWithSchemaArrays = this.getTagNamesContainingSchemaArray();
        Set<String> tagsWithSchemaObjects = this.getTagNamesContainingSchemaObject();
        do {
            ArrayList currentNodesToCheck = new ArrayList(nextNodesToCheck);
            nextNodesToCheck.clear();
            for (ObjectNode nodeToCheck : currentNodesToCheck) {
                this.mergeAllOfPartsIfPossible((JsonNode)nodeToCheck, allOfTagName);
                tagsWithSchemas.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).forEach(addNodeToCheck);
                tagsWithSchemaArrays.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleArrayNode -> possibleArrayNode instanceof ArrayNode).forEach(arrayNode -> arrayNode.forEach(addNodeToCheck));
                tagsWithSchemaObjects.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleObjectNode -> possibleObjectNode instanceof ObjectNode).forEach(objectNode -> objectNode.forEach(addNodeToCheck));
            }
        } while (!nextNodesToCheck.isEmpty());
    }

    private void mergeAllOfPartsIfPossible(JsonNode schemaNode, String allOfTagName) {
        String refKeyword;
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode allOfTag = schemaNode.get(allOfTagName);
        if (!(allOfTag instanceof ArrayNode)) {
            return;
        }
        allOfTag.forEach(part -> this.mergeAllOfPartsIfPossible((JsonNode)part, allOfTagName));
        ArrayList allOfElements = new ArrayList();
        allOfTag.forEach(allOfElements::add);
        if (allOfElements.stream().anyMatch(part -> !(part instanceof ObjectNode) && !part.asBoolean())) {
            return;
        }
        List<ObjectNode> parts = allOfElements.stream().filter(part -> part instanceof ObjectNode).map(part -> (ObjectNode)part).collect(Collectors.toList());
        ObjectNode schemaObjectNode = (ObjectNode)schemaNode;
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        if (schemaVersion == SchemaVersion.DRAFT_7 && (schemaObjectNode.has(refKeyword = SchemaKeyword.TAG_REF.forVersion(schemaVersion)) || parts.stream().anyMatch(part -> part.has(refKeyword)))) {
            return;
        }
        Map<String, Integer> fieldCount = Stream.concat(Stream.of(schemaObjectNode), parts.stream()).flatMap(part -> StreamSupport.stream(((Iterable)() -> part.fieldNames()).spliterator(), false)).collect(Collectors.toMap(fieldName -> fieldName, _value -> 1, (currentCount, nextCount) -> currentCount + nextCount));
        if (fieldCount.values().stream().allMatch(count -> count == 1)) {
            schemaObjectNode.remove(allOfTagName);
            parts.forEach(arg_0 -> ((ObjectNode)schemaObjectNode).setAll(arg_0));
        }
    }
}

