/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;

public class SimpleTypeModule
implements Module {
    private final Map<Class<?>, String> fixedJsonSchemaTypes = new HashMap();

    public static SimpleTypeModule forPrimitiveTypes() {
        SimpleTypeModule module = new SimpleTypeModule();
        module.withEmptySchema(Object.class);
        Stream.of(String.class, Character.class, Character.TYPE, CharSequence.class).forEach(module::withStringType);
        Stream.of(Boolean.class, Boolean.TYPE).forEach(module::withBooleanType);
        Stream.of(Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE).forEach(module::withIntegerType);
        Stream.of(Double.class, Double.TYPE, Float.class, Float.TYPE).forEach(module::withNumberType);
        return module;
    }

    public static SimpleTypeModule forPrimitiveAndAdditionalTypes() {
        SimpleTypeModule module = SimpleTypeModule.forPrimitiveTypes();
        Stream.of(LocalDate.class, LocalDateTime.class, LocalTime.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class, Instant.class, ZoneId.class, Date.class, Calendar.class, UUID.class).forEach(module::withStringType);
        module.withIntegerType(BigInteger.class);
        Stream.of(BigDecimal.class, Number.class).forEach(module::withNumberType);
        return module;
    }

    private SimpleTypeModule with(Class<?> javaType, String jsonSchemaTypeValue) {
        this.fixedJsonSchemaTypes.put(javaType, jsonSchemaTypeValue);
        return this;
    }

    public final SimpleTypeModule withEmptySchema(Class<?> javaType) {
        return this.with(javaType, "");
    }

    @Deprecated
    public final SimpleTypeModule withObjectType(Class<?> javaType) {
        return this.with(javaType, "object");
    }

    public final SimpleTypeModule withStringType(Class<?> javaType) {
        return this.with(javaType, "string");
    }

    public final SimpleTypeModule withBooleanType(Class<?> javaType) {
        return this.with(javaType, "boolean");
    }

    public final SimpleTypeModule withIntegerType(Class<?> javaType) {
        return this.with(javaType, "integer");
    }

    public final SimpleTypeModule withNumberType(Class<?> javaType) {
        return this.with(javaType, "number");
    }

    private Boolean isNullableType(MemberScope<?, ?> fieldOrMethod) {
        return fieldOrMethod.getType().isPrimitive() ? Boolean.FALSE : null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withNullableCheck(this::isNullableType);
        builder.forMethods().withNullableCheck(this::isNullableType);
        builder.forTypesInGeneral().withAdditionalPropertiesResolver(this::resolveAdditionalProperties).withPatternPropertiesResolver(this::resolvePatternProperties);
        builder.with(new SimpleTypeDefinitionProvider(builder.getObjectMapper()));
    }

    private Type resolveAdditionalProperties(TypeScope scope) {
        if (scope.getType().getTypeParameters().isEmpty() && "".equals(this.fixedJsonSchemaTypes.get(scope.getType().getErasedType()))) {
            return Object.class;
        }
        return null;
    }

    private Map<String, Type> resolvePatternProperties(TypeScope scope) {
        if (scope.getType().getTypeParameters().isEmpty() && "".equals(this.fixedJsonSchemaTypes.get(scope.getType().getErasedType()))) {
            return Collections.emptyMap();
        }
        return null;
    }

    private class SimpleTypeDefinitionProvider
    implements CustomDefinitionProviderV2 {
        private final ObjectMapper objectMapper;

        SimpleTypeDefinitionProvider(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
            if (!javaType.getTypeParameters().isEmpty()) {
                return null;
            }
            String jsonSchemaTypeValue = (String)SimpleTypeModule.this.fixedJsonSchemaTypes.get(javaType.getErasedType());
            if (jsonSchemaTypeValue == null) {
                return null;
            }
            ObjectNode customSchema = this.objectMapper.createObjectNode();
            if (!jsonSchemaTypeValue.isEmpty()) {
                customSchema.put("type", jsonSchemaTypeValue);
            }
            return new CustomDefinition(customSchema, true);
        }
    }
}

