/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SchemaCleanUpUtils {
    private final SchemaGeneratorConfig config;

    public SchemaCleanUpUtils(SchemaGeneratorConfig config) {
        this.config = config;
    }

    public void reduceAllOfNodes(List<ObjectNode> jsonSchemas) {
        String allOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ALLOF);
        Map<String, SchemaKeyword> reverseKeywordMap = SchemaKeyword.getTagStream().collect(Collectors.toMap(this.config::getKeyword, keyword -> keyword));
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.mergeAllOfPartsIfPossible((JsonNode)nodeToCheck, allOfTagName, reverseKeywordMap));
    }

    public void reduceAnyOfNodes(List<ObjectNode> jsonSchemas) {
        String anyOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ANYOF);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.reduceAnyOfWrappersIfPossible((JsonNode)nodeToCheck, anyOfTagName));
    }

    private Set<String> getTagNamesContainingSchema() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ADDITIONAL_PROPERTIES, SchemaKeyword.TAG_ITEMS).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaArray() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ALLOF, SchemaKeyword.TAG_ANYOF, SchemaKeyword.TAG_ONEOF).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaObject() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_PATTERN_PROPERTIES, SchemaKeyword.TAG_PROPERTIES).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private void finaliseSchemaParts(List<ObjectNode> schemaNodes, Consumer<ObjectNode> performCleanUpOnSingleSchemaNode) {
        ArrayList<ObjectNode> nextNodesToCheck = new ArrayList<ObjectNode>(schemaNodes);
        Consumer<JsonNode> addNodeToCheck = node -> {
            if (node instanceof ObjectNode) {
                nextNodesToCheck.add((ObjectNode)node);
            }
        };
        Set<String> tagsWithSchemas = this.getTagNamesContainingSchema();
        Set<String> tagsWithSchemaArrays = this.getTagNamesContainingSchemaArray();
        Set<String> tagsWithSchemaObjects = this.getTagNamesContainingSchemaObject();
        do {
            ArrayList<ObjectNode> currentNodesToCheck = new ArrayList<ObjectNode>(nextNodesToCheck);
            nextNodesToCheck.clear();
            for (ObjectNode nodeToCheck : currentNodesToCheck) {
                performCleanUpOnSingleSchemaNode.accept(nodeToCheck);
                tagsWithSchemas.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).forEach(addNodeToCheck);
                tagsWithSchemaArrays.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleArrayNode -> possibleArrayNode instanceof ArrayNode).forEach(arrayNode -> arrayNode.forEach(addNodeToCheck));
                tagsWithSchemaObjects.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleObjectNode -> possibleObjectNode instanceof ObjectNode).forEach(objectNode -> objectNode.forEach(addNodeToCheck));
            }
        } while (!nextNodesToCheck.isEmpty());
    }

    private void mergeAllOfPartsIfPossible(JsonNode schemaNode, String allOfTagName, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        ObjectNode schemaObjectNode = (ObjectNode)schemaNode;
        JsonNode allOfTag = schemaObjectNode.get(allOfTagName);
        if (!(allOfTag instanceof ArrayNode)) {
            return;
        }
        allOfTag.forEach(part -> this.mergeAllOfPartsIfPossible((JsonNode)part, allOfTagName, reverseKeywordMap));
        ArrayList<JsonNode> allParts = new ArrayList<JsonNode>(1 + allOfTag.size());
        allParts.add((JsonNode)schemaObjectNode);
        allOfTag.forEach(allParts::add);
        Supplier<ObjectNode> successfulMergeResultSupplier = this.mergeSchemas(schemaObjectNode, allParts, reverseKeywordMap);
        if (successfulMergeResultSupplier == null) {
            return;
        }
        schemaObjectNode.remove(allOfTagName);
        schemaObjectNode.setAll(successfulMergeResultSupplier.get());
    }

    private Supplier<? extends JsonNode> getAllOfMergeFunctionFor(SchemaKeyword keyword, List<JsonNode> valuesToMerge, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (valuesToMerge.size() == 1) {
            return () -> (JsonNode)valuesToMerge.get(0);
        }
        switch (keyword) {
            case TAG_ALLOF: 
            case TAG_REQUIRED: {
                return this.mergeArrays(valuesToMerge);
            }
            case TAG_PROPERTIES: {
                return this.mergeObjectProperties(valuesToMerge);
            }
            case TAG_ITEMS: 
            case TAG_ADDITIONAL_PROPERTIES: {
                return this.mergeSchemas(null, valuesToMerge, reverseKeywordMap);
            }
            case TAG_TYPE: {
                return this.returnOverlapOfStringsOrStringArrays(valuesToMerge);
            }
            case TAG_ITEMS_MAX: 
            case TAG_PROPERTIES_MAX: 
            case TAG_MAXIMUM: 
            case TAG_MAXIMUM_EXCLUSIVE: 
            case TAG_LENGTH_MAX: {
                return this.returnMinimumNumericValue(valuesToMerge);
            }
            case TAG_ITEMS_MIN: 
            case TAG_PROPERTIES_MIN: 
            case TAG_MINIMUM: 
            case TAG_MINIMUM_EXCLUSIVE: 
            case TAG_LENGTH_MIN: {
                return this.returnMaximumNumericValue(valuesToMerge);
            }
        }
        return this.returnOneIfAllEqual(valuesToMerge);
    }

    private Supplier<JsonNode> mergeArrays(List<JsonNode> arrayNodesToMerge) {
        if (!arrayNodesToMerge.stream().allMatch(JsonNode::isArray)) {
            return null;
        }
        return () -> {
            ArrayNode mergedArrayNode = this.config.createArrayNode();
            arrayNodesToMerge.forEach(node -> node.forEach(arg_0 -> ((ArrayNode)mergedArrayNode).add(arg_0)));
            return mergedArrayNode;
        };
    }

    private Supplier<JsonNode> mergeObjectProperties(List<JsonNode> objectNodesToMerge) {
        if (!objectNodesToMerge.stream().allMatch(JsonNode::isObject)) {
            return null;
        }
        ObjectNode mergedObjectNode = this.config.createObjectNode();
        for (JsonNode singleObjectNode : objectNodesToMerge) {
            Iterator it = singleObjectNode.fields();
            while (it.hasNext()) {
                Map.Entry singleField = (Map.Entry)it.next();
                if (!mergedObjectNode.has((String)singleField.getKey())) {
                    mergedObjectNode.set((String)singleField.getKey(), (JsonNode)singleField.getValue());
                    continue;
                }
                if (mergedObjectNode.get((String)singleField.getKey()).equals(singleField.getValue())) continue;
                return null;
            }
        }
        return () -> mergedObjectNode;
    }

    private Supplier<ObjectNode> mergeSchemas(ObjectNode mainNodeIncludingAllOf, List<JsonNode> nodes, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (nodes.stream().anyMatch(part -> !(part instanceof ObjectNode) && (!part.isBoolean() || !part.asBoolean()))) {
            return null;
        }
        List parts = nodes.stream().filter(part -> part instanceof ObjectNode).map(part -> (ObjectNode)part).collect(Collectors.toList());
        Map fieldsFromAllParts = parts.stream().flatMap(part -> StreamSupport.stream(((Iterable)() -> part.fields()).spliterator(), false)).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        if ((this.config.getSchemaVersion() == SchemaVersion.DRAFT_6 || this.config.getSchemaVersion() == SchemaVersion.DRAFT_7) && fieldsFromAllParts.containsKey(this.config.getKeyword(SchemaKeyword.TAG_REF)) && (mainNodeIncludingAllOf == null ? parts.size() > 1 : mainNodeIncludingAllOf.size() > 1 || parts.size() > 2)) {
            return null;
        }
        Map unsupportedTagValues = fieldsFromAllParts.entrySet().stream().filter(entry -> !reverseKeywordMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, SchemaCleanUpUtils::throwingMerger, LinkedHashMap::new));
        if (unsupportedTagValues.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).size() > 1)) {
            return null;
        }
        Map<SchemaKeyword, Supplier<? extends JsonNode>> supportedTagValueSuppliers = this.collectSupportedTagValueSuppliers(fieldsFromAllParts, reverseKeywordMap, mainNodeIncludingAllOf);
        if (supportedTagValueSuppliers == null) {
            return null;
        }
        return () -> {
            ObjectNode mergedNode = this.config.createObjectNode();
            supportedTagValueSuppliers.forEach((keyword, valueSupplier) -> mergedNode.set(this.config.getKeyword((SchemaKeyword)((Object)((Object)keyword))), (JsonNode)valueSupplier.get()));
            unsupportedTagValues.forEach((tagName, valueList) -> mergedNode.set(tagName, (JsonNode)valueList.get(0)));
            return mergedNode;
        };
    }

    private Map<SchemaKeyword, Supplier<? extends JsonNode>> collectSupportedTagValueSuppliers(Map<String, List<JsonNode>> fieldsFromAllParts, Map<String, SchemaKeyword> reverseKeywordMap, ObjectNode mainNodeIncludingAllOf) {
        Map supportedTagValues = fieldsFromAllParts.entrySet().stream().filter(entry -> reverseKeywordMap.containsKey(entry.getKey())).collect(Collectors.toMap(entry -> (SchemaKeyword)((Object)((Object)reverseKeywordMap.get(entry.getKey()))), Map.Entry::getValue, SchemaCleanUpUtils::throwingMerger, LinkedHashMap::new));
        if (supportedTagValues.containsKey((Object)SchemaKeyword.TAG_IF)) {
            return null;
        }
        LinkedHashMap<SchemaKeyword, Supplier<? extends JsonNode>> supportedTagValueSuppliers = new LinkedHashMap<SchemaKeyword, Supplier<? extends JsonNode>>();
        for (Map.Entry fieldEntries : supportedTagValues.entrySet()) {
            SchemaKeyword keyword = (SchemaKeyword)((Object)fieldEntries.getKey());
            List valuesToMerge = (List)fieldEntries.getValue();
            if (keyword == SchemaKeyword.TAG_ALLOF && mainNodeIncludingAllOf != null && (valuesToMerge = valuesToMerge.subList(1, valuesToMerge.size())).isEmpty()) continue;
            Supplier<? extends JsonNode> mergeResultSupplier = this.getAllOfMergeFunctionFor(keyword, valuesToMerge, reverseKeywordMap);
            if (mergeResultSupplier == null) {
                return null;
            }
            supportedTagValueSuppliers.put(keyword, mergeResultSupplier);
        }
        return supportedTagValueSuppliers;
    }

    private Supplier<JsonNode> returnOverlapOfStringsOrStringArrays(List<JsonNode> nodes) {
        List<String> encounteredValues = this.getStringValuesFromStringOrStringArray(nodes.get(0));
        if (encounteredValues == null) {
            return null;
        }
        for (JsonNode nextNode : nodes.subList(1, nodes.size())) {
            List<String> nextValues = this.getStringValuesFromStringOrStringArray(nextNode);
            if (nextValues == null) {
                return null;
            }
            encounteredValues.retainAll(nextValues);
            if (!encounteredValues.isEmpty()) continue;
            return null;
        }
        if (encounteredValues.size() == 1) {
            return () -> new TextNode((String)encounteredValues.get(0));
        }
        return () -> this.config.createArrayNode().addAll((Collection)encounteredValues.stream().map(TextNode::new).collect(Collectors.toList()));
    }

    private List<String> getStringValuesFromStringOrStringArray(JsonNode node) {
        if (node.isArray()) {
            ArrayList<String> result = new ArrayList<String>();
            node.forEach(arrayItem -> result.add(arrayItem.asText(null)));
            if (result.contains(null)) {
                return null;
            }
            return result;
        }
        if (node.isTextual()) {
            return Collections.singletonList(node.asText());
        }
        return null;
    }

    private Supplier<JsonNode> returnMinimumNumericValue(List<JsonNode> nodes) {
        if (nodes.stream().allMatch(node -> node.isNumber())) {
            return () -> (JsonNode)nodes.stream().reduce((a, b) -> a.asDouble() < b.asDouble() ? a : b).get();
        }
        return null;
    }

    private Supplier<JsonNode> returnMaximumNumericValue(List<JsonNode> nodes) {
        if (nodes.stream().allMatch(node -> node.isNumber())) {
            return () -> (JsonNode)nodes.stream().reduce((a, b) -> a.asDouble() < b.asDouble() ? b : a).get();
        }
        return null;
    }

    private Supplier<JsonNode> returnOneIfAllEqual(List<JsonNode> nodes) {
        JsonNode firstNode = nodes.get(0);
        if (nodes.subList(1, nodes.size()).stream().allMatch(arg_0 -> ((JsonNode)firstNode).equals(arg_0))) {
            return () -> firstNode;
        }
        return null;
    }

    private void reduceAnyOfWrappersIfPossible(JsonNode schemaNode, String anyOfTagName) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode anyOfTag = schemaNode.get(anyOfTagName);
        if (!(anyOfTag instanceof ArrayNode)) {
            return;
        }
        anyOfTag.forEach(part -> this.reduceAnyOfWrappersIfPossible((JsonNode)part, anyOfTagName));
        for (int index = anyOfTag.size() - 1; index > -1; --index) {
            JsonNode nestedAnyOf;
            JsonNode arrayEntry = anyOfTag.get(index);
            if (!(arrayEntry instanceof ObjectNode) || arrayEntry.size() != 1 || !((nestedAnyOf = arrayEntry.get(anyOfTagName)) instanceof ArrayNode)) continue;
            ((ArrayNode)anyOfTag).remove(index);
            for (int nestedEntryIndex = nestedAnyOf.size() - 1; nestedEntryIndex > -1; --nestedEntryIndex) {
                ((ArrayNode)anyOfTag).insert(index, nestedAnyOf.get(nestedEntryIndex));
            }
        }
    }

    public String ensureDefinitionKeyIsUriCompatible(String definitionKey) {
        return definitionKey.replaceAll("\\[\\]", "*").replaceAll("<", "(").replaceAll(">", ")").replaceAll("[^a-zA-Z0-9\\.\\-_\\$\\*\\(\\),]+", "");
    }

    public String ensureDefinitionKeyIsPlain(String definitionKey) {
        return definitionKey.replaceAll("\\$", "-").replaceAll("\\[\\]", "...").replaceAll("[<>]", "_").replaceAll(",", ".").replaceAll("[^a-zA-Z0-9\\.\\-_]+", "");
    }

    private static <T> T throwingMerger(T one, T two) {
        throw new IllegalStateException("Duplicate key " + one);
    }
}

