/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SchemaCleanUpUtils {
    private final SchemaGeneratorConfig config;

    public SchemaCleanUpUtils(SchemaGeneratorConfig config) {
        this.config = config;
    }

    public void reduceAllOfNodes(List<ObjectNode> jsonSchemas) {
        String allOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ALLOF);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.mergeAllOfPartsIfPossible((JsonNode)nodeToCheck, allOfTagName));
    }

    public void reduceAnyOfNodes(List<ObjectNode> jsonSchemas) {
        String anyOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ANYOF);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.reduceAnyOfWrappersIfPossible((JsonNode)nodeToCheck, anyOfTagName));
    }

    private Set<String> getTagNamesContainingSchema() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ADDITIONAL_PROPERTIES, SchemaKeyword.TAG_ITEMS).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaArray() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ALLOF, SchemaKeyword.TAG_ANYOF, SchemaKeyword.TAG_ONEOF).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaObject() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_PATTERN_PROPERTIES, SchemaKeyword.TAG_PROPERTIES).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private void finaliseSchemaParts(List<ObjectNode> schemaNodes, Consumer<ObjectNode> performCleanUpOnSingleSchemaNode) {
        ArrayList<ObjectNode> nextNodesToCheck = new ArrayList<ObjectNode>(schemaNodes);
        Consumer<JsonNode> addNodeToCheck = node -> {
            if (node instanceof ObjectNode) {
                nextNodesToCheck.add((ObjectNode)node);
            }
        };
        Set<String> tagsWithSchemas = this.getTagNamesContainingSchema();
        Set<String> tagsWithSchemaArrays = this.getTagNamesContainingSchemaArray();
        Set<String> tagsWithSchemaObjects = this.getTagNamesContainingSchemaObject();
        do {
            ArrayList<ObjectNode> currentNodesToCheck = new ArrayList<ObjectNode>(nextNodesToCheck);
            nextNodesToCheck.clear();
            for (ObjectNode nodeToCheck : currentNodesToCheck) {
                performCleanUpOnSingleSchemaNode.accept(nodeToCheck);
                tagsWithSchemas.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).forEach(addNodeToCheck);
                tagsWithSchemaArrays.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleArrayNode -> possibleArrayNode instanceof ArrayNode).forEach(arrayNode -> arrayNode.forEach(addNodeToCheck));
                tagsWithSchemaObjects.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleObjectNode -> possibleObjectNode instanceof ObjectNode).forEach(objectNode -> objectNode.forEach(addNodeToCheck));
            }
        } while (!nextNodesToCheck.isEmpty());
    }

    private void mergeAllOfPartsIfPossible(JsonNode schemaNode, String allOfTagName) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode allOfTag = schemaNode.get(allOfTagName);
        if (!(allOfTag instanceof ArrayNode)) {
            return;
        }
        allOfTag.forEach(part -> this.mergeAllOfPartsIfPossible((JsonNode)part, allOfTagName));
        ArrayList allOfElements = new ArrayList();
        allOfTag.forEach(allOfElements::add);
        if (allOfElements.stream().anyMatch(part -> !(part instanceof ObjectNode) && !part.asBoolean())) {
            return;
        }
        List<ObjectNode> parts = allOfElements.stream().filter(part -> part instanceof ObjectNode).map(part -> (ObjectNode)part).collect(Collectors.toList());
        Map fieldsFromAllParts = Stream.concat(Stream.of(schemaNode), parts.stream()).flatMap(part -> StreamSupport.stream(((Iterable)() -> part.fields()).spliterator(), false)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        if (!(this.config.getSchemaVersion() != SchemaVersion.DRAFT_6 && this.config.getSchemaVersion() != SchemaVersion.DRAFT_7 || !fieldsFromAllParts.containsKey(this.config.getKeyword(SchemaKeyword.TAG_REF)) || schemaNode.size() <= 1 && parts.size() <= 1)) {
            return;
        }
        String ifTagName = this.config.getKeyword(SchemaKeyword.TAG_IF);
        for (Map.Entry fieldEntries : fieldsFromAllParts.entrySet()) {
            int offset;
            if (ifTagName.equals(fieldEntries.getKey())) {
                return;
            }
            if (fieldEntries.getValue().size() == 1) continue;
            if (!allOfTagName.equals(fieldEntries.getKey())) {
                offset = 0;
            } else {
                if (fieldEntries.getValue().size() == 2) continue;
                offset = 1;
            }
            if (fieldEntries.getValue().stream().skip(offset + 1).allMatch(arg_0 -> ((JsonNode)((JsonNode)fieldEntries.getValue().get(offset))).equals(arg_0))) continue;
            return;
        }
        ObjectNode schemaObjectNode = (ObjectNode)schemaNode;
        schemaObjectNode.remove(allOfTagName);
        parts.forEach(arg_0 -> ((ObjectNode)schemaObjectNode).setAll(arg_0));
    }

    private void reduceAnyOfWrappersIfPossible(JsonNode schemaNode, String anyOfTagName) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode anyOfTag = schemaNode.get(anyOfTagName);
        if (!(anyOfTag instanceof ArrayNode)) {
            return;
        }
        anyOfTag.forEach(part -> this.reduceAnyOfWrappersIfPossible((JsonNode)part, anyOfTagName));
        for (int index = anyOfTag.size() - 1; index > -1; --index) {
            JsonNode nestedAnyOf;
            JsonNode arrayEntry = anyOfTag.get(index);
            if (!(arrayEntry instanceof ObjectNode) || arrayEntry.size() != 1 || !((nestedAnyOf = arrayEntry.get(anyOfTagName)) instanceof ArrayNode)) continue;
            ((ArrayNode)anyOfTag).remove(index);
            for (int nestedEntryIndex = nestedAnyOf.size() - 1; nestedEntryIndex > -1; --nestedEntryIndex) {
                ((ArrayNode)anyOfTag).insert(index, nestedAnyOf.get(nestedEntryIndex));
            }
        }
    }

    public String ensureDefinitionKeyIsUriCompatible(String definitionKey) {
        return definitionKey.replaceAll("\\[\\]", "*").replaceAll("<", "(").replaceAll(">", ")").replaceAll("[^a-zA-Z0-9\\.\\-_\\$\\*\\(\\),]+", "");
    }

    public String ensureDefinitionKeyIsPlain(String definitionKey) {
        return definitionKey.replaceAll("\\$", "-").replaceAll("\\[\\]", "...").replaceAll("[<>]", "_").replaceAll(",", ".").replaceAll("[^a-zA-Z0-9\\.\\-_]+", "");
    }
}

