/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.RawMember;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProvider;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;

public class EnumModule
implements Module {
    private final boolean treatAsString;

    public static EnumModule asStrings() {
        return new EnumModule(true);
    }

    public static EnumModule asObjects() {
        return new EnumModule(false);
    }

    public EnumModule(boolean treatAsString) {
        this.treatAsString = treatAsString;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        if (this.treatAsString) {
            builder.with(new EnumAsStringDefinitionProvider(builder.getObjectMapper()));
        } else {
            builder.forMethods().withIgnoreCheck(method -> EnumModule.isEnum(method.getDeclaringType()) && !"name".equals(method.getName())).withNullableCheck(method -> EnumModule.isEnum(method.getDeclaringType()) ? Boolean.FALSE : null).withEnumResolver(EnumModule::extractEnumValues);
            builder.forFields().withIgnoreCheck(field -> ((Field)field.getRawMember()).isEnumConstant());
        }
    }

    private static boolean isEnum(ResolvedType type) {
        return type.getErasedType() == Enum.class;
    }

    private static List<String> extractEnumValues(MethodScope method) {
        ResolvedType declaringType = method.getDeclaringType();
        if (EnumModule.isEnum(declaringType)) {
            return EnumModule.extractEnumValues((ResolvedType)declaringType.getTypeParameters().get(0));
        }
        return null;
    }

    private static <E extends Enum<E>> List<String> extractEnumValues(ResolvedType enumType) {
        return enumType.getStaticFields().stream().filter(field -> field.getRawMember().isEnumConstant()).map(RawMember::getName).collect(Collectors.toList());
    }

    private static class EnumAsStringDefinitionProvider
    implements CustomDefinitionProvider {
        private final ObjectMapper objectMapper;

        EnumAsStringDefinitionProvider(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, TypeContext context) {
            if (javaType.isInstanceOf(Enum.class)) {
                ObjectNode customNode = this.objectMapper.createObjectNode().put("type", "string");
                new AttributeCollector(this.objectMapper).setEnum(customNode, EnumModule.extractEnumValues(javaType));
                return new CustomDefinition(customNode);
            }
            return null;
        }
    }
}

