/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class SimplifiedOptionalModule
implements Module {
    public static final String[] DEFAULT_INCLUDED_METHOD_NAMES = new String[]{"get", "orElse", "isPresent"};
    private final List<String> includedMethodNames;

    public SimplifiedOptionalModule(String ... includedMethodNames) {
        this.includedMethodNames = includedMethodNames == null || includedMethodNames.length == 0 ? Arrays.asList(DEFAULT_INCLUDED_METHOD_NAMES) : Arrays.asList(includedMethodNames);
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withIgnoreCheck(field -> field.getDeclaringClass() == Optional.class);
        builder.forMethods().withIgnoreCheck(method -> method.getDeclaringClass() == Optional.class && !this.includedMethodNames.contains(method.getName()));
    }
}

