/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.github.victools.jsonschema.generator.JavaType;
import com.github.victools.jsonschema.generator.TypeVariableContext;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public final class ReflectionTypeUtils {
    private ReflectionTypeUtils() {
    }

    public static Class<?> getRawType(Type javaType) {
        Class rawType;
        if (javaType instanceof Class) {
            rawType = (Class)javaType;
        } else if (javaType instanceof ParameterizedType) {
            rawType = (Class)((ParameterizedType)javaType).getRawType();
        } else if (javaType instanceof GenericArrayType) {
            rawType = null;
        } else {
            throw new UnsupportedOperationException("Unsupported type: " + javaType);
        }
        return rawType;
    }

    public static boolean isArrayType(JavaType javaType) {
        Type genericType = javaType.getResolvedType();
        if (genericType instanceof GenericArrayType) {
            return true;
        }
        Class<?> rawType = ReflectionTypeUtils.getRawType(genericType);
        return rawType.isArray() || Collection.class.isAssignableFrom(rawType);
    }

    public static JavaType getArrayComponentType(JavaType arrayType) {
        TypeVariableContext componentTypeVariables = TypeVariableContext.forType(arrayType);
        Type componentType = null;
        if (ReflectionTypeUtils.isArrayType(arrayType)) {
            Type genericType = arrayType.getResolvedType();
            if (genericType instanceof GenericArrayType) {
                componentType = ((GenericArrayType)genericType).getGenericComponentType();
            } else if (genericType instanceof Class) {
                componentType = ((Class)genericType).getComponentType();
            } else if (genericType instanceof ParameterizedType) {
                JavaType collectionType = ReflectionTypeUtils.getParameterizedBaseType(arrayType, Collection.class);
                componentType = ((ParameterizedType)collectionType.getResolvedType()).getActualTypeArguments()[0];
                componentTypeVariables = collectionType.getParentTypeVariables();
            }
        }
        if (componentType == null) {
            throw new UnsupportedOperationException("Cannot determine array component type for target: " + arrayType);
        }
        return componentTypeVariables.resolveGenericTypePlaceholder(componentType);
    }

    public static boolean isOptionalType(JavaType javaType) {
        Type resolvedType = javaType.getResolvedType();
        Class<?> rawTargetClass = ReflectionTypeUtils.getRawType(resolvedType);
        return rawTargetClass != null && Optional.class.isAssignableFrom(rawTargetClass);
    }

    public static JavaType getOptionalComponentType(JavaType optionalType) {
        if (ReflectionTypeUtils.isOptionalType(optionalType)) {
            JavaType optionalBaseType = ReflectionTypeUtils.getParameterizedBaseType(optionalType, Optional.class);
            Type componentType = ((ParameterizedType)optionalBaseType.getResolvedType()).getActualTypeArguments()[0];
            return optionalBaseType.getParentTypeVariables().resolveGenericTypePlaceholder(componentType);
        }
        throw new UnsupportedOperationException("Cannot determine optional component type for target: " + optionalType);
    }

    public static JavaType getParameterizedBaseType(JavaType type, Class<?> baseClass) {
        Type genericType = type.getResolvedType();
        Class rawTargetType = ReflectionTypeUtils.getRawType(genericType);
        if (!baseClass.isAssignableFrom(rawTargetType) || !(genericType instanceof ParameterizedType)) {
            throw new UnsupportedOperationException("Cannot resolve " + genericType + " to the base class: " + baseClass);
        }
        ParameterizedType parameterizedTargetType = (ParameterizedType)genericType;
        TypeVariableContext componentTypeVariables = TypeVariableContext.forType(type);
        while (rawTargetType != baseClass) {
            componentTypeVariables = TypeVariableContext.forType(parameterizedTargetType, componentTypeVariables);
            Type collectionSuperType = Stream.of(rawTargetType.getGenericInterfaces()).filter(interfaceType -> baseClass.isAssignableFrom(ReflectionTypeUtils.getRawType(interfaceType))).findFirst().orElse(rawTargetType.getGenericSuperclass());
            parameterizedTargetType = (ParameterizedType)collectionSuperType;
            rawTargetType = (Class)parameterizedTargetType.getRawType();
        }
        return new JavaType(parameterizedTargetType, componentTypeVariables);
    }
}

