/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ops;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Base64;
import com.vhall.document.DocumentView;
import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.framework.utils.FileUtil;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;
import com.vhall.ops.VHOPSApi;
import com.vhall.ops.WatermarkOption;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHOPS
implements IVHService {
    private static final String TAG = "VHDocument";
    private static final int MODE_STREAM = 1;
    private static final int MODE_RECORD = 2;
    private String mChannelId = "";
    private String mRoomId = "";
    private String mRecordId = "";
    private String mAccessToken = "";
    private String mDocId = "";
    private static final int ERROR_TYPE = 590000;
    private static final int ERROR_OUT_LIMIT = 590001;
    private int mMode = -1;
    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;
    private boolean isLoadLastDoc = true;
    private Context context;
    private HashMap<String, DocumentView> viewMap = new HashMap();
    private int switchStatus = 1;
    private Handler handler = new Handler(Looper.getMainLooper());
    private String activeCid = "";
    private EventListener listener;
    private boolean editAble = false;
    private LinkedHashMap<String, List<DocInfo>> dataMap = new LinkedHashMap();
    private String dataStr = "";
    public static String TYPE_VODDocInited = "VodDocInited";
    public static String TYPE_CREATE = "create";
    public static String TYPE_DESTROY = "destroy";
    public static String TYPE_ACTIVE = "active";
    public static String TYPE_SWITCHOFF = "switchoff";
    public static String TYPE_SWITCHON = "switchon";
    private static String TYPE_SWITCH = "switch";
    public static String TYPE_RESET = "reset";
    public static String KEY_OPERATE = "operate";
    public static String KEY_READY = "ready";
    public static final int ERROR_CONNECT = -1;
    public static final int ERROR_DOC_INFO = 101;
    public static final int ERROR_SEND = 201;
    public static final int ERROR_DOC_EXCEPTION = 301;
    private long curPosition = 0L;
    private String switchType = TYPE_SWITCHOFF;
    private int dealTime = 0;
    private double createWith = 800.0;
    private double createHeight = 600.0;
    private String createColor = "#ffffff";
    private String docId = "";
    private WatermarkOption mWatermarkOption = null;
    public boolean isVodDocInited = false;
    public static final String DOC_K = "262001";
    private boolean isVod = false;

    public void setListener(EventListener listener) {
        this.listener = listener;
    }

    public VHOPS(Context context, String channelId, String roomid, String accessToken) {
        this(context, channelId, roomid, accessToken, true);
    }

    public VHOPS(Context context, String channelId, String roomid, String accessToken, boolean loadLastDoc) {
        this.context = context;
        this.mChannelId = channelId;
        this.mRoomId = roomid;
        this.mAccessToken = accessToken;
        this.isLoadLastDoc = loadLastDoc;
        this.mMode = 1;
        LogInfo.getInstance().vtype = 1;
        this.trackInitEvent();
        if (this.isLoadLastDoc) {
            VHOPSApi.getWatchDoc(channelId, accessToken, new MyWatchInfoCallback());
        }
    }

    public void resetWatchInfo() {
        if (this.editAble && this.mMode == 1) {
            VHOPSApi.resetWatchInfo(this.mChannelId, this.mAccessToken, null);
        }
    }

    public VHOPS(String accessToken, Context context, String recordId, String channelid) {
        this.context = context;
        this.mRecordId = recordId;
        this.mMode = 2;
        this.mAccessToken = accessToken;
        this.mChannelId = TextUtils.isEmpty((CharSequence)channelid) ? recordId : channelid;
        LogInfo.getInstance().vtype = 2;
        this.trackInitEvent();
    }

    public void setDealTime(int dealTime) {
        this.dealTime = dealTime;
    }

    private void createBoard(final String id, final JSONObject data) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                final DocumentView board = new DocumentView(VHOPS.this.context);
                if (null != VHOPS.this.mWatermarkOption) {
                    board.setWatermark(VHOPS.this.mWatermarkOption.toJson());
                }
                board.init(id, VHOPS.this.getInitOpts(data));
                VHOPS.this.viewMap.put(id, board);
                if (VHOPS.this.listener != null) {
                    VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_CREATE, id);
                }
                board.addListener(new DocumentView.EventListener(){

                    public void onEvent(int eventCode, String eventMsg) {
                        switch (eventCode) {
                            case 1: {
                                board.createBoard(VhallSDK.getInstance().getmUserId());
                                if (VHOPS.this.listener != null && VHOPS.this.activeCid == id && VHOPS.this.listener != null) {
                                    VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, id);
                                }
                                if (VHOPS.this.mMode == 1) {
                                    JSONArray pageData = data.optJSONArray("pageData");
                                    for (int i = 0; i < pageData.length(); ++i) {
                                        board.doodle(pageData.optJSONObject(i).toString());
                                    }
                                }
                                board.setEditable(VHOPS.this.editAble);
                                break;
                            }
                            case 6: {
                                if (!board.isEditable()) {
                                    return;
                                }
                                try {
                                    JSONObject object = new JSONObject(eventMsg);
                                    object.put("docId", (Object)"");
                                    object.put("pf", (Object)"android");
                                    object.put("switch", VHOPS.this.switchStatus == 1);
                                    String dataStr = object.toString();
                                    VLog.d((String)VHOPS.TAG, (String)("\u64cd\u4f5c\u6570\u636e\u56de\u8c03\uff1a" + dataStr));
                                    VHOPSApi.sendDocumentMsg(object.toString(), VHOPS.this.mAccessToken, VHOPS.this.mChannelId, VHOPS.this.mRoomId, new SendMsgCallback());
                                    break;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private void createDocument(final String cid, final JSONObject data) {
        final String docId = data.optString("docId");
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                final DocumentView ppt = new DocumentView(VHOPS.this.context);
                if (null != VHOPS.this.mWatermarkOption) {
                    ppt.setWatermark(VHOPS.this.mWatermarkOption.toJson());
                }
                ppt.init(cid, VHOPS.this.getInitOpts(data));
                VHOPS.this.viewMap.put(cid, ppt);
                VHOPS.this.trackCreateEvent(docId);
                if (VHOPS.this.listener != null) {
                    VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_CREATE, cid);
                }
                ppt.addListener(new DocumentView.EventListener(){

                    public void onEvent(int eventCode, String eventMsg) {
                        switch (eventCode) {
                            case 1: {
                                ppt.createDocument(VhallSDK.getInstance().getmUserId(), docId);
                                if (VHOPS.this.listener != null && VHOPS.this.activeCid == cid) {
                                    VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
                                }
                                if (VHOPS.this.mMode == 1) {
                                    String docErrStr = "";
                                    int doc_type = data.optInt("doc_type");
                                    if (doc_type == 0) {
                                        int status = data.optInt("status");
                                        int status_jpeg = data.optInt("status_jpeg");
                                        switch (status_jpeg) {
                                            case 0: {
                                                docErrStr = "jpeg\u6587\u6863\u5f85\u8f6c\u6362";
                                                break;
                                            }
                                            case 100: {
                                                docErrStr = "jpeg\u6587\u6863\u8f6c\u6362\u4e2d";
                                                break;
                                            }
                                            case 200: {
                                                docErrStr = "jpeg\u6587\u6863\u8f6c\u6362\u6210\u529f";
                                                doc_type = 2;
                                                break;
                                            }
                                            case 500: {
                                                docErrStr = "jpeg\u6587\u6863\u8f6c\u6362\u5931\u8d25";
                                                break;
                                            }
                                        }
                                        switch (status) {
                                            case 0: {
                                                docErrStr = docErrStr + " H5\u6587\u6863\u5f85\u8f6c\u6362";
                                                break;
                                            }
                                            case 100: {
                                                docErrStr = docErrStr + " H5\u6587\u6863\u8f6c\u6362\u4e2d";
                                                break;
                                            }
                                            case 200: {
                                                docErrStr = docErrStr + " H5\u6587\u6863\u8f6c\u6362\u6210\u529f";
                                                doc_type = 1;
                                                break;
                                            }
                                            case 500: {
                                                docErrStr = docErrStr + " H5\u6587\u6863\u8f6c\u6362\u5931\u8d25";
                                                break;
                                            }
                                        }
                                    }
                                    if (doc_type > 0) {
                                        String hash = data.optString("hash");
                                        ppt.setDoc(hash, data.toString());
                                    } else if (VHOPS.this.listener != null) {
                                        final String finalDocErrStr = docErrStr;
                                        VHOPS.this.handler.post(new Runnable(){

                                            @Override
                                            public void run() {
                                                VHOPS.this.listener.onError(301, 0, finalDocErrStr);
                                            }
                                        });
                                    }
                                }
                                ppt.setEditable(VHOPS.this.editAble);
                                break;
                            }
                            case 6: {
                                if (!ppt.isEditable()) {
                                    return;
                                }
                                try {
                                    JSONObject object = new JSONObject(eventMsg);
                                    object.put("docId", (Object)docId);
                                    object.put("pf", (Object)"android");
                                    object.put("switch", VHOPS.this.switchStatus == 1);
                                    String dataStr = object.toString();
                                    VLog.d((String)VHOPS.TAG, (String)("\u64cd\u4f5c\u6570\u636e\u56de\u8c03\uff1a" + dataStr));
                                    VHOPSApi.sendDocumentMsg(object.toString(), VHOPS.this.mAccessToken, VHOPS.this.mChannelId, VHOPS.this.mRoomId, new SendMsgCallback());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            case 4: {
                                try {
                                    JSONObject obj = new JSONObject(eventMsg);
                                    String type = obj.optString("type");
                                    if (!type.equals("pageChange")) break;
                                    VHOPS.this.uploadLogInfo(docId, obj);
                                    break;
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private void createBoard(final String cid, JSONObject data, final boolean needActive) {
        final DocumentView board = new DocumentView(this.context);
        if (null != this.mWatermarkOption) {
            board.setWatermark(this.mWatermarkOption.toJson());
        }
        board.init(cid, this.getInitOpts(data));
        this.viewMap.put(cid, board);
        if (this.listener != null) {
            this.listener.onEvent(KEY_OPERATE, TYPE_CREATE, cid);
        }
        board.addListener(new DocumentView.EventListener(){

            public void onEvent(int eventCode, String eventMsg) {
                switch (eventCode) {
                    case 1: {
                        board.createBoard(VhallSDK.getInstance().getmUserId());
                        if (needActive) {
                            VHOPS.this.activeCid = cid;
                            if (VHOPS.this.listener != null) {
                                VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
                            }
                            if (VHOPS.this.editAble) {
                                VHOPSApi.sendDocumentMsg(VHOPS.this.getOperateContent("board", VHOPS.this.docId, cid, KEY_OPERATE, TYPE_ACTIVE), VHOPS.this.mAccessToken, VHOPS.this.mChannelId, VHOPS.this.mRoomId, new SendMsgCallback());
                            }
                        }
                        if (VHOPS.this.isVod) {
                            board.setIsVod(true);
                            board.vodData(VHOPS.this.dataStr);
                        }
                        board.setEditable(VHOPS.this.editAble);
                        break;
                    }
                    case 6: {
                        if (!board.isEditable()) {
                            return;
                        }
                        try {
                            JSONObject object = new JSONObject(eventMsg);
                            object.put("docId", (Object)"");
                            object.put("pf", (Object)"android");
                            object.put("switch", VHOPS.this.switchStatus == 1);
                            String dataStr = object.toString();
                            VLog.d((String)VHOPS.TAG, (String)("\u64cd\u4f5c\u6570\u636e\u56de\u8c03\uff1a" + dataStr));
                            VHOPSApi.sendDocumentMsg(object.toString(), VHOPS.this.mAccessToken, VHOPS.this.mChannelId, VHOPS.this.mRoomId, new SendMsgCallback());
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private void createDocument(final String cid, JSONObject data, final boolean needActive) {
        final DocumentView ppt = new DocumentView(this.context);
        if (null != this.mWatermarkOption) {
            ppt.setWatermark(this.mWatermarkOption.toJson());
        }
        final String docId = data.optString("docId");
        ppt.setBackgroundColor(Color.parseColor((String)this.createColor));
        ppt.init(cid, this.getInitOpts(data));
        this.viewMap.put(cid, ppt);
        this.trackCreateEvent(docId);
        if (this.listener != null) {
            this.listener.onEvent(KEY_OPERATE, TYPE_CREATE, cid);
        }
        ppt.addListener(new DocumentView.EventListener(){

            public void onEvent(int eventCode, String eventMsg) {
                switch (eventCode) {
                    case 1: {
                        ppt.createDocument(VhallSDK.getInstance().getmUserId(), docId);
                        if (needActive) {
                            VHOPS.this.activeCid = cid;
                            if (VHOPS.this.listener != null) {
                                VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
                            }
                            if (VHOPS.this.editAble) {
                                VHOPSApi.sendDocumentMsg(VHOPS.this.getOperateContent("document", docId, cid, KEY_OPERATE, TYPE_ACTIVE), VHOPS.this.mAccessToken, VHOPS.this.mChannelId, VHOPS.this.mRoomId, new SendMsgCallback());
                            }
                        }
                        if (VHOPS.this.isVod) {
                            ppt.setIsVod(true);
                            ppt.vodData(VHOPS.this.dataStr);
                        } else if (!TextUtils.isEmpty((CharSequence)docId)) {
                            VHOPS.this.getDocInfo(cid, docId);
                        }
                        ppt.setEditable(VHOPS.this.editAble);
                        break;
                    }
                    case 6: {
                        if (!ppt.isEditable()) {
                            return;
                        }
                        try {
                            JSONObject object = new JSONObject(eventMsg);
                            object.put("docId", (Object)ppt.getDocId());
                            object.put("pf", (Object)"android");
                            object.put("switch", VHOPS.this.switchStatus == 1);
                            String dataStr = object.toString();
                            VLog.d((String)VHOPS.TAG, (String)("\u64cd\u4f5c\u6570\u636e\u56de\u8c03\uff1a" + dataStr));
                            VHOPSApi.sendDocumentMsg(object.toString(), VHOPS.this.mAccessToken, VHOPS.this.mChannelId, VHOPS.this.mRoomId, new SendMsgCallback());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 4: {
                        try {
                            JSONObject obj = new JSONObject(eventMsg);
                            String type = obj.optString("type");
                            if (!type.equals("pageChange")) break;
                            VHOPS.this.uploadLogInfo(docId, obj);
                            break;
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public void setBackgroundColor(String color) {
        this.createColor = color;
    }

    public void addView(String type, String param, double cw, double ch) {
        try {
            String cid = this.createCid(type);
            this.createWith = cw;
            this.createHeight = ch;
            String dataStr = this.getOperateContent(type, param, cid, KEY_OPERATE, TYPE_CREATE);
            JSONObject data = new JSONObject(dataStr);
            switch (type) {
                case "document": {
                    this.docId = param;
                    this.createDocument(cid, data, true);
                    break;
                }
                case "board": {
                    if (!TextUtils.isEmpty((CharSequence)param)) {
                        this.createColor = param;
                    }
                    this.createBoard(cid, data, true);
                    break;
                }
            }
            if (this.editAble) {
                VHOPSApi.sendDocumentMsg(dataStr, this.mAccessToken, this.mChannelId, this.mRoomId, new SendMsgCallback());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteView(String cid) {
        String docType = this.getDocTypeByCid(cid);
        this.destroy(cid);
        if (this.editAble) {
            VHOPSApi.sendDocumentMsg(this.getOperateContent(docType, "", cid, KEY_OPERATE, TYPE_DESTROY), this.mAccessToken, this.mChannelId, this.mRoomId, new SendMsgCallback());
        }
    }

    public boolean activeView(String cid) {
        if (this.viewMap.containsKey(cid) && this.activeCid != cid) {
            this.activeCid = cid;
            DocumentView view = this.viewMap.get(cid);
            String docType = view.getType();
            view.setEditable(this.editAble);
            if (this.listener != null) {
                this.listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
            }
            if (this.editAble) {
                VHOPSApi.sendDocumentMsg(this.getOperateContent(docType, "", cid, KEY_OPERATE, TYPE_ACTIVE), this.mAccessToken, this.mChannelId, this.mRoomId, new SendMsgCallback());
            }
            view.resetUndoManagerData();
            return true;
        }
        return false;
    }

    public void switchOff() {
        if (this.editAble) {
            this.switchStatus = 0;
            VHOPSApi.sendDocumentMsg(this.getOperateContent("", "", "", KEY_OPERATE, TYPE_SWITCHOFF), this.mAccessToken, this.mChannelId, this.mRoomId, new SendMsgCallback(TYPE_SWITCHOFF));
        }
    }

    public void switchOn() {
        if (this.editAble) {
            this.switchStatus = 1;
            VHOPSApi.sendDocumentMsg(this.getOperateContent("", "", "", KEY_OPERATE, TYPE_SWITCHON), this.mAccessToken, this.mChannelId, this.mRoomId, new SendMsgCallback(TYPE_SWITCHON));
        }
    }

    public void undo() {
        DocumentView activeView = this.getActiveView();
        if (null != activeView) {
            activeView.undo();
        }
    }

    public void redo() {
        DocumentView activeView = this.getActiveView();
        if (null != activeView) {
            activeView.redo();
        }
    }

    public void resetUndoManagerData() {
        DocumentView activeView = this.getActiveView();
        if (null != activeView) {
            activeView.resetUndoManagerData();
        }
    }

    private String getOperateContent(String docType, String param, String cid, String eventType, String operateType) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("hash", (Object)"");
            obj.put("uniqueID", System.currentTimeMillis());
            obj.put("currentPage", 0);
            obj.put("page", 0);
            obj.put("step", 0);
            obj.put("cw", this.createWith);
            obj.put("ch", this.createHeight);
            obj.put("width", this.createWith);
            obj.put("height", this.createHeight);
            obj.put("cid", (Object)cid);
            obj.put("ext", (Object)"");
            obj.put("version", (Object)"3.0.0");
            obj.put("doc_type", 2);
            obj.put("flipOver", 0);
            if (docType.equals("document")) {
                obj.put("docId", (Object)param);
            } else {
                obj.put("docId", (Object)"");
            }
            obj.put("switch", this.switchStatus == 1);
            obj.put("pf", (Object)"android");
            JSONArray commandArray = new JSONArray();
            JSONObject command = new JSONObject();
            command.put("type", (Object)operateType);
            command.put("stamp", System.currentTimeMillis());
            command.put("event", (Object)eventType);
            command.put("op", (Object)operateType);
            if (!TextUtils.isEmpty((CharSequence)docType)) {
                command.put("is_board", docType.equals("board") ? 2 : 1);
            }
            JSONObject data = new JSONObject();
            data.put("id", (Object)cid);
            data.put("width", this.createWith);
            data.put("height", this.createHeight);
            data.put("type", (Object)docType);
            if (docType.equals("board")) {
                data.put("backgroundColor", (Object)param);
            } else {
                data.put("backgroundColor", (Object)this.createColor);
            }
            command.put("data", (Object)data);
            commandArray.put((Object)command);
            obj.put("command", (Object)commandArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj.toString();
    }

    public void setEditable(boolean editAble) {
        this.editAble = editAble;
        for (Map.Entry<String, DocumentView> entry : this.viewMap.entrySet()) {
            entry.getValue().setEditable(editAble);
        }
    }

    public boolean isEditAble() {
        return this.editAble;
    }

    public void setWatermark(WatermarkOption watermark) {
        this.mWatermarkOption = watermark;
    }

    private void destroy(String id) {
        if (this.viewMap.containsKey(id)) {
            DocumentView documentView = this.viewMap.get(id);
            documentView.destroy();
            this.viewMap.remove(id);
        }
    }

    public DocumentView getViewByCid(String cid) {
        if (this.viewMap.containsKey(cid)) {
            return this.viewMap.get(cid);
        }
        return null;
    }

    private String getDocTypeByCid(String cid) {
        DocumentView targetDoc = this.getViewByCid(cid);
        if (null != targetDoc) {
            return targetDoc.getType();
        }
        return "";
    }

    public DocumentView getActiveView() {
        if (null != this.viewMap && this.viewMap.containsKey(this.activeCid)) {
            return this.viewMap.get(this.activeCid);
        }
        return null;
    }

    public String getActiveCid() {
        return this.activeCid;
    }

    public HashMap<String, DocumentView> getContainerInfo() {
        return this.viewMap;
    }

    public void resetContainerInfo() {
        this.viewMap.clear();
    }

    @Deprecated
    public void setDoc(String documentid) {
        this.getDocInfo(this.activeCid, documentid);
    }

    @Deprecated
    public String getDocId() {
        return this.activeCid;
    }

    private void getDocInfo(String cId, String docId) {
        VHOPSApi.getDocInfo(docId, this.mAccessToken, new MyDocCallback(cId));
    }

    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        this.mOnConnectChangedListener = listener;
    }

    public boolean join() {
        return VhallSDK.getInstance().join((IVHService)this);
    }

    public boolean leave() {
        return VhallSDK.getInstance().leave((IVHService)this);
    }

    public String getChannelId() {
        return this.mChannelId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void onMessage(final String msg) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject result = new JSONObject(msg);
                    String service_type = result.optString("service_type");
                    if (TextUtils.isEmpty((CharSequence)service_type) || !service_type.equals("service_document")) {
                        return;
                    }
                    JSONObject data = new JSONObject(result.optString("data"));
                    int flipOver = data.optInt("flipOver");
                    String userid = result.optString("sender_id");
                    String cid = data.optString("cid");
                    if (flipOver == 1) {
                        if (VHOPS.this.viewMap.containsKey(cid)) {
                            DocumentView mView = (DocumentView)VHOPS.this.viewMap.get(cid);
                            mView.doodle(data.toString());
                            JSONArray pageData = data.optJSONArray("pageData");
                            if (pageData != null) {
                                mView.setAllPageData(pageData.toString());
                            }
                        }
                    } else if (!VHOPS.this.editAble || !userid.equals(VhallSDK.getInstance().mUserId)) {
                        JSONArray commandArray = data.optJSONArray("command");
                        for (int i = 0; i < commandArray.length(); ++i) {
                            JSONObject obj = commandArray.optJSONObject(i);
                            String event = obj.optString("event");
                            String type = obj.optString("type");
                            int is_board = obj.optInt("is_board");
                            if (event.equals(KEY_OPERATE)) {
                                if (type.equals(TYPE_DESTROY)) {
                                    if (!VHOPS.this.viewMap.containsKey(cid)) continue;
                                    VHOPS.this.destroy(cid);
                                    if (VHOPS.this.listener == null) continue;
                                    VHOPS.this.listener.onEvent(event, type, cid);
                                    continue;
                                }
                                if (type.equals(TYPE_ACTIVE)) {
                                    if (VHOPS.this.viewMap.containsKey(cid)) {
                                        VHOPS.this.activeCid = cid;
                                        if (VHOPS.this.listener == null) continue;
                                        VHOPS.this.listener.onEvent(event, type, cid);
                                        continue;
                                    }
                                    if (is_board == 2) {
                                        VHOPS.this.createBoard(cid, data, true);
                                        continue;
                                    }
                                    VHOPS.this.createDocument(cid, data, true);
                                    continue;
                                }
                                if (type.equals(TYPE_CREATE)) {
                                    if (VHOPS.this.viewMap.containsKey(cid)) continue;
                                    if (is_board == 1) {
                                        VHOPS.this.createDocument(cid, data, false);
                                        continue;
                                    }
                                    VHOPS.this.createBoard(cid, data, false);
                                    continue;
                                }
                                if (VHOPS.this.listener == null) continue;
                                VHOPS.this.listener.onEvent(event, type, cid);
                                continue;
                            }
                            if (!event.equals(KEY_READY) || VHOPS.this.viewMap.containsKey(cid) || is_board != 1) continue;
                            VHOPS.this.createDocument(cid, data, true);
                        }
                        if (VHOPS.this.viewMap.containsKey(cid)) {
                            DocumentView mView = (DocumentView)VHOPS.this.viewMap.get(cid);
                            mView.doodle(data.toString());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long)this.dealTime);
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (this.mOnConnectChangedListener != null) {
            this.mOnConnectChangedListener.onStateChanged(state, serverType);
        }
    }

    private void uploadLogInfo(String docId, JSONObject data) {
        if (data != null) {
            try {
                JSONObject object = new JSONObject();
                object.put("uid", (Object)LogInfo.getInstance().getUid());
                object.put("doc_id", (Object)docId);
                object.put("app_id", (Object)VhallSDK.getInstance().getAPP_ID());
                object.put("vfid", (Object)LogInfo.getInstance().getAccount_id());
                object.put("service_names", LogInfo.getInstance().vtype);
                object.put("view_type", 2);
                object.put("pf", 5);
                object.put("bu", 1);
                object.put("page_number", data.optInt("slideIndex"));
                object.put("share_times", 1);
                String objStr = object.toString();
                String token = Base64.encodeToString((byte[])objStr.getBytes(), (int)2).toString();
                String id = String.valueOf(System.currentTimeMillis());
                VHOPSApi.uploadLog(DOC_K, id, LogInfo.getInstance().getSession_id(), 1, token);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String getInitOpts(JSONObject obj) {
        JSONObject data = new JSONObject();
        JSONObject control = new JSONObject();
        JSONObject advance = new JSONObject();
        JSONObject basic = new JSONObject();
        String backColor = null;
        double cw = 0.0;
        double ch = 0.0;
        if (obj != null) {
            JSONArray commandArr;
            backColor = obj.optString("backgroundColor");
            if (TextUtils.isEmpty((CharSequence)backColor) && (commandArr = obj.optJSONArray("command")) != null) {
                JSONObject commandData = commandArr.optJSONObject(0).optJSONObject("data");
                backColor = commandData.optString("backgroundColor");
            }
            cw = obj.optDouble("cw");
            ch = obj.optDouble("ch");
        } else {
            backColor = this.createColor;
            cw = this.createWith;
            ch = this.createHeight;
        }
        try {
            data.put("control", (Object)control);
            advance.put("multiTouch", 1);
            data.put("advance", (Object)advance);
            basic.put("urlBase", (Object)(VhallSDK.getInstance().mDocHost + "/"));
            if (TextUtils.isEmpty((CharSequence)backColor)) {
                basic.put("backgroundColor", (Object)"#ffffff");
            } else {
                basic.put("backgroundColor", (Object)backColor);
            }
            basic.put("width", cw);
            basic.put("height", ch);
            data.put("basic", (Object)basic);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        VLog.d((String)TAG, (String)("initOpts:" + data.toString()));
        return data.toString();
    }

    public static void upload(String filePath, String rename, String accessToken, final DocUploadCallback callback) {
        final Handler mHandler = new Handler(Looper.getMainLooper());
        File file = new File(filePath);
        if (!VhallSDK.getInstance().documentExt.contains(VHOPS.getExtensionName(file.getName()))) {
            if (callback != null) {
                callback.onFailure(590000, "document type error");
            }
            return;
        }
        if (file.length() > (long)VhallSDK.getInstance().documentMaxSize) {
            int max = VhallSDK.getInstance().documentMaxSize / 1024 / 1024;
            callback.onFailure(590001, "The maximum file size is  " + max + "M");
            return;
        }
        VHAPI.ProgressRequestBody.ProgressListener myListener = null;
        if (callback != null) {
            myListener = new VHAPI.ProgressRequestBody.ProgressListener(){

                public void onProgress(long totalBytes, long remainingBytes, boolean done) {
                    callback.onProgress(totalBytes, remainingBytes, done);
                }
            };
        }
        if (!TextUtils.isEmpty((CharSequence)rename)) {
            rename = rename + "." + VHOPS.getExtensionName(file.getName());
        }
        VHOPSApi.upload(filePath, rename, accessToken, myListener, new Callback(){

            public void onFailure(Call call, final IOException e) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure(-1, e.getMessage());
                    }
                });
            }

            public void onResponse(Call call, final Response response) throws IOException {
                final String res = response.body().string();
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        block9: {
                            if (response.code() == 200) {
                                try {
                                    JSONObject obj = new JSONObject(res);
                                    int code = obj.optInt("code");
                                    String msg = obj.optString("msg");
                                    if (code == 200) {
                                        JSONObject data = obj.optJSONObject("data");
                                        String documentId = data.optString("document_id");
                                        if (callback != null) {
                                            callback.onSuccess(documentId);
                                        }
                                    } else if (callback != null) {
                                        callback.onFailure(code, msg);
                                    }
                                    break block9;
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    if (callback != null) {
                                        callback.onFailure(-2, "Error json");
                                    }
                                    break block9;
                                }
                            }
                            if (callback != null) {
                                callback.onFailure(response.code(), response.message());
                            }
                        }
                    }
                });
            }
        });
    }

    public static String getUploadConfig() {
        String s = VhallSDK.getInstance().documentExt;
        int max = VhallSDK.getInstance().documentMaxSize;
        JSONObject object = new JSONObject();
        try {
            object.put("ext", (Object)s);
            object.put("maxSize", max);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    public static String getExtensionName(String fileName) {
        int dot;
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(".")) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return "";
    }

    private String createCid(String type) {
        UUID uuid = UUID.randomUUID();
        String cid = uuid.toString().substring(0, 8);
        return type + "-" + cid;
    }

    public void sendSpecial() {
        VHOPSApi.sendSpecial(this.mRoomId, this.mChannelId, this.mAccessToken, new SendMsgCallback());
    }

    public void setCue_point(String cue_point) {
        this.getFile(cue_point);
        this.isVod = true;
    }

    private void getFile(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (this.context == null) {
            return;
        }
        this.dataMap.clear();
        this.dataMap.put(TYPE_SWITCH, new ArrayList());
        this.dataMap.put(TYPE_CREATE, new ArrayList());
        this.dataMap.put(TYPE_ACTIVE, new ArrayList());
        this.dataMap.put(TYPE_DESTROY, new ArrayList());
        this.dataMap.put(KEY_READY, new ArrayList());
        FileUtil.getCuePointFile((String)url, (Context)this.context, (FileUtil.FileCallback)new FileUtil.FileCallback(){

            public void onFile(File file) {
                VHOPS.this.parseFile(file);
            }
        });
    }

    public static String unCompress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        int n = 0;
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("GBK");
    }

    private synchronized void parseFile(File file) {
        if (file == null || file.length() <= 0L) {
            return;
        }
        this.dataStr = FileUtil.readFile2String((File)file);
        if (file.getName().contains(".zip")) {
            try {
                this.dataStr = VHOPS.unCompress(this.dataStr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.dataStr)) {
            return;
        }
        if (this.dataStr.startsWith("\ufeff")) {
            this.dataStr = this.dataStr.substring(1);
        }
        VLog.d((String)TAG, (String)this.dataStr);
        try {
            JSONObject obj = new JSONObject(this.dataStr);
            JSONArray cuepoint = obj.optJSONArray("cuepoint");
            if (cuepoint != null && obj.length() > 0) {
                for (int i = 0; i < cuepoint.length(); ++i) {
                    JSONObject cue = cuepoint.optJSONObject(i);
                    if (cue == null) continue;
                    double createTime = cue.optDouble("created_at") * 1000.0;
                    String content = cue.optString("content2");
                    String key = "";
                    String innerKey = "";
                    if (content.indexOf(TYPE_CREATE) >= 0) {
                        key = TYPE_CREATE;
                    } else if (content.indexOf(TYPE_ACTIVE) >= 0) {
                        key = TYPE_ACTIVE;
                    } else if (content.indexOf(TYPE_DESTROY) >= 0) {
                        key = TYPE_DESTROY;
                    } else if (content.indexOf(TYPE_SWITCHOFF) >= 0) {
                        key = TYPE_SWITCH;
                        innerKey = TYPE_SWITCHOFF;
                    } else if (content.indexOf(TYPE_SWITCHON) >= 0) {
                        key = TYPE_SWITCH;
                        innerKey = TYPE_SWITCHON;
                    } else if (content.indexOf(KEY_READY) >= 0) {
                        key = KEY_READY;
                    }
                    if ("".equals(key)) continue;
                    DocInfo info = new DocInfo();
                    JSONObject point = new JSONObject(content);
                    info.key = key;
                    info.innerKey = innerKey;
                    info.create = createTime;
                    info.cid = point.optString("cid");
                    info.docId = point.optString("docId");
                    info.data = point;
                    if (point.has("command")) {
                        JSONArray commandArray = point.optJSONArray("command");
                        JSONObject command = commandArray.optJSONObject(0);
                        info.isBoard = command.optInt("is_board");
                        if (command.has("data")) {
                            JSONObject data = command.optJSONObject("data");
                            info.backgroundColor = data.optString("backgroundColor");
                        }
                    }
                    this.dataMap.get(key).add(info);
                }
            }
            this.dataStr = this.dataStr.replace("\\\"", "\\\\\\\"");
            this.isVodDocInited = true;
            if (this.listener != null) {
                this.listener.onEvent(KEY_OPERATE, TYPE_VODDocInited, null);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setTime(long time) {
        this.seekto(time);
        if (this.isVodDocInited) {
            this.curPosition = time;
        }
    }

    public void seekTo(long time) {
        this.curPosition = 0L;
        this.seekto(time);
    }

    private void seekto(long time) {
        if (!this.isVodDocInited) {
            return;
        }
        for (Map.Entry<String, List<DocInfo>> entry : this.dataMap.entrySet()) {
            List<DocInfo> list = entry.getValue();
            ArrayList<DocInfo> dataList = new ArrayList<DocInfo>();
            String opType = entry.getKey();
            for (int i = 0; i < list.size(); ++i) {
                DocInfo info = list.get(i);
                if (info.create >= (double)this.curPosition && info.create < (double)time) {
                    dataList.add(info);
                    continue;
                }
                if (info.create > (double)time) break;
            }
            if (dataList.size() == 0 && opType.equals(TYPE_SWITCH) && list.size() > 0 && list.get((int)0).create > (double)time && this.switchType.equals(TYPE_SWITCHON)) {
                this.switchType = TYPE_SWITCHOFF;
                if (this.listener != null) {
                    this.listener.onEvent(KEY_OPERATE, TYPE_SWITCHOFF, null);
                }
            }
            if (this.listener == null || dataList.size() <= 0) continue;
            if (opType.equals(TYPE_CREATE)) {
                for (DocInfo info : dataList) {
                    if (this.viewMap.containsKey(info.cid)) continue;
                    if (info.isBoard == 1) {
                        this.createDocument(info.cid, info.data, false);
                        continue;
                    }
                    this.createBoard(info.cid, info.data, false);
                }
                continue;
            }
            if (opType.equals(TYPE_DESTROY)) {
                for (DocInfo info : dataList) {
                    if (!this.viewMap.containsKey(info.cid)) continue;
                    this.destroy(info.cid);
                    this.listener.onEvent(KEY_OPERATE, opType, info.cid);
                }
                continue;
            }
            if (opType.equals(TYPE_ACTIVE)) {
                DocInfo info = (DocInfo)dataList.get(dataList.size() - 1);
                if (this.activeCid == info.cid) continue;
                this.activeCid = info.cid;
                if (this.viewMap.containsKey(info.cid)) {
                    this.listener.onEvent(KEY_OPERATE, opType, info.cid);
                    continue;
                }
                if (info.isBoard == 1) {
                    this.createDocument(info.cid, info.data, true);
                    continue;
                }
                this.createBoard(info.cid, info.data, true);
                continue;
            }
            if (!opType.equals(TYPE_SWITCH)) continue;
            DocInfo docInfo = (DocInfo)dataList.get(dataList.size() - 1);
            if (this.switchType.equals(docInfo.innerKey)) continue;
            this.switchType = docInfo.innerKey;
            this.listener.onEvent(KEY_OPERATE, docInfo.innerKey, docInfo.cid);
        }
        this.curPosition = time;
        for (Map.Entry<String, DocumentView> entry : this.viewMap.entrySet()) {
            entry.getValue().vodTime((double)time / 1000.0);
        }
    }

    private void trackCreateEvent(String documentId) {
        JSONObject params = new JSONObject();
        try {
            params.put("documentId", (Object)documentId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2009", params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mRoomId)) {
                params.put("roomId", (Object)this.mRoomId);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mRecordId)) {
                params.put("recordId", (Object)this.mRecordId);
            }
            params.put("channelId", (Object)this.mChannelId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2005", params);
    }

    class DocInfo {
        double create;
        String cid;
        String key;
        int isBoard;
        String docId;
        JSONObject data;
        String backgroundColor;
        String innerKey;

        DocInfo() {
        }
    }

    class SendMsgCallback
    implements Callback {
        private String mActionType = "";

        public SendMsgCallback() {
        }

        public SendMsgCallback(String actionType) {
            this.mActionType = actionType;
        }

        public void onFailure(Call call, IOException e) {
            if (VHOPS.this.listener != null) {
                VHOPS.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        VHOPS.this.listener.onError(201, -1, "Network request failed \uff01");
                    }
                });
            }
        }

        public void onResponse(Call call, Response response) throws IOException {
            String resultStr = response.body().string();
            VLog.d((String)VHOPS.TAG, (String)("docInfo:" + resultStr));
            try {
                JSONObject data = new JSONObject(resultStr);
                final int code = data.optInt("code");
                final String msg = data.optString("msg");
                if (code != 200 && VHOPS.this.listener != null) {
                    VHOPS.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            VHOPS.this.listener.onError(201, code, msg);
                        }
                    });
                } else if (this.mActionType.equals(TYPE_SWITCHON)) {
                    if (null != VHOPS.this.listener) {
                        VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_SWITCHON, null);
                    }
                } else if (this.mActionType.equals(TYPE_SWITCHOFF) && null != VHOPS.this.listener) {
                    VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_SWITCHOFF, null);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    class MyDocCallback
    implements Callback {
        private String cId;

        public MyDocCallback(String cId) {
            this.cId = cId;
        }

        public void onFailure(Call call, IOException e) {
            final JSONObject obj = new JSONObject();
            try {
                obj.put("msg", (Object)"Network request failed \uff01");
                obj.put("cid", (Object)this.cId);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            VHOPS.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (VHOPS.this.listener != null) {
                        VHOPS.this.listener.onError(101, -1, obj.toString());
                    }
                }
            });
        }

        public void onResponse(Call call, Response response) throws IOException {
            block21: {
                String resultStr = response.body().string();
                VLog.d((String)VHOPS.TAG, (String)("docInfo:" + resultStr));
                try {
                    JSONObject result = new JSONObject(resultStr);
                    final int code = result.getInt("code");
                    String msg = result.optString("msg");
                    if (code == 200) {
                        final JSONObject data = result.getJSONObject("data");
                        final String hash = data.getString("hash");
                        data.put("show_page", (Object)"0");
                        data.put("show_step", (Object)"0");
                        String docErrStr = "";
                        int doc_type = data.optInt("doc_type");
                        if (doc_type == 0) {
                            int status = data.optInt("status");
                            int status_jpeg = data.optInt("status_jpeg");
                            switch (status_jpeg) {
                                case 0: {
                                    docErrStr = "jpeg\u6587\u6863\u5f85\u8f6c\u6362";
                                    break;
                                }
                                case 100: {
                                    docErrStr = "jpeg\u6587\u6863\u8f6c\u6362\u4e2d";
                                    break;
                                }
                                case 200: {
                                    docErrStr = "jpeg\u6587\u6863\u8f6c\u6362\u6210\u529f";
                                    doc_type = 2;
                                    break;
                                }
                                case 500: {
                                    docErrStr = "jpeg\u6587\u6863\u8f6c\u6362\u5931\u8d25";
                                    break;
                                }
                            }
                            switch (status) {
                                case 0: {
                                    docErrStr = docErrStr + " H5\u6587\u6863\u5f85\u8f6c\u6362";
                                    break;
                                }
                                case 100: {
                                    docErrStr = docErrStr + " H5\u6587\u6863\u8f6c\u6362\u4e2d";
                                    break;
                                }
                                case 200: {
                                    docErrStr = docErrStr + " H5\u6587\u6863\u8f6c\u6362\u6210\u529f";
                                    doc_type = 1;
                                    break;
                                }
                                case 500: {
                                    docErrStr = docErrStr + " H5\u6587\u6863\u8f6c\u6362\u5931\u8d25";
                                    break;
                                }
                            }
                        }
                        if (doc_type > 0) {
                            if (VHOPS.this.viewMap.containsKey(this.cId)) {
                                final DocumentView mView = (DocumentView)VHOPS.this.viewMap.get(this.cId);
                                mView.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        mView.setEditable(VHOPS.this.editAble);
                                        mView.setDoc(hash, data.toString());
                                    }
                                });
                            }
                        } else {
                            VLog.e((String)VHOPS.TAG, (String)docErrStr);
                        }
                        break block21;
                    }
                    if (VHOPS.this.listener == null) break block21;
                    final JSONObject obj = new JSONObject();
                    try {
                        obj.put("msg", (Object)msg);
                        obj.put("cid", (Object)this.cId);
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                    VHOPS.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            VHOPS.this.listener.onError(101, code, obj.toString());
                        }
                    });
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class MyWatchInfoCallback
    implements Callback {
        MyWatchInfoCallback() {
        }

        public void onFailure(Call call, IOException e) {
            VLog.e((String)VHOPS.TAG, (String)"\u52a0\u8f7d\u6587\u6863\u5931\u8d25\uff01");
            if (null != e) {
                e.printStackTrace();
            }
            VHOPS.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (VHOPS.this.listener != null) {
                        VHOPS.this.listener.onError(-1, 0, "Network request failed \uff01");
                    }
                }
            });
        }

        public void onResponse(Call call, Response response) throws IOException {
            String resultStr = response.body().string();
            try {
                JSONObject result = new JSONObject(resultStr);
                final int code = result.optInt("code");
                final String msg = result.optString("msg");
                if (code == 200) {
                    JSONObject data = result.optJSONObject("data");
                    JSONArray array = data.optJSONArray("list");
                    VHOPS.this.switchStatus = data.optInt("switch_status");
                    VHOPS.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (VHOPS.this.listener != null) {
                                if (VHOPS.this.switchStatus == 1) {
                                    VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_SWITCHON, "");
                                } else {
                                    VHOPS.this.listener.onEvent(KEY_OPERATE, TYPE_SWITCHOFF, "");
                                }
                            }
                        }
                    });
                    if (array.length() > 0) {
                        for (int i = 0; i < array.length(); ++i) {
                            JSONObject docData = array.optJSONObject(i);
                            String cid = docData.optString("cid");
                            int is_board = docData.optInt("is_board");
                            int active = docData.optInt("active");
                            if (active == 1) {
                                VHOPS.this.activeCid = cid;
                            }
                            if (is_board == 2) {
                                VHOPS.this.createBoard(cid, docData);
                                continue;
                            }
                            VHOPS.this.createDocument(cid, docData);
                        }
                    }
                } else {
                    VHOPS.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (VHOPS.this.listener != null) {
                                VHOPS.this.listener.onError(code, 0, msg);
                            }
                        }
                    });
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface EventListener {
        public void onEvent(String var1, String var2, String var3);

        public void onError(int var1, int var2, String var3);
    }

    public static interface DocUploadCallback {
        public void onSuccess(String var1);

        public void onFailure(int var1, String var2);

        public void onProgress(long var1, long var3, boolean var5);
    }
}

