package com.vhall.ops;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author：jooper Email：jooperge@163.com
 * 描述：
 * 修改历史:
 * <p>
 * 创建于： 2022/5/17
 */
public class WatermarkOption {
    private String text = "";
    private String color = "#000000";
    private int angle = 0;
    /**
     * [0, 1]
     */
    private float opacity = 0.9f;
    /**
     * range: [12, 48]
     */
    private int fontSize = 16;

    public WatermarkOption() {
    }

    public WatermarkOption(String text, String color, int angle, float opacity, int fontSize) {
        this.text = text;
        this.color = color;
        this.angle = angle;
        this.opacity = opacity;
        this.fontSize = fontSize;
    }

    public String toJson() {
        JSONObject watermark = new JSONObject();
        try {
            watermark.put("text", text);
            watermark.put("color", color);
            watermark.put("angle", angle);
            watermark.put("opacity", opacity);
            watermark.put("fontSize", fontSize);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return watermark.toString();
    }
}