package com.vhall.ops;

import static com.vhall.document.DocumentView.DOC_BOARD;
import static com.vhall.document.DocumentView.DOC_DOCUMENT;
import static com.vhall.ops.VHOPSApi.TYPE_DOCUMENT;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Base64;

import com.vhall.document.DocumentView;
import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.framework.utils.FileUtil;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

/**
 * Created by Hank on 2017/12/14.
 * DocumentView 销毁时自动释放所有回调
 * 文档
 */
public class VHOPS implements IVHService {
    private static final String TAG = "VHDocument";
    private static final int MODE_STREAM = 1;
    private static final int MODE_RECORD = 2;

    private String mChannelId = "";
    private String mRoomId = "";
    private String mRecordId = "";
    private String mAccessToken = "";
    private String mDocId = "";
    private static final int ERROR_TYPE = 590000;//文件类型错误
    private static final int ERROR_OUT_LIMIT = 590001;//文件过大

    private int mMode = -1;//直播还是回放
    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;
    private boolean isLoadLastDoc = true;//默认加载上次文档
    private Context context;
    private HashMap<String, DocumentView> viewMap = new HashMap<>();
    private int switchStatus = 1;//文档演示状态  1 开启 0 关闭
    private Handler handler = new Handler(Looper.getMainLooper());
    private String activeCid = "";
    private EventListener listener;
    private boolean editAble = false;

    private LinkedHashMap<String, List<DocInfo>> dataMap = new LinkedHashMap<>();
    private String dataStr = "";
    public static String TYPE_VODDocInited  = "VodDocInited";
    public static String TYPE_CREATE = "create";
    public static String TYPE_DESTROY = "destroy";
    public static String TYPE_ACTIVE = "active";
    public static String TYPE_SWITCHOFF = "switchoff";
    public static String TYPE_SWITCHON = "switchon";
    private static String TYPE_SWITCH = "switch";
    public static String TYPE_RESET = "reset";
    public static String KEY_OPERATE = "operate";
    public static String KEY_READY = "ready";
    public static final int ERROR_CONNECT = -1;
    public static final int ERROR_DOC_INFO = 101;//ppt信息获取异常
    public static final int ERROR_SEND = 201;//文档消息发送异常
    public static final int ERROR_DOC_EXCEPTION = 301;//文档转换异常
    private long curPosition = 0;
    private String switchType = TYPE_SWITCHOFF;
    private int dealTime = 0;
    //    private int scaleMode = 2;//发起端文档比例设置 1 （4：3）  2 （16：9）
    private double createWith = 800, createHeight = 600;
    private String createColor = "#ffffff";
    private String docId = "";
    private WatermarkOption mWatermarkOption = null;

    public boolean isVodDocInited = false;

    public interface DocUploadCallback {
        void onSuccess(String documentId);

        void onFailure(int errorCode, String errorMsg);

        void onProgress(long totalBytes, long remainingBytes, boolean done);
    }

    public interface EventListener {
        void onEvent(String event, String type, String cid);

        void onError(int errorCode, int innerError, String errorMsg);
    }

    public void setListener(EventListener listener) {
        this.listener = listener;
    }

    /**
     * 直播状态下构建方式
     *
     * @param channelId   文档渠道ID 也可以是 recordId
     * @param roomid      该渠道对应的房间ID，纯文档直播传空
     * @param accessToken
     */
    public VHOPS(Context context, String channelId, String roomid, String accessToken) {
        this(context, channelId, roomid, accessToken, true);
    }

    /**
     * 直播状态下构建方式
     *
     * @param channelId   文档渠道id
     * @param roomid      该渠道对应的房间ID，纯文档直播传空
     * @param accessToken
     * @param loadLastDoc 是否加载上次演示文档
     */
    public VHOPS(Context context, String channelId, String roomid, String accessToken, boolean loadLastDoc) {
        this.context = context;
        this.mChannelId = channelId;
        this.mRoomId = roomid;
        this.mAccessToken = accessToken;
        isLoadLastDoc = loadLastDoc;
        mMode = MODE_STREAM;
        LogInfo.getInstance().vtype = 1;
        trackInitEvent();
        if (isLoadLastDoc) {
            VHOPSApi.getWatchDoc(channelId, accessToken, new MyWatchInfoCallback());
        }
    }

    /**
     * 重置房间文档信息
     */
    public void resetWatchInfo() {
        if (editAble && mMode == MODE_STREAM) {
            VHOPSApi.resetWatchInfo(mChannelId, mAccessToken, null);
        }
    }

    /**
     * 录播环境下的文档模式
     * 增加 token 为了防止重载方法一样，所以在前面添加 accessToken
     * @param recordId
     * @param channelid 一个回放有多文档实例时，传入channelid，单个文档实例，不用传
     */
    public VHOPS(String accessToken,Context context, String recordId, String channelid) {
        this.context = context;
        mRecordId = recordId;
        mMode = MODE_RECORD;
        this.mAccessToken = accessToken;
        if (TextUtils.isEmpty(channelid)) {
            mChannelId = recordId;
        } else {
            mChannelId = channelid;
        }
        LogInfo.getInstance().vtype = 2;
        trackInitEvent();
    }

    public void setDealTime(int dealTime) {
        this.dealTime = dealTime;
    }

    /**
     * 创建白板实例
     *
     * @param id
     */
    private void createBoard(final String id, final JSONObject data) {
        handler.post(new Runnable() {
            @Override
            public void run() {
                final DocumentView board = new DocumentView(context);
                if (null != mWatermarkOption) {
                    board.setWatermark(mWatermarkOption.toJson());
                }
                board.init(id, getInitOpts(data));
                viewMap.put(id, board);
                if (listener != null) {
                    listener.onEvent(KEY_OPERATE, TYPE_CREATE, id);
                }
                board.addListener(new DocumentView.EventListener() {
                    @Override
                    public void onEvent(int eventCode, String eventMsg) {
                        switch (eventCode) {
                            case DocumentView.EVENT_PAGE_LOADED:
                                board.createBoard(VhallSDK.getInstance().getmUserId());
                                if (listener != null) {
                                    if (activeCid == id) {
                                        if(listener != null)
                                            listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, id);
                                    }
                                }
                                if (mMode == MODE_STREAM) {//直播
                                    final JSONArray pageData = data.optJSONArray("pageData");
                                    for (int i = 0; i < pageData.length(); i++) {
                                        board.doodle(pageData.optJSONObject(i).toString());
                                    }
                                }
                                board.setEditable(editAble);
                                break;
                            case DocumentView.EVENT_DOODLE_BACK://画板吐出的数据
                                if (!board.isEditable())//非编辑状态不往服务器发送数据
                                    return;
                                try {
                                    JSONObject object = new JSONObject(eventMsg);
                                    object.put("docId", "");
                                    object.put("pf", "android");
                                    object.put("switch", switchStatus == 1 ? true : false);
                                    String dataStr = object.toString();
                                    VLog.d(TAG, "操作数据回调：" + dataStr);
                                    VHOPSApi.sendDocumentMsg(object.toString(), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break;
                        }
                    }
                });
            }
        });

    }

    /**
     * 创建ppt实例
     *
     * @param cid
     */
    private void createDocument(final String cid, final JSONObject data) {
        final String docId = data.optString("docId");
        handler.post(new Runnable() {
            @Override
            public void run() {
                final DocumentView ppt = new DocumentView(context);
                if (null != mWatermarkOption) {
                    ppt.setWatermark(mWatermarkOption.toJson());
                }
                ppt.init(cid, getInitOpts(data));
                viewMap.put(cid, ppt);
                trackCreateEvent(docId);
                if (listener != null) {
                    listener.onEvent(KEY_OPERATE, TYPE_CREATE, cid);
                }
                ppt.addListener(new DocumentView.EventListener() {
                    @Override
                    public void onEvent(int eventCode, String eventMsg) {
                        switch (eventCode) {
                            case DocumentView.EVENT_PAGE_LOADED:
                                ppt.createDocument(VhallSDK.getInstance().getmUserId(), docId);
                                if (listener != null) {
                                    if (activeCid == cid) {
                                        listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
                                    }
                                }
                                if (mMode == MODE_STREAM) {
                                    String docErrStr = "";
                                    int doc_type = data.optInt("doc_type");
                                    if (doc_type == 0) {
                                        int status = data.optInt("status");
                                        int status_jpeg = data.optInt("status_jpeg");
                                        switch (status_jpeg) {
                                            case 0:
                                                docErrStr = "jpeg文档待转换";
                                                break;
                                            case 100:
                                                docErrStr = "jpeg文档转换中";
                                                break;
                                            case 200:
                                                docErrStr = "jpeg文档转换成功";
                                                doc_type = 2;
                                                break;
                                            case 500:
                                                docErrStr = "jpeg文档转换失败";
                                                break;
                                            default:
                                                break;
                                        }
                                        switch (status) {
                                            case 0:
                                                docErrStr += " H5文档待转换";
                                                break;
                                            case 100:
                                                docErrStr += " H5文档转换中";
                                                break;
                                            case 200:
                                                docErrStr += " H5文档转换成功";
                                                doc_type = 1;
                                                break;
                                            case 500:
                                                docErrStr += " H5文档转换失败";
                                                break;
                                            default:
                                                break;
                                        }
                                    }

                                    if (doc_type > 0) {
//                                        JSONArray pageData = data.optJSONArray("pageData");
                                        String hash = data.optString("hash");
                                        ppt.setDoc(hash, data.toString());
//                                        ppt.setAllPageData(pageData.toString());
                                    } else {
                                        if (listener != null) {
                                            final String finalDocErrStr = docErrStr;
                                            handler.post(new Runnable() {
                                                @Override
                                                public void run() {
                                                    listener.onError(ERROR_DOC_EXCEPTION, 0, finalDocErrStr);
                                                }
                                            });
                                        }
                                    }
                                }
                                ppt.setEditable(editAble);
                                break;
                            case DocumentView.EVENT_DOODLE_BACK:
                                if (!ppt.isEditable())//非编辑状态不往服务器发送数据
                                    return;
                                try {
                                    JSONObject object = new JSONObject(eventMsg);
                                    object.put("docId", docId);
                                    object.put("pf", "android");
                                    object.put("switch", switchStatus == 1 ? true : false);
                                    String dataStr = object.toString();
                                    VLog.d(TAG, "操作数据回调：" + dataStr);
                                    VHOPSApi.sendDocumentMsg(object.toString(), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break;
                            case DocumentView.EVENT_DOODLE:
                                try {
                                    JSONObject obj = new JSONObject(eventMsg);
                                    String type = obj.optString("type");
                                    if (type.equals("pageChange")) {
                                        uploadLogInfo(docId, obj);
                                    }
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                break;
                        }
                    }
                });
            }
        });

    }


    private void createBoard(final String cid, final JSONObject data, final boolean needActive) {
        final DocumentView board = new DocumentView(context);
        if (null != mWatermarkOption) {
            board.setWatermark(mWatermarkOption.toJson());
        }
        board.init(cid, getInitOpts(data));
        viewMap.put(cid, board);
        if (listener != null) {
            listener.onEvent(KEY_OPERATE, TYPE_CREATE, cid);
        }
        board.addListener(new DocumentView.EventListener() {
            @Override
            public void onEvent(int eventCode, String eventMsg) {
                switch (eventCode) {
                    case DocumentView.EVENT_PAGE_LOADED:
                        board.createBoard(VhallSDK.getInstance().getmUserId());
                        if (needActive) {
                            activeCid = cid;
                            if(listener != null){
                                listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
                            }
                            if (editAble) {
                                VHOPSApi.sendDocumentMsg(getOperateContent(DOC_BOARD, docId, cid, KEY_OPERATE, TYPE_ACTIVE), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
                            }
                        }
                        if (isVod) {
                            board.setIsVod(true);
                            board.vodData(dataStr);
                        }
                        board.setEditable(editAble);
                        break;
                    case DocumentView.EVENT_DOODLE_BACK:
                        if (!board.isEditable())//非编辑状态不往服务器发送数据
                            return;
                        try {
                            JSONObject object = new JSONObject(eventMsg);
                            object.put("docId", "");//白板可以为null
                            object.put("pf", "android");
                            object.put("switch", switchStatus == 1 ? true : false);
                            String dataStr = object.toString();
                            VLog.d(TAG, "操作数据回调：" + dataStr);
                            VHOPSApi.sendDocumentMsg(object.toString(), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;

                }
            }
        });

    }


    private void createDocument(final String cid, final JSONObject data, final boolean needActive) {
        final DocumentView ppt = new DocumentView(context);
        if (null != mWatermarkOption) {
            ppt.setWatermark(mWatermarkOption.toJson());
        }
        final String docId = data.optString("docId");
        ppt.setBackgroundColor(Color.parseColor(createColor));
        ppt.init(cid, getInitOpts(data));
        viewMap.put(cid, ppt);
        trackCreateEvent(docId);
        if (listener != null) {
            listener.onEvent(KEY_OPERATE, TYPE_CREATE, cid);
        }
        ppt.addListener(new DocumentView.EventListener() {
            @Override
            public void onEvent(int eventCode, String eventMsg) {
                switch (eventCode) {
                    case DocumentView.EVENT_PAGE_LOADED:
                        ppt.createDocument(VhallSDK.getInstance().getmUserId(), docId);
                        if (needActive) {
                            activeCid = cid;
                            if(listener != null){
                                listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
                            }
                            if (editAble) {
                                VHOPSApi.sendDocumentMsg(getOperateContent(DOC_DOCUMENT, docId, cid, KEY_OPERATE, TYPE_ACTIVE), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
                            }
                        }
                        if (isVod) {
                            ppt.setIsVod(true);
                            ppt.vodData(dataStr);
                        } else {
                            if (!TextUtils.isEmpty(docId)) {
                                getDocInfo(cid, docId);
                            }
                        }
                        ppt.setEditable(editAble);
                        break;
                    case DocumentView.EVENT_DOODLE_BACK:
                        if (!ppt.isEditable())//非编辑状态不往服务器发送数据
                            return;
                        try {
                            JSONObject object = new JSONObject(eventMsg);
                            object.put("docId", ppt.getDocId());//文档View加载的文档id 非文本档的cid
                            object.put("pf", "android");
                            object.put("switch", switchStatus == 1 ? true : false);
                            String dataStr = object.toString();
                            VLog.d(TAG, "操作数据回调：" + dataStr);
                            VHOPSApi.sendDocumentMsg(object.toString(), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    case DocumentView.EVENT_DOODLE:
                        try {
                            JSONObject obj = new JSONObject(eventMsg);
                            String type = obj.optString("type");
                            if (type.equals("pageChange")) {
                                uploadLogInfo(docId, obj);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        break;
                }
            }
        });
    }

    /**
     * 注意：类型为白板时，color会与addView()中配置的color产生时序问题导致先后覆盖
     * @param color
     */
    public void setBackgroundColor(String color) {
        createColor = color;
    }

    /**
     * @param type  文档类型
     * @param param type类型为DOC_DOCUMENT 是param为文档id，DOC_BOARD 时为白板背景颜色或者null（默认白色）
     * @param cw    文档绘制区域宽
     * @param ch    文档绘制区域高
     */
    public void addView(String type, String param, double cw, double ch) {
        try {
            String cid = createCid(type);
            createWith = cw;
            createHeight = ch;
            String dataStr = getOperateContent(type, param, cid, KEY_OPERATE, TYPE_CREATE);
            JSONObject data = new JSONObject(dataStr);
            switch (type) {
                case DOC_DOCUMENT:
                    docId = param;
                    createDocument(cid, data, true);
                    break;
                case DOC_BOARD:
                    if (!TextUtils.isEmpty(param)) {
                        createColor = param;
                    }
                    createBoard(cid, data, true);
                    break;
                default:
                    break;
            }
            if (editAble) {
                VHOPSApi.sendDocumentMsg(dataStr, mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    public void deleteView(String cid) {
        String docType = getDocTypeByCid(cid);
        destroy(cid);
        if (editAble) {
            VHOPSApi.sendDocumentMsg(getOperateContent(docType, "", cid, KEY_OPERATE, TYPE_DESTROY), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
        }
    }

    public boolean activeView(String cid) {
        String docType;
        if (viewMap.containsKey(cid) && activeCid != cid) {
            activeCid = cid;
            DocumentView view = viewMap.get(cid);
            docType = view.getType();
            view.setEditable(editAble);
            if (listener != null) {
                listener.onEvent(KEY_OPERATE, TYPE_ACTIVE, cid);
            }
            if (editAble) {
                VHOPSApi.sendDocumentMsg(getOperateContent(docType, "", cid, KEY_OPERATE, TYPE_ACTIVE), mAccessToken, mChannelId, mRoomId, new SendMsgCallback());
            }
            view.resetUndoManagerData();
            return true;
        }
        return false;
    }

    public void switchOff() {
        if (editAble) {
            switchStatus = 0;
            VHOPSApi.sendDocumentMsg(getOperateContent("", "", "", KEY_OPERATE, TYPE_SWITCHOFF), mAccessToken, mChannelId, mRoomId, new SendMsgCallback(TYPE_SWITCHOFF));
        }
    }

    public void switchOn() {
        if (editAble) {
            switchStatus = 1;
            VHOPSApi.sendDocumentMsg(getOperateContent("", "", "", KEY_OPERATE, TYPE_SWITCHON), mAccessToken, mChannelId, mRoomId, new SendMsgCallback(TYPE_SWITCHON));
        }
    }

    public void undo() {
        DocumentView activeView = getActiveView();
        if (null != activeView) {
            activeView.undo();
        }
    }

    public void redo(){
        DocumentView activeView = getActiveView();
        if (null != activeView) {
            activeView.redo();
        }
    }

    public void resetUndoManagerData() {
        DocumentView activeView = getActiveView();
        if (null != activeView) {
            activeView.resetUndoManagerData();
        }
    }

    private String getOperateContent(String docType, String param, String cid, String eventType, String operateType) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("hash", "");
            obj.put("uniqueID", System.currentTimeMillis());
            obj.put("currentPage", 0);
            obj.put("page", 0);
            obj.put("step", 0);
            obj.put("cw", createWith);
            obj.put("ch", createHeight);
            obj.put("width", createWith);
            obj.put("height", createHeight);
            obj.put("cid", cid);
            obj.put("ext", "");
            obj.put("version", "3.0.0");
            obj.put("doc_type", 2);
            obj.put("flipOver", 0);
            if (docType.equals(DOC_DOCUMENT)) {
                obj.put("docId", param);
            } else {
                obj.put("docId", "");
            }
            obj.put("switch", switchStatus == 1 ? true : false);
            obj.put("pf", "android");
            JSONArray commandArray = new JSONArray();
            JSONObject command = new JSONObject();
            command.put("type", operateType);
            command.put("stamp", System.currentTimeMillis());
            command.put("event", eventType);
            command.put("op", operateType);
            if (!TextUtils.isEmpty(docType)) {
                command.put("is_board", docType.equals(DOC_BOARD) ? 2 : 1);
            }
            JSONObject data = new JSONObject();
            data.put("id", cid);
            data.put("width", createWith);
            data.put("height", createHeight);
            data.put("type", docType);
            if (docType.equals(DOC_BOARD)) {
                data.put("backgroundColor", param);
            } else {
                data.put("backgroundColor", createColor);
            }
            command.put("data", data);
            commandArray.put(command);
            obj.put("command", commandArray);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return obj.toString();
    }

    public void setEditable(boolean editAble) {
        this.editAble = editAble;
        Iterator iterator = viewMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry) iterator.next();
            ((DocumentView) entry.getValue()).setEditable(editAble);
        }
    }

    public boolean isEditAble() {
        return editAble;
    }

    public void setWatermark(WatermarkOption watermark) {
        mWatermarkOption = watermark;
    }

    /**
     * 销毁实例
     *
     * @param id
     */
    private void destroy(String id) {
        if (viewMap.containsKey(id)) {
            DocumentView documentView = viewMap.get(id);
            documentView.destroy();
            viewMap.remove(id);
        }
    }

    /**
     * 根据cid获取实例
     *
     * @param cid
     * @return
     */
    public DocumentView getViewByCid(String cid) {
        if (viewMap.containsKey(cid)) {
            return viewMap.get(cid);
        }
        return null;
    }

    private String getDocTypeByCid(String cid) {
        DocumentView targetDoc = getViewByCid(cid);
        if (null != targetDoc) {
            return targetDoc.getType();
        }
        return "";
    }

    public DocumentView getActiveView() {
        if (null != viewMap && viewMap.containsKey(activeCid)) {
            return viewMap.get(activeCid);
        }
        return null;
    }

    public String getActiveCid() {
        return activeCid;
    }

    /**
     * 获取容器信息
     *
     * @return
     */
    public HashMap<String, DocumentView> getContainerInfo() {
        return viewMap;
    }

    /**
     * 重置容器信息
     */
    public void resetContainerInfo() {
        viewMap.clear();
    }


    @Deprecated
    public void setDoc(String documentid) {
        getDocInfo(activeCid, documentid);
    }

    @Deprecated
    public String getDocId() {
        return activeCid;
    }

    /**
     * 直播状态下，初始化文档信息 ID为空，说明为观看端，ID不为空，说明是发起端设置文档ID
     * 回放状态下，不需要获取文档信息
     */
    private void getDocInfo(String cId, String docId) {//空代表观看端，不为空代表发起端设置文档
        VHOPSApi.getDocInfo(docId, mAccessToken, new MyDocCallback(cId));
    }

    /**
     * 获取频道当前演示文档信息（多文档）回调
     */
    class MyWatchInfoCallback implements Callback {

        @Override
        public void onFailure(Call call, IOException e) {
            VLog.e(TAG, "加载文档失败！");
            if (null != e) {
                e.printStackTrace();
            }
            handler.post(new Runnable() {
                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(ERROR_CONNECT, 0, "Network request failed ！");
                    }
                }
            });
        }

        @Override
        public void onResponse(Call call, Response response) throws IOException {
            String resultStr = response.body().string();
            try {
                JSONObject result = new JSONObject(resultStr);
                final int code = result.optInt("code");
                final String msg = result.optString("msg");
                if (code == 200) {
                    final JSONObject data = result.optJSONObject("data");
                    JSONArray array = data.optJSONArray("list");
                    switchStatus = data.optInt("switch_status");
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            if (listener != null) {
                                if (switchStatus == 1) {
                                    listener.onEvent(KEY_OPERATE, TYPE_SWITCHON, "");
                                } else {
                                    listener.onEvent(KEY_OPERATE, TYPE_SWITCHOFF, "");
                                }
                            }
                        }
                    });
                    if (array.length() > 0) {
                        for (int i = 0; i < array.length(); i++) {
                            JSONObject docData = array.optJSONObject(i);
                            String cid = docData.optString("cid");
                            int is_board = docData.optInt("is_board");
                            int active = docData.optInt("active");
                            if (active == 1) {
                                activeCid = cid;
                            }
                            if (is_board == 2) {
                                createBoard(cid, docData);
                            } else {
                                createDocument(cid, docData);
                            }
                        }
                    }
                } else {
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            if (listener != null) {
                                listener.onError(code, 0, msg);
                            }
                        }
                    });
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    class MyDocCallback implements Callback {

        private String cId;

        public MyDocCallback(String cId) {
            this.cId = cId;

        }

        @Override
        public void onFailure(Call call, IOException e) {
            final JSONObject obj = new JSONObject();
            try {
                obj.put("msg", "Network request failed ！");
                obj.put("cid", cId);
            } catch (JSONException e1) {
                e1.printStackTrace();
            }
            handler.post(new Runnable() {
                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(ERROR_DOC_INFO, ERROR_CONNECT, obj.toString());
                    }
                }
            });
        }

        @Override
        public void onResponse(Call call, Response response) throws IOException {
            final String resultStr = response.body().string();
            VLog.d(TAG, "docInfo:" + resultStr);
            try {
                JSONObject result = new JSONObject(resultStr);
                final int code = result.getInt("code");
                String msg = result.optString("msg");
                if (code == 200) {
                    final JSONObject data = result.getJSONObject("data");
                    final String hash = data.getString("hash");
                    data.put("show_page", "0");
                    data.put("show_step", "0");
                    String docErrStr = "";
                    int doc_type = data.optInt("doc_type");
                    if (doc_type == 0) {
                        int status = data.optInt("status");
                        int status_jpeg = data.optInt("status_jpeg");

                        switch (status_jpeg) {
                            case 0:
                                docErrStr = "jpeg文档待转换";
                                break;
                            case 100:
                                docErrStr = "jpeg文档转换中";
                                break;
                            case 200:
                                docErrStr = "jpeg文档转换成功";
                                doc_type = 2;
                                break;
                            case 500:
                                docErrStr = "jpeg文档转换失败";
                                break;
                            default:
                                break;
                        }
                        switch (status) {
                            case 0:
                                docErrStr += " H5文档待转换";
                                break;
                            case 100:
                                docErrStr += " H5文档转换中";
                                break;
                            case 200:
                                docErrStr += " H5文档转换成功";
                                doc_type = 1;
                                break;
                            case 500:
                                docErrStr += " H5文档转换失败";
                                break;
                            default:
                                break;
                        }
                    }
                    if (doc_type > 0) {
                        if (viewMap.containsKey(cId)) {
                            final DocumentView mView = viewMap.get(cId);
                            mView.post(new Runnable() {
                                @Override
                                public void run() {
                                    mView.setEditable(editAble);
                                    mView.setDoc(hash, data.toString());
                                }
                            });
                        }

                    } else {
                        VLog.e(TAG, docErrStr);
                    }
                } else {
                    if (listener != null) {
                        final JSONObject obj = new JSONObject();
                        try {
                            obj.put("msg", msg);
                            obj.put("cid", cId);
                        } catch (JSONException e1) {
                            e1.printStackTrace();
                        }
                        handler.post(new Runnable() {
                            @Override
                            public void run() {
                                listener.onError(ERROR_DOC_INFO, code, obj.toString());
                            }
                        });
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    class SendMsgCallback implements Callback {

        private String mActionType = "";

        public SendMsgCallback() {
        }

        public SendMsgCallback(String actionType) {
            mActionType = actionType;
        }

        @Override
        public void onFailure(Call call, IOException e) {
            if (listener != null) {
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        listener.onError(ERROR_SEND, ERROR_CONNECT, "Network request failed ！");
                    }
                });
            }
        }

        @Override
        public void onResponse(Call call, Response response) throws IOException {
            final String resultStr = response.body().string();
            VLog.d(TAG, "docInfo:" + resultStr);
            try {
                JSONObject data = new JSONObject(resultStr);
                final int code = data.optInt("code");
                final String msg = data.optString("msg");
                if (code != 200 && listener != null) {
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            listener.onError(ERROR_SEND, code, msg);
                        }
                    });
                } else {
                    if (mActionType.equals(TYPE_SWITCHON)) {
                        if (null != listener) {
                            listener.onEvent(KEY_OPERATE, TYPE_SWITCHON, null);
                        }
                    } else if (mActionType.equals(TYPE_SWITCHOFF)) {
                        if (null != listener) {
                            listener.onEvent(KEY_OPERATE, TYPE_SWITCHOFF, null);
                        }
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 文档服务连接状态监听
     *
     * @param listener
     */
    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        mOnConnectChangedListener = listener;
    }

    public boolean join() {
        return VhallSDK.getInstance().join(this);
    }

    public boolean leave() {
        return VhallSDK.getInstance().leave(this);
    }


    @Override
    public String getChannelId() {
        return mChannelId;
    }

    @Override
    public String getAccessToken() {
        return mAccessToken;
    }

    @Override
    public void onMessage(final String msg) {
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                try {
                    JSONObject result = new JSONObject(msg);
                    String service_type = result.optString("service_type");
                    if (TextUtils.isEmpty(service_type) || !service_type.equals(TYPE_DOCUMENT))
                        return;
                    final JSONObject data = new JSONObject(result.optString("data"));
                    final int flipOver = data.optInt("flipOver");
                    String userid = result.optString("sender_id");
                    String cid = data.optString("cid");//webView编号
                    if (flipOver == 1) {
                        if (viewMap.containsKey(cid)) {
                            final DocumentView mView = viewMap.get(cid);
                            mView.doodle(data.toString());//文档操作
                            JSONArray pageData = data.optJSONArray("pageData");
                            if(pageData !=null){
                                mView.setAllPageData(pageData.toString());
                            }
                        }
                    } else if (!editAble || !userid.equals(VhallSDK.getInstance().mUserId)) {
                        //非翻页信息，发起端不回显
                        JSONArray commandArray = data.optJSONArray("command");
                        for (int i = 0; i < commandArray.length(); i++) {
                            //新版数组仅包含一项，为保持严谨使用循环判断
                            JSONObject obj = commandArray.optJSONObject(i);
                            String event = obj.optString("event");
                            String type = obj.optString("type");
                            int is_board = obj.optInt("is_board");
                            if (event.equals(KEY_OPERATE)) {
                                if (type.equals(TYPE_DESTROY)) {
                                    if (viewMap.containsKey(cid)) {
                                        destroy(cid);
                                        if (listener != null) {
                                            listener.onEvent(event, type, cid);
                                        }
                                    }
                                } else if (type.equals(TYPE_ACTIVE)) {
                                    if (viewMap.containsKey(cid)) {
                                        activeCid = cid;
                                        if (listener != null) {
                                            listener.onEvent(event, type, cid);
                                        }
                                    } else {
                                        if (is_board == 2) {
                                            createBoard(cid, data, true);
                                        } else {
                                            createDocument(cid, data, true);
                                        }
                                    }
                                } else if (type.equals(TYPE_CREATE)) {
                                    if (!viewMap.containsKey(cid)) {
                                        if (is_board == 1) {
                                            createDocument(cid, data, false);
                                        } else {
                                            createBoard(cid, data, false);
                                        }
                                    }
                                } else {
                                    if (listener != null) {
                                        listener.onEvent(event, type, cid);
                                    }
                                }
                            } else if (event.equals(KEY_READY)) {
                                if (!viewMap.containsKey(cid)) {
                                    if (is_board == 1) {
                                        createDocument(cid, data, true);
                                    }
                                }
                            }
                        }
                        if (viewMap.containsKey(cid)) {
                            final DocumentView mView = viewMap.get(cid);
                            mView.doodle(data.toString());//文档操作
                        }
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, dealTime);
    }

    @Override
    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (mOnConnectChangedListener != null)
            mOnConnectChangedListener.onStateChanged(state, serverType);
    }

    public static final String DOC_K = "262001";

    private void uploadLogInfo(String docId, JSONObject data) {
        if (data != null) {
            try {
                JSONObject object = new JSONObject();
                object.put("uid", LogInfo.getInstance().getUid());
                object.put("doc_id", docId);
                object.put("app_id", VhallSDK.getInstance().getAPP_ID());
                object.put("vfid", LogInfo.getInstance().getAccount_id());
                object.put("service_names", LogInfo.getInstance().vtype);
                object.put("view_type", 2);//(1代表主持端，2代表观看端)
                object.put("pf", LogInfo.PLANTFORM_SDK);
                object.put("bu", LogInfo.UNIT_PAAS);//（paas=1， saas=0, edu=2）
                object.put("page_number", data.optInt("slideIndex"));
                object.put("share_times", 1);
                String objStr = object.toString();
                String token = Base64.encodeToString(objStr.getBytes(), Base64.NO_WRAP).toString();
                String id = String.valueOf(System.currentTimeMillis());
                VHOPSApi.uploadLog(DOC_K, id, LogInfo.getInstance().getSession_id(), LogInfo.UNIT_PAAS, token);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String getInitOpts(JSONObject obj) {
        JSONObject data = new JSONObject();
        JSONObject control = new JSONObject();
        JSONObject advance = new JSONObject();
        JSONObject basic = new JSONObject();
        String backColor = null;
        double cw = 0, ch = 0;
        if (obj != null) {
            backColor = obj.optString("backgroundColor");
            if (TextUtils.isEmpty(backColor)) {
                JSONArray commandArr = obj.optJSONArray("command");
                if (commandArr != null) {
                    JSONObject commandData = commandArr.optJSONObject(0).optJSONObject("data");
                    backColor = commandData.optString("backgroundColor");
                }
            }
            cw = obj.optDouble("cw");
            ch = obj.optDouble("ch");
        } else {
            backColor = createColor;
            cw = createWith;
            ch = createHeight;
        }
        try {
            data.put("control", control);
            advance.put("multiTouch", 1);
            data.put("advance", advance);
            basic.put("urlBase", VhallSDK.getInstance().mDocHost + "/");
            if (TextUtils.isEmpty(backColor)) {
                basic.put("backgroundColor", "#ffffff");
            } else {
                basic.put("backgroundColor", backColor);
            }
            basic.put("width", cw);
            basic.put("height", ch);
            data.put("basic", basic);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        VLog.d(TAG, "initOpts:" + data.toString());
        return data.toString();
    }

    /**
     * 文档上传
     *
     * @param filePath    文件路径
     * @param rename      重命名
     * @param accessToken
     * @param callback
     */
    public static void upload(String filePath, String rename, String accessToken, final DocUploadCallback callback) {
        final Handler mHandler = new Handler(Looper.getMainLooper());
        File file = new File(filePath);
        if (!VhallSDK.getInstance().documentExt.contains(getExtensionName(file.getName()))) {
            //文件格式不支持
            if (callback != null) {
                callback.onFailure(ERROR_TYPE, "document type error");
            }
            return;
        }
        if (file.length() > VhallSDK.getInstance().documentMaxSize) {
            //文件过大
            int max = VhallSDK.getInstance().documentMaxSize / 1024 / 1024;
            callback.onFailure(ERROR_OUT_LIMIT, "The maximum file size is  " + max + "M");
            return;
        }
        VHAPI.ProgressRequestBody.ProgressListener myListener = null;
        if (callback != null) {
            myListener = new VHAPI.ProgressRequestBody.ProgressListener() {
                @Override
                public void onProgress(long totalBytes, long remainingBytes, boolean done) {
                    callback.onProgress(totalBytes, remainingBytes, done);
                }
            };
        }
        if (!TextUtils.isEmpty(rename)) {
            rename = rename + "." + getExtensionName(file.getName());
        }
        VHOPSApi.upload(filePath, rename, accessToken, myListener, new Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        callback.onFailure(-1, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                final String res = response.body().string();
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            try {
                                JSONObject obj = new JSONObject(res);
                                int code = obj.optInt("code");
                                String msg = obj.optString("msg");
                                if (code == 200) {
                                    JSONObject data = obj.optJSONObject("data");
                                    String documentId = data.optString("document_id");
                                    if (callback != null) {
                                        callback.onSuccess(documentId);
                                    }
                                } else {
                                    if (callback != null) {
                                        callback.onFailure(code, msg);
                                    }
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                                if (callback != null) {
                                    callback.onFailure(-2, "Error json");
                                }
                            }
                        } else {
                            if (callback != null) {
                                callback.onFailure(response.code(), response.message());
                            }
                        }
                    }
                });
            }
        });
    }

    /**
     * 获取上传文件限制说明
     *
     * @return
     */
    public static String getUploadConfig() {
        String s = VhallSDK.getInstance().documentExt;
        int max = VhallSDK.getInstance().documentMaxSize;
        JSONObject object = new JSONObject();
        try {
            object.put("ext", s);
            object.put("maxSize", max);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    public static String getExtensionName(String fileName) {
        if (fileName != null && fileName.length() > 0) {
            int dot = fileName.lastIndexOf(".");
            if (dot > -1 && dot < fileName.length() - 1) {
                return fileName.substring(dot + 1);
            }
        }
        return "";
    }

    private String createCid(String type) {
        UUID uuid = UUID.randomUUID();
        String cid = uuid.toString().substring(0, 8);
        return type + "-" + cid;
    }

    public void sendSpecial() {
        VHOPSApi.sendSpecial(mRoomId, mChannelId, mAccessToken, new SendMsgCallback());
    }

    /*--------------------------------------回放文档-------------------------------------------------*/

    private boolean isVod = false;

    public void setCue_point(String cue_point) {
        getFile(cue_point);
        isVod = true;
    }

    private void getFile(String url) {
        if (TextUtils.isEmpty(url))
            return;
        if (context == null)
            return;
        dataMap.clear();
        dataMap.put(TYPE_SWITCH, new ArrayList<DocInfo>());
        dataMap.put(TYPE_CREATE, new ArrayList<DocInfo>());
        dataMap.put(TYPE_ACTIVE, new ArrayList<DocInfo>());
        dataMap.put(TYPE_DESTROY, new ArrayList<DocInfo>());
        dataMap.put(KEY_READY, new ArrayList<DocInfo>());
        FileUtil.getCuePointFile(url, context, new FileUtil.FileCallback() {
            @Override
            public void onFile(File file) {
                parseFile(file);
            }
        });
    }

    /**
     * 字符串的解压
     *
     * @param str
     *            对字符串解压
     * @return    返回解压缩后的字符串
     * @throws IOException
     */
    public static String unCompress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return str;
        }
        // 创建一个新的 byte 数组输出流
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        // 创建一个 ByteArrayInputStream，使用 buf 作为其缓冲区数组
        ByteArrayInputStream in = new ByteArrayInputStream(str
                .getBytes("ISO-8859-1"));
        // 使用默认缓冲区大小创建新的输入流
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        int n = 0;
        while ((n = gzip.read(buffer)) >= 0) {// 将未压缩数据读入字节数组
            // 将指定 byte 数组中从偏移量 off 开始的 len 个字节写入此 byte数组输出流
            out.write(buffer, 0, n);
        }
        // 使用指定的 charsetName，通过解码字节将缓冲区内容转换为字符串
        return out.toString("GBK");
    }

    private synchronized void parseFile(File file) {
        if (file == null || file.length() <= 0) {
            return;
        }
        dataStr = FileUtil.readFile2String(file);
        if(file.getName().contains(".zip")){
            try {
                dataStr = unCompress(dataStr);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (TextUtils.isEmpty(dataStr)) {
            return;
        }
        if (dataStr.startsWith("\ufeff")) {
            dataStr = dataStr.substring(1);
        }
        VLog.d(TAG, dataStr);
        try {
            JSONObject obj = new JSONObject(dataStr);
            JSONArray cuepoint = obj.optJSONArray("cuepoint");
            if (cuepoint != null && obj.length() > 0) {
                for (int i = 0; i < cuepoint.length(); i++) {
                    JSONObject cue = cuepoint.optJSONObject(i);
                    if (cue != null) {
                        double createTime = cue.optDouble("created_at") * 1000;
                        DocInfo info;
                        /*if (i == 0) {//0-firstCommandTime 之间添加一条关闭，与打开指令，保证回放文档在未操作时间点无视图
                            info = new DocInfo();
                            info.create = 200;
                            info.key = TYPE_SWITCH;
                            info.innerKey = TYPE_SWITCHOFF;
                            dataMap.get(TYPE_SWITCH).add(info);
                            info = new DocInfo();
                            info.create = createTime - 150;
                            info.key = TYPE_SWITCH;
                            info.innerKey = TYPE_SWITCHON;
                            dataMap.get(TYPE_SWITCH).add(info);
                        }*/
                        String content = cue.optString("content2");
                        String key = "";
                        String innerKey = "";
                        if (content.indexOf(TYPE_CREATE) >= 0) {
                            key = TYPE_CREATE;
                        } else if (content.indexOf(TYPE_ACTIVE) >= 0) {
                            key = TYPE_ACTIVE;
                        } else if (content.indexOf(TYPE_DESTROY) >= 0) {
                            key = TYPE_DESTROY;
                        } else if (content.indexOf(TYPE_SWITCHOFF) >= 0) {
                            key = TYPE_SWITCH;
                            innerKey = TYPE_SWITCHOFF;
                        } else if (content.indexOf(TYPE_SWITCHON) >= 0) {
                            key = TYPE_SWITCH;
                            innerKey = TYPE_SWITCHON;
                        } else if (content.indexOf(KEY_READY) >= 0) {
                            key = KEY_READY;
                        }
                        if (!"".equals(key)) {
                            info = new DocInfo();
                            JSONObject point = new JSONObject(content);
                            info.key = key;
                            info.innerKey = innerKey;
                            info.create = createTime;
                            info.cid = point.optString("cid");
                            info.docId = point.optString("docId");
                            info.data = point;
                            if (point.has("command")) {
                                JSONArray commandArray = point.optJSONArray("command");
                                JSONObject command = commandArray.optJSONObject(0);
                                info.isBoard = command.optInt("is_board");
                                if (command.has("data")) {
                                    JSONObject data = command.optJSONObject("data");
                                    info.backgroundColor = data.optString("backgroundColor");
                                }
                            }
                            dataMap.get(key).add(info);
                        }
                        /*else {
                            if (i == 0) {
                                info = new DocInfo();
                                JSONObject point = new JSONObject(content);
                                info.key = TYPE_ACTIVE;
                                if (createTime > 200) {
                                    createTime = 200;
                                } else {
                                    createTime = 0;
                                }
                                info.create = createTime;
                                info.cid = point.optString("cid");
                                info.docId = point.optString("docId");
                                info.data = point;
                                if (point.has("command")) {
                                    JSONArray commandArray = point.optJSONArray("command");
                                    JSONObject command = commandArray.optJSONObject(0);
                                    info.isBoard = command.optInt("is_board");
                                    if (command.has("data")) {
                                        JSONObject data = command.optJSONObject("data");
                                        info.backgroundColor = data.optString("backgroundColor");
                                    }
                                }
                                dataMap.get(TYPE_ACTIVE).add(info);
                            }
                        }*/
                    }
                }
            }
            dataStr = dataStr.replace("\\\"", "\\\\\\\"");
            isVodDocInited  = true;
            if (listener != null) {
                listener.onEvent(KEY_OPERATE, TYPE_VODDocInited, null );
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setTime(long time) {
        seekto(time);
        if(isVodDocInited)
            curPosition = time;
    }

    public void seekTo(long time) {
        curPosition = 0;
        seekto(time);
    }

    private void seekto(long time) {
        if(!isVodDocInited)
            return;
        Iterator iterator = dataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<DocInfo>> entry = (Map.Entry) iterator.next();
            List<DocInfo> list = entry.getValue();
            List<DocInfo> dataList = new ArrayList<>();
            String opType = entry.getKey();
            for (int i = 0; i < list.size(); i++) {
                DocInfo info = list.get(i);
                if (info.create >= curPosition && info.create < time) {
                    dataList.add(info);
                } else if (info.create > time) {
                    break;
                }
            }

            // seek到开始还未显示文档的时候回调 TYPE_SWITCHOFF
            if (dataList.size() == 0 && opType.equals(TYPE_SWITCH)) {
                if (list.size() > 0 && list.get(0).create > time) {
                    if (switchType.equals(TYPE_SWITCHON)) {
                        switchType = TYPE_SWITCHOFF;
                        if (listener != null)
                            listener.onEvent(KEY_OPERATE, TYPE_SWITCHOFF, null);
                    }
                }
            }

            if (listener != null && dataList.size() > 0) {
                if (opType.equals(TYPE_CREATE)) {
                    for (DocInfo info : dataList) {
                        if (!viewMap.containsKey(info.cid)) {
                            if (info.isBoard == 1) {
                                createDocument(info.cid, info.data, false);
                            } else {
                                createBoard(info.cid, info.data, false);
                            }
                        }
                    }
                } else if (opType.equals(TYPE_DESTROY)) {
                    for (DocInfo info : dataList) {
                        if (viewMap.containsKey(info.cid)) {
                            destroy(info.cid);
                            listener.onEvent(KEY_OPERATE, opType, info.cid);
                        }
                    }
                } else if (opType.equals(TYPE_ACTIVE)) {
                    DocInfo info = dataList.get(dataList.size() - 1);
                    if (activeCid != info.cid) {
                        activeCid = info.cid;
                        if (viewMap.containsKey(info.cid)) {
                            listener.onEvent(KEY_OPERATE, opType, info.cid);
                        } else {
                            if (info.isBoard == 1) {
                                createDocument(info.cid, info.data, true);
                            } else {
                                createBoard(info.cid, info.data, true);
                            }
                        }
                    }
                } else if (opType.equals(TYPE_SWITCH)) {
                    DocInfo docInfo = dataList.get(dataList.size() - 1);
                    if (!switchType.equals(docInfo.innerKey)) {
                        switchType = docInfo.innerKey;
                        listener.onEvent(KEY_OPERATE, docInfo.innerKey, docInfo.cid);
                    }
                }
            }
        }
        curPosition = time;
        Iterator iteratorMap = viewMap.entrySet().iterator();
        while (iteratorMap.hasNext()) {
            Map.Entry<String, DocumentView> entry = (Map.Entry) iteratorMap.next();
            entry.getValue().vodTime(time / 1000.0);
        }
    }

    class DocInfo {
        double create;
        String cid;
        String key;
        int isBoard;
        String docId;
        JSONObject data;
        String backgroundColor;
        String innerKey;
    }

    private void trackCreateEvent(String documentId){
        JSONObject params = new JSONObject();
        try {
            params.put("documentId", documentId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_CREATE, params);
    }

    private void trackInitEvent(){
        JSONObject params = new JSONObject();
        try {
            if (!TextUtils.isEmpty(mRoomId)) {
                params.put("roomId", mRoomId);
            }
            if (!TextUtils.isEmpty(mRecordId)) {
                params.put("recordId", mRecordId);
            }
            params.put("channelId",mChannelId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITOPS, params);
    }
}