/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioRecord;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.vhall.vhallrtc.client.Client;
import com.vhall.vhallrtc.client.FinishCallback;
import com.vhall.vhallrtc.client.SignalingChannel;
import com.vhall.vhallrtc.client.SignalingEvent;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.common.Tool;
import com.vhall.vhallrtc.logreport.LogReport;
import com.vhall.vhallrtc.message.RespMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vhwebrtc.DefaultVideoDecoderFactory;
import org.vhwebrtc.DefaultVideoEncoderFactory;
import org.vhwebrtc.EglBase;
import org.vhwebrtc.Logging;
import org.vhwebrtc.MediaStream;
import org.vhwebrtc.PeerConnection;
import org.vhwebrtc.PeerConnectionFactory;
import org.vhwebrtc.SoftwareVideoEncoderFactory;
import org.vhwebrtc.VideoCodecStatus;
import org.vhwebrtc.VideoDecoder;
import org.vhwebrtc.VideoDecoderFactory;
import org.vhwebrtc.VideoEncoder;
import org.vhwebrtc.VideoEncoderFactory;
import org.vhwebrtc.audio.AudioDeviceModule;
import org.vhwebrtc.audio.JavaAudioDeviceModule;
import org.vhwebrtc.vhvoiceengine.WebRtcAudioUtils;

public class Room {
    private static final String mTag = "Room";
    private static final String BROADCAST_DEFINITIONS = "[{\"resolution\":[640,480],\"framerate\":25,\"bitrate\":700},{\"resolution\":[848,480],\"framerate\":25,\"bitrate\":750},{\"resolution\":[720,540],\"framerate\":25,\"bitrate\":950},{\"resolution\":[960,540],\"framerate\":25,\"bitrate\":1150},{\"resolution\":[960,720],\"framerate\":25,\"bitrate\":1400},{\"resolution\":[1280,720],\"framerate\":25,\"bitrate\":1600},{\"resolution\":[1280,960],\"framerate\":25,\"bitrate\":1600},{\"resolution\":[1712,960],\"framerate\":25,\"bitrate\":1900},{\"resolution\":[1440,1080],\"framerate\":25,\"bitrate\":1800},{\"resolution\":[1920,1080],\"framerate\":25,\"bitrate\":2200},{\"resolution\":[480,848],\"framerate\":25,\"bitrate\":750},{\"resolution\":[540,960],\"framerate\":25,\"bitrate\":1150},{\"resolution\":[720,1280],\"framerate\":25,\"bitrate\":1600},{\"resolution\":[1080,1920],\"framerate\":25,\"bitrate\":2200}]";
    public static final int BROADCAST_VIDEO_PROFILE_480P_0 = 0;
    public static final int BROADCAST_VIDEO_PROFILE_480P_1 = 1;
    public static final int BROADCAST_VIDEO_PROFILE_540P_0 = 2;
    public static final int BROADCAST_VIDEO_PROFILE_540P_1 = 3;
    public static final int BROADCAST_VIDEO_PROFILE_720P_0 = 4;
    public static final int BROADCAST_VIDEO_PROFILE_720P_1 = 5;
    public static final int BROADCAST_VIDEO_PROFILE_960P_0 = 6;
    public static final int BROADCAST_VIDEO_PROFILE_960P_1 = 7;
    public static final int BROADCAST_VIDEO_PROFILE_1080P_0 = 8;
    public static final int BROADCAST_VIDEO_PROFILE_1080P_1 = 9;
    public static final int BROADCAST_VIDEO_PROFILE_480P_1_VERTICAL = 10;
    public static final int BROADCAST_VIDEO_PROFILE_540P_1_VERTICAL = 11;
    public static final int BROADCAST_VIDEO_PROFILE_720P_1_VERTICAL = 12;
    public static final int BROADCAST_VIDEO_PROFILE_1080P_1_VERTICAL = 13;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_1 = 0;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_2_H = 1;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_3_E = 2;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_3_D = 3;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_4_M = 4;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_5_D = 5;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_6_E = 6;
    public static final int CANVAS_LAYOUT_PATTERN_GRID_9_E = 7;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_2_1DR = 8;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_2_1DL = 9;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_3_2DL = 10;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_6_5D = 11;
    public static final int CANVAS_LAYOUT_PATTERN_FLOAT_6_5T = 12;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1T4D = 13;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1D4T = 14;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1L4R = 15;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1R4L = 16;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_6_1T5D = 17;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_6_1D5T = 18;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1L8R = 19;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1R8L = 20;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_13_1L12R = 21;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_17_1TL16GRID = 22;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1D8T = 23;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_13_1TL12GRID = 24;
    public static final int CANVAS_LAYOUT_PATTERN_TILED_17_1TL16GRID_E = 25;
    public static final int CANVAS_LAYOUT_PATTERN_CUSTOM = 27;
    public static final int CANVAS_LAYOUT_EX_PATTERN_GRID_12_E = 28;
    public static final int CANVAS_LAYOUT_EX_PATTERN_GRID_16_E = 29;
    public static final int CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TR = 30;
    public static final int CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TL = 31;
    public static final int CANVAS_ADAPTIVE_LAYOUT_UNDEFINED = 0;
    public static final int CANVAS_ADAPTIVE_LAYOUT_GRID_MODE = 1;
    public static final int CANVAS_ADAPTIVE_LAYOUT_TILED_MODE = 2;
    public static final int CANVAS_ADAPTIVE_LAYOUT_FLOAT_MODE = 3;
    public static final int CANVAS_ADAPTIVE_LAYOUT_TILED_TOP_MAX16 = 4;
    public static final int CANVAS_ADAPTIVE_LAYOUT_MAX = 5;
    private SignalingChannel mSignalingChannel;
    private JSONObject mRoomMetadata = null;
    private HashMap<String, Stream> mStreamsByStreamId;
    private HashMap<String, Stream> mInternalStreamsByStreamId;
    public String roomId;
    public String clientId;
    public String userIp;
    public String userId;
    private int mReconnectTimes = 15;
    private int mReconnectTimesIndex = 0;
    private Client mPublishClient = null;
    private Stream mPublishStream = null;
    private RoomDelegate mRoomDeleagte = null;
    private VHRoomStatus mRoomStatus;
    private VHPublishProportion mPublishProportion = VHPublishProportion.PUBLIS_STREAM_ROW;
    private PeerConnectionFactory mFactory = null;
    private String mEncodedToken;
    private Client.VhallClientState mClientState;
    private int mDevicePlatform = 5;
    private String mAttributes;
    private static EglBase mEglbase = null;
    private IntentFilter mIntentFilter;
    private NetworkChangeReceiver mNetworkChangeReceiver;
    private Context mContext;
    ExecutorService mRoomThread = Executors.newSingleThreadExecutor();
    private boolean mCpuoveruseDetection;
    private SignalingChannel.SignalingChannelRoomDelegate mRoomDelegate = new SignalingChannel.SignalingChannelRoomDelegate(){

        @Override
        public void onDidReceiveStreamIdReadyToPublish(SignalingChannel channel, String streamId) {
            if (null == Room.this.mPublishStream) {
                LogManager.v(Room.mTag, "onDidReceiveStreamIdReadyToPublish > Room maybe disposed already");
                return;
            }
            ((Room)Room.this).mPublishStream.streamId = streamId;
            LogReport.instance().setLocalstreamid(streamId);
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendPublishSignalingSuccess, streamId, ((Room)Room.this).mPublishStream.streamOption.toString());
            try {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kInitLocalStreamParam, streamId, "start room connect", -1, new JSONObject(Room.this.mPublishStream.toString()));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (Room.this.mSignalingChannel != null) {
                Room.this.mSignalingChannel.getOverseas(streamId, ((Room)Room.this).mPublishStream.isLocal, new SignalingChannel.OverseasCallback(){

                    @Override
                    public void onFinish(boolean isOverseas) {
                        ((Room)Room.this).mPublishStream.isOverseas = isOverseas;
                    }
                });
            }
        }

        @Override
        public void onDidSubscribedReadyToSubscribe(SignalingChannel channel, final String streamId) {
            String msg = "";
            if (Room.this.mStreamsByStreamId.get(streamId) != null) {
                msg = ((Stream)((Room)Room.this).mStreamsByStreamId.get((Object)streamId)).mStreamDate;
            }
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendSubscribeSignalingSuccess, streamId, msg);
            if (Room.this.mSignalingChannel != null) {
                Room.this.mSignalingChannel.getOverseas(streamId, false, new SignalingChannel.OverseasCallback(){

                    @Override
                    public void onFinish(boolean isOverseas) {
                        Stream stream = (Stream)Room.this.mStreamsByStreamId.get(streamId);
                        if (stream != null) {
                            stream.isOverseas = isOverseas;
                        }
                    }
                });
            }
        }

        @Override
        public void onSignalingChannelDidError(SignalingChannel channel, String error) {
            if (Room.this.mReconnectTimesIndex >= Room.this.mReconnectTimes) {
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidError(Room.this, VHRoomErrorStatus.VHRoomErrorSignaling, error);
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSignalingConnectFailure, null, error);
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSignalingServerDisconnected, null, error);
                Room.this.setStatus(VHRoomStatus.VHRoomStatusError);
            } else {
                Room.this.mReconnectTimesIndex++;
                Room.this.inLeave();
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onReconnect(Room.this.mReconnectTimes, Room.this.mReconnectTimesIndex);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Room.this.connectWithEncodedToken(Room.this.mEncodedToken, Room.this.mAttributes);
            }
        }

        @Override
        public void onSignalingChannelDidConnectToRoom(SignalingChannel channel, JSONObject roomMeta) {
            JSONObject user;
            Room.this.setStatus(VHRoomStatus.VHRoomStatusConnected);
            Room.this.mRoomMetadata = roomMeta;
            Room.this.mReconnectTimesIndex = 0;
            Room.this.roomId = roomMeta.optString("id");
            Room.this.clientId = roomMeta.optString("clientId");
            Room.this.userIp = roomMeta.optString("userIp");
            if (roomMeta.has("user") && (user = roomMeta.optJSONObject("user")) != null && user.has("id")) {
                Room.this.userId = user.optString("id");
            }
            LogReport logReport = LogReport.instance();
            logReport.setLogRoominfo(Room.this.userId, Room.this.roomId, Room.this.clientId, Room.this.mDevicePlatform);
            JSONArray streams = roomMeta.optJSONArray("streams");
            for (int i = 0; i < streams.length(); ++i) {
                JSONObject streamData = streams.optJSONObject(i);
                String streamId = "" + Tool.objectToString(streamData.opt("id"));
                Stream stream = (Stream)Room.this.mStreamsByStreamId.get(streamId);
                if (stream == null) {
                    stream = new Stream(Tool.objectToString(streamData.opt("id")), streamData, Room.this.mSignalingChannel);
                }
                if (Room.this.mPublishStream != null && ((Room)Room.this).mPublishStream.streamId.equals(streamId)) {
                    Room.this.mSignalingChannel.unpublish(((Room)Room.this).mPublishStream.streamId, null);
                    continue;
                }
                Room.this.mStreamsByStreamId.put(streamId, stream);
            }
            JSONArray docStreams = roomMeta.optJSONArray("docStreams");
            for (int i = 0; i < docStreams.length(); ++i) {
                JSONObject streamData = docStreams.optJSONObject(i);
                String streamId = "" + Tool.objectToString(streamData.opt("id"));
                Stream stream = (Stream)Room.this.mInternalStreamsByStreamId.get(streamId);
                if (stream != null) continue;
                stream = new Stream(Tool.objectToString(streamData.opt("id")), streamData, Room.this.mSignalingChannel, 100);
                Room.this.mInternalStreamsByStreamId.put(streamId, stream);
            }
            JSONArray externalStreams = roomMeta.optJSONArray("externalStreams");
            for (int i = 0; i < externalStreams.length(); ++i) {
                JSONObject streamData = externalStreams.optJSONObject(i);
                String streamId = "" + Tool.objectToString(streamData.opt("id"));
                Stream stream = (Stream)Room.this.mInternalStreamsByStreamId.get(streamId);
                if (stream != null) continue;
                stream = new Stream(Tool.objectToString(streamData.opt("id")), streamData, Room.this.mSignalingChannel, 101);
                Room.this.mInternalStreamsByStreamId.put(streamId, stream);
            }
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSignalingConnectSuccess, null, "room connected successfully\uff01 roomMeta\uff1a" + Room.this.mRoomMetadata.toString());
            LogReport.instance().reportLogWithKey(LogReport.VhallLogReportKey.kReportVersionInfo);
            if (Room.this.mRoomDeleagte != null) {
                Room.this.mRoomDeleagte.onDidConnect(Room.this, Room.this.mRoomMetadata);
            }
        }

        @Override
        public SignalingChannel.VHSignalingChannelDelegate onClientDelegateRequiredForSignalingChannel(SignalingChannel channel) {
            if (Room.this.mPublishClient == null && Room.this.mPublishStream != null) {
                Room.this.mPublishClient = new Client(Room.this.mClientDelegate, Room.this.mFactory);
            }
            return Room.this.mPublishClient;
        }

        @Override
        public void onSignalingChannelDidDisconnectToRoom(SignalingChannel channel, JSONObject obj) {
            Room.this.mRoomStatus = VHRoomStatus.VHRoomStatusDisconnected;
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSignalingDisconnect, "", "websocket OnDisconnect");
        }

        @Override
        public void onDidStreamAdded(String streamId, SignalingEvent event) {
            if (Room.this.mPublishStream != null && ((Room)Room.this).mPublishStream.streamId.equals(streamId)) {
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidPublishStream(Room.this, Room.this.mPublishStream);
                }
            } else {
                Stream stream = (Stream)Room.this.mStreamsByStreamId.get("" + streamId);
                if (stream == null) {
                    stream = new Stream(streamId, event.message, Room.this.mSignalingChannel);
                    Room.this.mStreamsByStreamId.put("" + streamId, stream);
                }
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidAddStream(Room.this, stream);
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kNewStreamEnterRoom, streamId, event.message.toString());
            }
        }

        @Override
        public void onDidInternalStreamAdded(String streamId, SignalingEvent event) {
            Stream stream;
            if (Room.this.mInternalStreamsByStreamId.containsKey(streamId)) {
                stream = (Stream)Room.this.mInternalStreamsByStreamId.get(streamId);
            } else {
                stream = new Stream(streamId, event.message, Room.this.mSignalingChannel, event.streamType);
                Room.this.mInternalStreamsByStreamId.put(streamId, stream);
            }
            if (Room.this.mRoomDeleagte != null) {
                Room.this.mRoomDeleagte.onDidInternalStreamAdded(Room.this, stream);
            }
        }

        @Override
        public void onDidInternalStreamRemoved(String streamId, SignalingEvent event) {
            LogReport.instance().streamStop(streamId);
            if (Room.this.mInternalStreamsByStreamId.containsKey(streamId)) {
                Stream stream = (Stream)Room.this.mInternalStreamsByStreamId.get(streamId);
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidInternalStreamRemoved(Room.this, stream);
                    Room.this.mInternalStreamsByStreamId.remove(streamId);
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamLeaveRoom, streamId, stream.mStreamDate);
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteUserQuitRoom, streamId, stream.mStreamDate);
            }
        }

        @Override
        public void onDidInternalStreamFailed(String streamId, SignalingEvent event) {
            LogReport.instance().streamStop(streamId);
            if (Room.this.mInternalStreamsByStreamId.containsKey(streamId)) {
                Stream stream = (Stream)Room.this.mInternalStreamsByStreamId.get(streamId);
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidInternalStreamFailed(Room.this, stream, event.message);
                    Room.this.mInternalStreamsByStreamId.remove(streamId);
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamLeaveRoom, streamId, stream.mStreamDate);
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteUserQuitRoom, streamId, stream.mStreamDate);
            }
        }

        @Override
        public void onDidRemovedStreamId(String streamId) {
            LogReport.instance().streamStop(streamId);
            Stream stream = (Stream)Room.this.mStreamsByStreamId.get("" + streamId);
            String msg = "";
            if (stream != null) {
                msg = stream.mStreamDate;
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidRemoveStream(Room.this, stream);
                    Room.this.mStreamsByStreamId.remove(stream.streamId + "");
                }
            }
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamLeaveRoom, streamId, msg);
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteUserQuitRoom, streamId, msg);
        }

        @Override
        public void onDidUnsubscribeStream(String streamId) {
            Stream stream = (Stream)Room.this.mStreamsByStreamId.get("" + streamId);
            if (stream != null) {
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidUnSubscribeStream(Room.this, stream);
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnsubscribeSignalingSuccess, streamId, "Call unsubscribe api.");
            }
        }

        @Override
        public void onDidUnpublishStream(String streamId, String config) {
            if (Room.this.mPublishStream != null && ((Room)Room.this).mPublishStream.streamId.equals(streamId)) {
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidUnPublishStream(Room.this, Room.this.mPublishStream);
                }
                if (Room.this.mPublishClient != null) {
                    Room.this.mPublishClient.disconnect();
                }
                try {
                    JSONArray argsData = new JSONArray(config);
                    RespMsg respMsg = new RespMsg(argsData);
                    if (respMsg.getCode() == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnpublishSignalingSuccess, streamId, config);
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnpublishSignalingFail, streamId, config);
                        LogManager.e(Room.mTag, config);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    LogManager.e(Room.mTag, "unpublish error.");
                }
                Room.this.mPublishStream = null;
            }
        }

        @Override
        public void onUpdateMuteStream(String streamId, JSONObject config) {
            Stream stream;
            if (Room.this.mRoomDeleagte != null && (stream = (Stream)Room.this.mStreamsByStreamId.get(streamId + "")) != null) {
                if (config.has("muteStream")) {
                    try {
                        stream.remoteMuteStream = config.getJSONObject("muteStream");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                Room.this.mRoomDeleagte.onDidUpdateOfStream(stream, config);
            }
        }

        @Override
        public void onRemoteUserQuitRoom(JSONObject msg) {
        }

        @Override
        public void onStreamMixed(JSONObject msg) {
            if (Room.this.mRoomDeleagte != null) {
                Room.this.mRoomDeleagte.onStreamMixed(msg);
            }
        }
    };
    private Client.ClientDelegate mClientDelegate = new Client.ClientDelegate(){

        @Override
        public void onDidCreatePeerConnection(Client client, PeerConnection peerConnection, String streamId) {
            if (Room.this.mPublishStream != null && ((Room)Room.this).mPublishStream.streamId != null && ((Room)Room.this).mPublishStream.streamId.equals(streamId)) {
                ((Room)Room.this).mPublishStream.client = client;
                LogReport.instance().streamStart(new LogReport.LogReportDelegate(){

                    @Override
                    public void onAudioLevel(String streamId, int audiolevel) {
                    }
                }, Room.this.mPublishStream);
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kLocalStreamCreatePeerconnection, streamId, "CreatePeerConnection scuess!");
            } else {
                Stream stream = (Stream)Room.this.mStreamsByStreamId.get("" + streamId);
                String msg = "";
                if (stream != null) {
                    stream.client = client;
                    msg = stream.mStreamDate;
                    LogReport.instance().streamStart(new LogReport.LogReportDelegate(){

                        @Override
                        public void onAudioLevel(String streamId, int audiolevel) {
                        }
                    }, stream);
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamCreatePeerconntion, streamId, msg);
            }
        }

        @Override
        public void onDidChangeState(Client client, Client.VhallClientState state) {
            if (Room.this.mPublishClient == client) {
                if (Room.this.mClientState != state && state == Client.VhallClientState.VHClientStateDisconnected && Room.this.mRoomStatus != VHRoomStatus.VHRoomStatusDisconnected) {
                    LogReport.instance().streamError(client.streamId);
                    if (null != Room.this.mPublishStream) {
                        ((Room)Room.this).mPublishStream.client = null;
                        if (!((Room)Room.this).mPublishStream.isPublish) {
                            Room.this.mClientState = state;
                            return;
                        }
                    }
                    LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kLocalStreamPeerconnectionDisconnected, client.streamId);
                    Room.this.unpublish();
                    Room.this.publish(Room.this.mPublishStream);
                }
            } else if (Room.this.mClientState != state && state == Client.VhallClientState.VHClientStateDisconnected && Room.this.mRoomStatus != VHRoomStatus.VHRoomStatusDisconnected) {
                LogReport.instance().streamError(client.streamId);
                Stream stream = (Stream)Room.this.mStreamsByStreamId.get("" + client.streamId);
                if (null == stream || !stream.isSubscribe) {
                    Room.this.mClientState = state;
                    return;
                }
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamPeerconnectionDisconnected, client.streamId);
                String error = "resubscribe stream " + client.streamId;
                LogManager.w(Room.mTag, error);
                Room.this.unsubscribe(stream);
                Room.this.subscribe(stream);
            }
            Room.this.mClientState = state;
        }

        @Override
        public void onDidChangeConnectionState(Client client, PeerConnection.IceConnectionState state) {
            LogManager.d(Room.mTag, "onDidChangeConnectionState");
            switch (state) {
                case FAILED: {
                    LogReport.instance().streamError(client.streamId);
                    break;
                }
            }
        }

        @Override
        public void onDidError(Client client, String error) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSignalingConnectFailure, client.streamId, error);
            if (Room.this.mRoomDeleagte != null) {
                Room.this.mRoomDeleagte.onDidError(Room.this, VHRoomErrorStatus.VHRoomErrorClient, error);
            }
        }

        @Override
        public void onDidReceiveRemoteStream(Client client, MediaStream mediaStream, String streamId) {
            if (Room.this.mPublishStream == null || !((Room)Room.this).mPublishStream.streamId.equals(streamId)) {
                Stream stream = (Stream)Room.this.mStreamsByStreamId.get("" + streamId);
                if (stream != null) {
                    stream.mediaStream = mediaStream;
                    stream.signalingChannel = Room.this.mSignalingChannel;
                }
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidSubscribeStream(Room.this, stream);
                }
            }
        }

        @Override
        public MediaStream streamToPublishByAppClient(Client client) {
            if (Room.this.mPublishStream != null) {
                return ((Room)Room.this).mPublishStream.mediaStream;
            }
            return null;
        }

        @Override
        public JSONArray onAppClientRequestICEServers(Client client) {
            if (Room.this.mRoomMetadata != null) {
                return Room.this.mRoomMetadata.optJSONArray("iceServers");
            }
            return null;
        }

        @Override
        public void onSendOffer(Client client, String streamId, String sdp) {
            if (Room.this.mPublishClient == client) {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kLocalStreamSendOffer, streamId, sdp);
            } else {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamSendOffer, streamId, sdp);
            }
        }

        @Override
        public void onRecvAnswer(Client client, String streamId, String sdp) {
            if (Room.this.mPublishClient == client) {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kLocalStreamRecvAndHandleAnswer, streamId, sdp);
            } else {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamRecvAndHandleAnswer, streamId, sdp);
            }
        }

        @Override
        public void onSendCandidate(Client client, String streamId, String msg) {
            if (Room.this.mPublishClient == client) {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kLocalStreamSendCandidate, streamId, msg);
            } else {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamSendCandidate, streamId, msg);
            }
        }

        @Override
        public void recvReadySignaling(Client client, String streamId, String msg) {
            if (Room.this.mPublishClient == client) {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kLocalStreamRecvReadySignaling, streamId, msg);
            } else {
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRemoteStreamRecvReadySignaling, streamId, msg);
            }
        }
    };

    public static JSONObject getProfile(int definition) throws JSONException {
        JSONArray list = new JSONArray(BROADCAST_DEFINITIONS);
        return list.getJSONObject(definition);
    }

    public Room(@NonNull Context context, @Nullable JSONObject dataReport, boolean softEchoCanceler, EglBase eglbase, boolean simulcast, boolean cpuoverusedetection) {
        this.mContext = context;
        if (dataReport != null) {
            LogReport logReport = LogReport.instance();
            logReport.setLogDataInfo(dataReport);
            if (dataReport.has("pf")) {
                this.mDevicePlatform = dataReport.optInt("pf");
            }
        }
        this.mSignalingChannel = new SignalingChannel();
        this.mSignalingChannel.init(0);
        this.mSignalingChannel.setChannelDeleagte(this.mRoomDelegate);
        this.mCpuoveruseDetection = cpuoverusedetection;
        JavaAudioDeviceModule mAudioDeviceModule = JavaAudioDeviceModule.builder((Context)context).setAudioSource(7).setAudioRecordErrorCallback(new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(String s) {
                LogManager.e(Room.mTag, "onWebRtcAudioRecordInitError msg:" + s);
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidError(Room.this, VHRoomErrorStatus.VHRoomErrorMic, s);
                }
            }

            public void onWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode audioRecordStartErrorCode, String s) {
                LogManager.e(Room.mTag, "onWebRtcAudioRecordStartError msg:" + s);
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidError(Room.this, VHRoomErrorStatus.VHRoomErrorMic, s);
                }
            }

            public void onWebRtcAudioRecordError(String s) {
                LogManager.e(Room.mTag, "onWebRtcAudioRecordError msg:" + s);
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidError(Room.this, VHRoomErrorStatus.VHRoomErrorMic, s);
                }
            }
        }).createAudioDeviceModule();
        if (softEchoCanceler) {
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)softEchoCanceler);
        }
        boolean enableH264HighProfile = true;
        Object encoderFactory = simulcast ? new SoftwareVideoEncoderFactory() : new DefaultVideoEncoderFactory(null, true, true, new VideoEncoder.VideoEncoderEventCallback(){

            public void onVideoEncoderError(VideoCodecStatus videoCodecStatus, String s) {
                LogManager.e(Room.mTag, "onVideoEncoderError msg:" + s);
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidError(Room.this, VHRoomErrorStatus.VHRoomErrorHWEncoder, s);
                }
            }

            public void onVideoEncoderEvent(VideoCodecStatus videoCodecStatus, String s) {
                LogManager.d(Room.mTag, "onVideoEncoderEvent msg:" + s);
            }
        });
        DefaultVideoDecoderFactory decoderFactory = new DefaultVideoDecoderFactory(null, new VideoDecoder.VideoDecoderEventCallback(){

            public void onVideoDecoderError(VideoCodecStatus videoCodecStatus, String s) {
                LogManager.e(Room.mTag, "onVideoDecoderError msg:" + s);
                if (Room.this.mRoomDeleagte != null) {
                    Room.this.mRoomDeleagte.onDidError(Room.this, VHRoomErrorStatus.VHRoomErrorHWDecoder, s);
                }
            }

            public void onVideoDecoderEvent(VideoCodecStatus videoCodecStatus, String s) {
                LogManager.d(Room.mTag, "onVideoDecoderEvent msg:" + s);
            }
        });
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder((Context)context).createInitializationOptions());
        this.mFactory = PeerConnectionFactory.builder().setVideoEncoderFactory((VideoEncoderFactory)encoderFactory).setVideoDecoderFactory((VideoDecoderFactory)decoderFactory).setAudioDeviceModule((AudioDeviceModule)mAudioDeviceModule).createPeerConnectionFactory();
        if (LogManager.isDebug) {
            Logging.enableLogToDebugOutput((Logging.Severity)Logging.Severity.LS_VERBOSE);
        } else {
            Logging.enableLogToDebugOutput((Logging.Severity)Logging.Severity.LS_WARNING);
        }
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mNetworkChangeReceiver = new NetworkChangeReceiver();
        context.registerReceiver((BroadcastReceiver)this.mNetworkChangeReceiver, this.mIntentFilter);
    }

    public void setReportLogData(@NonNull JSONObject dataReport) {
        if (dataReport != null) {
            LogReport logReport = LogReport.instance();
            logReport.setLogDataInfo(dataReport);
            if (dataReport.has("pf")) {
                this.mDevicePlatform = dataReport.optInt("pf");
            }
        }
    }

    public void setRoomDeleagte(@NonNull RoomDelegate deleagte) {
        this.mRoomDeleagte = deleagte;
    }

    public void setPublishProportion(@NonNull VHPublishProportion proportion) {
        this.mPublishProportion = proportion;
    }

    public void setReconnectTimes(int times) {
        this.mReconnectTimes = times;
    }

    @Nullable
    public PeerConnectionFactory getPeerConnectionFactory() {
        return this.mFactory;
    }

    public boolean connectWithEncodedToken(@NonNull String encodeToken, @Nullable String attributes) {
        this.mStreamsByStreamId = new HashMap();
        this.mInternalStreamsByStreamId = new HashMap();
        this.mAttributes = attributes;
        this.mEncodedToken = encodeToken;
        if (this.mSignalingChannel != null) {
            JSONObject dic = null;
            try {
                String token = new String(Base64.decode((byte[])encodeToken.getBytes(), (int)0));
                dic = new JSONObject();
                JSONObject tokenDic = new JSONObject(token);
                dic.put("token", (Object)tokenDic);
                dic.put("pf", this.mDevicePlatform);
                dic.put("version", (Object)Tool.getSDKVersion());
                if (attributes != null) {
                    dic.put("attributes", (Object)attributes);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (dic != null) {
                this.mSignalingChannel.connect(dic.toString());
                return true;
            }
        }
        return false;
    }

    @NonNull
    public ArrayList<Stream> getRemoteStreams() {
        ArrayList<Stream> list = new ArrayList<Stream>();
        if (this.mStreamsByStreamId == null) {
            return list;
        }
        for (Map.Entry<String, Stream> entry : this.mStreamsByStreamId.entrySet()) {
            Stream stream = entry.getValue();
            if (stream.isLocal) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public Stream getRemoteStreamById(String streamId) {
        if (null != this.mPublishStream && streamId.equals(this.mPublishStream.streamId)) {
            return this.mPublishStream;
        }
        if (null != this.mStreamsByStreamId && this.mStreamsByStreamId.containsKey(streamId)) {
            return this.mStreamsByStreamId.get(streamId);
        }
        if (null != this.mInternalStreamsByStreamId && this.mInternalStreamsByStreamId.containsKey(streamId)) {
            return this.mInternalStreamsByStreamId.get(streamId);
        }
        return null;
    }

    public ArrayList<Stream> getRemoteInternalStreams() {
        ArrayList<Stream> list = new ArrayList<Stream>();
        if (null == this.mInternalStreamsByStreamId || this.mInternalStreamsByStreamId.isEmpty()) {
            return list;
        }
        for (Map.Entry<String, Stream> entry : this.mInternalStreamsByStreamId.entrySet()) {
            Stream stream = entry.getValue();
            if (stream.isLocal) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public boolean isVoicePermission() {
        try {
            AudioRecord record = new AudioRecord(1, 22050, 2, 2, AudioRecord.getMinBufferSize((int)22050, (int)2, (int)2));
            record.startRecording();
            int recordingState = record.getRecordingState();
            if (recordingState == 1) {
                return false;
            }
            record.release();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean publish(@NonNull Stream stream) {
        if (stream.getStreamType() != Stream.VhallStreamType.VhallStreamTypeScreen.getValue() && !this.isVoicePermission()) {
            if (this.mRoomDeleagte != null) {
                this.mRoomDeleagte.onDidError(this, VHRoomErrorStatus.VHRoomErrorMic, "no mic permissions\uff01");
            }
            return false;
        }
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallPublishMethod, stream.streamId, "call publish api");
        if (stream == null || stream.isPublish || this.mRoomMetadata == null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallPublishMethodFail, null, "stream==null||stream.isPublish||mRoomMetadata==null");
            return false;
        }
        this.mPublishClient = new Client(this.mClientDelegate, this.mFactory);
        this.mPublishStream = stream;
        this.mPublishClient.setMinBitrateKbps(stream.getMinBitrateKbps());
        this.mPublishClient.setCurrentBitrateKbps(stream.getCurrentBitrateKbps());
        this.mPublishClient.setMaxBitrateKbps(stream.getMaxBitrateKbps());
        this.mPublishClient.setSimulcastLayers(stream.getSimulcastLayers());
        this.mPublishClient.setCpuoveruseDetection(this.mCpuoveruseDetection);
        if (stream.isLocal) {
            this.mPublishStream.signalingChannel = this.mSignalingChannel;
            this.mPublishStream.isPublish = true;
            this.mPublishStream.setPublishProportion(this.mPublishProportion);
        }
        JSONObject option = null;
        try {
            JSONObject user;
            this.mPublishStream.userDic = user = this.mRoomMetadata.optJSONObject("user");
            if (user != null) {
                this.mPublishStream.userId = user.optString("id");
            }
            option = new JSONObject(stream.streamOption.toString());
            option.putOpt("attributes", (Object)stream.getAttributes());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (option != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendPublishSignaling, stream.streamId, option.toString());
            this.mSignalingChannel.publish(option, this.mPublishClient);
        }
        return true;
    }

    public void unpublish() {
        if (this.mPublishStream == null || !this.mPublishStream.isPublish) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallUnpublishMethodFail, "", "mPublishStream==null or mPublishStream is not Publish");
            return;
        }
        this.unpublish(this.mPublishStream);
    }

    private void unpublish(Stream stream) {
        if (null == this.mPublishStream) {
            LogManager.v(mTag, "unpublish > Room maybe disposed already");
            return;
        }
        try {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallUnpublishMethod, this.mPublishStream.streamId, stream.streamOption.toString());
            LogReport.instance().streamStop(this.mPublishStream.streamId);
            if (this.mSignalingChannel != null) {
                this.mSignalingChannel.unpublish(this.mPublishStream.streamId);
                LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnpublishSignaling, this.mPublishStream.streamId, stream.streamOption.toString());
            }
            if (this.mPublishStream != null) {
                this.mPublishStream.client = null;
                this.mPublishStream.isPublish = false;
            }
            if (this.mPublishClient != null) {
                this.mPublishClient.disconnect();
                this.mPublishClient = null;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public boolean subscribe(@NonNull Stream stream) {
        if (stream == null || stream.streamId == null || stream.isSubscribe) {
            LogManager.e(mTag, "Cannot subscribe to a stream without a streamId.");
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallSubscribeMethodFail, stream.streamId, stream.mStreamDate);
            return false;
        }
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallSubscribeMethod, stream.streamId, stream.mStreamDate);
        if (this.mRoomStatus.getValue() != VHRoomStatus.VHRoomStatusConnected.getValue()) {
            LogManager.e(mTag, "You can't subscribe to a stream before connect to the room.");
            return false;
        }
        stream.isSubscribe = true;
        if (!this.mStreamsByStreamId.containsKey("" + stream.streamId) && stream.getStreamType() < 100) {
            this.mStreamsByStreamId.put("" + stream.streamId, stream);
        }
        JSONObject option = null;
        try {
            stream.streamOption.put("muteStream", (Object)stream.muteStream);
            option = new JSONObject(stream.streamOption.toString());
            option.put("streamId", (Object)stream.streamId);
            option.put("slideShowMode", false);
            JSONObject metadata = new JSONObject();
            metadata.put("type", (Object)"subscriber");
            option.put("metadata", (Object)metadata);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LogManager.e(mTag, "subscribe json object put error.");
        }
        if (option == null) {
            LogManager.e(mTag, "option is not json object.");
            return false;
        }
        Client client = new Client(this.mClientDelegate, this.mFactory);
        this.mSignalingChannel.subscribe(stream.streamId, option, client);
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendSubscribeSignaling, stream.streamId, option.toString());
        return true;
    }

    public boolean unsubscribe(@NonNull Stream stream) {
        if (stream == null || stream.streamId == null || !stream.isSubscribe) {
            LogManager.e(mTag, "Cannot unsubscribe to a stream without a streamId.");
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallUnsubscribeMethodFail, stream.streamId, "Cannot subscribe to a stream without a streamId.");
            return false;
        }
        stream.removeAllRenderView();
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallUnsubscribeMethod, stream.streamId, stream.mStreamDate);
        LogReport.instance().streamStop(stream.streamId);
        this.mSignalingChannel.unsubscribe(stream.streamId);
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSendUnsubscribeSignaling, stream.streamId, stream.mStreamDate);
        stream.isSubscribe = false;
        return true;
    }

    public void leave() {
        this.mReconnectTimesIndex = this.mReconnectTimes;
        this.inLeave();
    }

    public void configRoomBroadCast(final @NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kConfigRoomBroadCast, null, "Call configRoomBroadCast api:" + config.toString());
            this.mSignalingChannel.configRoomBroadCast(config, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kConfigRoomBroadCastSuccess, null, "configRoomBroadCast success" + config.toString());
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kConfigRoomBroadCastFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void setMixAdpaptiveLayoutMode(int layoutMode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixAdaptiveLayoutModeBroadCast, null, "Call setMixLayoutMode api:2");
            this.mSignalingChannel.setMixAdpaptiveLayoutMode(layoutMode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixAdaptiveLayoutModeBroadCastSuccess, null, "setMixLayoutMode success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixAdaptiveLayoutModeBroadCastFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void setMixLayoutMode(int layoutMode, @Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutModeBroadCast, null, "Call setMixLayoutMode api:2");
            this.mSignalingChannel.setMixLayoutMode(layoutMode, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutModeBroadCastSuccess, null, "setMixLayoutMode success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutModeBroadCastFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void startRoomBroadCast(@Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStartRoomBroadCast, null, "Call startRoomBroadCast api");
            this.mSignalingChannel.startRoomBroadCast(mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStartRoomBroadCastSuccess, null, "startRoomBroadCast success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStartRoomBroadCastFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void stopRoomBroadCast(@Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCast, null, "Call stopRoomBroadCast api");
            this.mSignalingChannel.stopRoomBroadCast(mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastSuccess, null, "stopRoomBroadCast success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void setRoomBroadCastMixOption(final @NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastMixoption, null, "Call setRoomBroadCastMixOption api:" + config.toString());
            this.mSignalingChannel.setRoomBroadCastMixOption(config, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRoomBroadCastMixOptionSuccess, null, "setRoomBroadCastMixOption success" + config.toString());
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kRoomBroadCastMixOptionFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void setRoomBroadCastBackgroundImage(final @NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            this.mSignalingChannel.setRoomBroadCastBackgroundImage(config, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageSuccess, null, "setRoomBroadCastBackgroundImage success" + config.toString());
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void reSetRoomBroadCastBackgroundImage(final @NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            this.mSignalingChannel.reSetRoomBroadCastBackgroundImage(config, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageSuccess, null, "reSetRoomBroadCastBackgroundImage success" + config.toString());
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void setRoomBroadCastPlaceholderImage(final @NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            this.mSignalingChannel.setRoomBroadCastPlaceholderImage(config, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageSuccess, null, "setRoomBroadCastPlaceholderImage success" + config.toString());
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void reSetRoomBroadCastPlaceholderImage(final @NonNull JSONObject config, @Nullable String mode, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            this.mSignalingChannel.reSetRoomBroadCastPlaceholderImage(config, mode, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageSuccess, null, "reSetRoomBroadCastPlaceholderImage success" + config.toString());
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopRoomBroadCastBackgroundImageFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void startDocCloudRender(@NonNull JSONObject config, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStartDocCloudRender, null, "Call startDocCloudRender");
            this.mSignalingChannel.startDocCloudRender(config, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStartDocCloudResult, null, "startDocCloudRender success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStartDocCloudResult, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void stopDocCloudRender(@NonNull JSONObject config, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopDocCloudRender, null, "Call stopDocCloudRender");
            this.mSignalingChannel.stopDocCloudRender(config, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopDocCloudResult, null, "stopDocCloudRender success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kStopDocCloudResult, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void setMixLayoutMainScreen(@NonNull String streamId, final @Nullable FinishCallback finish) {
        if (this.mSignalingChannel != null) {
            LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutMainScreenBroadCast, streamId, "Call setMixLayoutMainScreen api mix");
            this.mSignalingChannel.setMixLayoutMainScreen(streamId, null, new FinishCallback(){

                @Override
                public void onFinish(int code, @Nullable String message) {
                    if (code == 200) {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutMainScreenBroadCastSuccess, null, " setMixLayoutMainScreen success");
                    } else {
                        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kMixLayoutMainScreenBroadCastFail, null, message, code);
                    }
                    if (finish != null) {
                        finish.onFinish(code, message);
                    }
                }
            });
        }
    }

    public void dispose() {
        if (this.mPublishStream != null) {
            this.mPublishStream.dispose();
            this.mPublishStream = null;
        }
        this.mFactory.dispose();
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mNetworkChangeReceiver);
    }

    private Room() {
    }

    private void inLeave() {
        if (this.mRoomStatus == VHRoomStatus.VHRoomStatusDisconnected) {
            return;
        }
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kSignalingDisconnect, null, "websocket OnDisconnect");
        LogReport.instance().streamAllStop();
        this.setStatus(VHRoomStatus.VHRoomStatusDisconnected);
        if (this.mStreamsByStreamId != null && !this.mStreamsByStreamId.isEmpty()) {
            for (Stream stream : this.mStreamsByStreamId.values()) {
                stream.stopStats();
                stream.isSubscribe = false;
            }
        }
        if (this.mInternalStreamsByStreamId != null && !this.mInternalStreamsByStreamId.isEmpty()) {
            for (Stream stream : this.mInternalStreamsByStreamId.values()) {
                stream.isSubscribe = false;
            }
        }
        if (this.mPublishStream != null) {
            this.mPublishStream.stopStats();
            this.unpublish();
        }
        if (this.mSignalingChannel != null) {
            this.mSignalingChannel.disconnect();
        }
        LogReport.instance().reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kCallSignalingDisconnectionMethod, "0");
    }

    private void setStatus(VHRoomStatus status) {
        this.mRoomStatus = status;
        if (this.mRoomDeleagte != null) {
            this.mRoomDeleagte.onDidChangeStatus(this, status);
        }
    }

    class NetworkChangeReceiver
    extends BroadcastReceiver {
        NetworkChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (null == connectivityManager) {
                LogManager.i(Room.mTag, "connectivityManager from Room is null");
                return;
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isAvailable()) {
                LogManager.i(Room.mTag, "the network is not available.");
                if (Room.this.mRoomStatus == VHRoomStatus.VHRoomStatusConnected) {
                    Room.this.mRoomThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            Room.this.inLeave();
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            Room.this.connectWithEncodedToken(Room.this.mEncodedToken, Room.this.mAttributes);
                        }
                    });
                }
            }
        }
    }

    public static interface RoomDelegate {
        public void onDidConnect(Room var1, JSONObject var2);

        public void onDidError(Room var1, VHRoomErrorStatus var2, String var3);

        public void onDidPublishStream(Room var1, Stream var2);

        public void onDidInternalStreamAdded(Room var1, Stream var2);

        public void onDidInternalStreamRemoved(Room var1, Stream var2);

        public void onDidInternalStreamFailed(Room var1, Stream var2, JSONObject var3);

        public void onDidUnPublishStream(Room var1, Stream var2);

        public void onDidSubscribeStream(Room var1, Stream var2);

        public void onDidUnSubscribeStream(Room var1, Stream var2);

        public void onDidChangeStatus(Room var1, VHRoomStatus var2);

        public void onDidAddStream(Room var1, Stream var2);

        public void onDidRemoveStream(Room var1, Stream var2);

        public void onDidUpdateOfStream(Stream var1, JSONObject var2);

        public void onReconnect(int var1, int var2);

        public void onStreamMixed(JSONObject var1);
    }

    public static enum VHRoomErrorStatus {
        VHRoomErrorUnknown(0),
        VHRoomErrorClient(1),
        VHRoomErrorClientFailedSDP(2),
        VHRoomErrorSignaling(3),
        VHRoomErrorMic(4),
        VHRoomErrorHWEncoder(5),
        VHRoomErrorHWDecoder(6);

        private int _value;

        private VHRoomErrorStatus(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VHRoomStatus {
        VHRoomStatusReady(0),
        VHRoomStatusConnected(1),
        VHRoomStatusDisconnected(2),
        VHRoomStatusError(3);

        private int _value;

        private VHRoomStatus(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VHPublishProportion {
        PUBLIS_STREAM_ROW(0),
        PUBLIS_STREAM_16_9(1),
        PUBLIS_STREAM_4_3(2);

        private int _value;

        private VHPublishProportion(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

