/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.jni;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;

public class HttpRequest {
    private static final String TAG = "HttpRequest";
    private static ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    public static void httpGetAsyncRequest(final String urlStr) {
        singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                HttpRequest.httpGetSyncRequest(urlStr);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpGetSyncRequest(String urlStr) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlStr);
            connection = urlStr.contains("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setRequestMethod("GET");
            if (200 == connection.getResponseCode()) {
                String line;
                InputStream in = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

