/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.logmanager;

import android.os.Environment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

class VHLogFileManager {
    VHLogFileManager() {
    }

    public static void writeToStorage(String path, String content) {
        VHLogFileManager.write(content, VHLogFileManager.getExternalPath(path));
    }

    private static String getExternalPath(String path) {
        String logPath = null == path || "".equals(path) ? "log" : path;
        return String.format("%s/%s/%s/%s", Environment.getExternalStorageDirectory(), "vhalltest", logPath, VHLogFileManager.getDate() + ".txt");
    }

    private static String getDate() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    private static String write(String content, String destPath) {
        String fileName = null;
        try {
            File destFile = new File(destPath);
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(destPath, true)));
            writer.newLine();
            writer.write(content);
            fileName = destFile.getName();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }
}

