/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.hls.offline;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.vhall.android.exoplayer2.Format;
import com.vhall.android.exoplayer2.offline.DownloadHelper;
import com.vhall.android.exoplayer2.offline.StreamKey;
import com.vhall.android.exoplayer2.offline.TrackKey;
import com.vhall.android.exoplayer2.source.TrackGroup;
import com.vhall.android.exoplayer2.source.TrackGroupArray;
import com.vhall.android.exoplayer2.source.hls.offline.HlsDownloadAction;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.vhall.android.exoplayer2.upstream.DataSource;
import com.vhall.android.exoplayer2.upstream.ParsingLoadable;
import com.vhall.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class HlsDownloadHelper
extends DownloadHelper {
    private final Uri uri;
    private final DataSource.Factory manifestDataSourceFactory;
    private @MonotonicNonNull HlsPlaylist playlist;
    private int[] renditionGroups;

    public HlsDownloadHelper(Uri uri, DataSource.Factory manifestDataSourceFactory) {
        this.uri = uri;
        this.manifestDataSourceFactory = manifestDataSourceFactory;
    }

    protected void prepareInternal() throws IOException {
        DataSource dataSource = this.manifestDataSourceFactory.createDataSource();
        this.playlist = (HlsPlaylist)ParsingLoadable.load((DataSource)dataSource, (ParsingLoadable.Parser)new HlsPlaylistParser(), (Uri)this.uri, (int)4);
    }

    public HlsPlaylist getPlaylist() {
        Assertions.checkNotNull((Object)this.playlist);
        return this.playlist;
    }

    public int getPeriodCount() {
        Assertions.checkNotNull((Object)this.playlist);
        return 1;
    }

    public TrackGroupArray getTrackGroups(int periodIndex) {
        Assertions.checkNotNull((Object)this.playlist);
        if (this.playlist instanceof HlsMediaPlaylist) {
            this.renditionGroups = new int[0];
            return TrackGroupArray.EMPTY;
        }
        HlsMasterPlaylist masterPlaylist = (HlsMasterPlaylist)this.playlist;
        TrackGroup[] trackGroups = new TrackGroup[3];
        this.renditionGroups = new int[3];
        int trackGroupIndex = 0;
        if (!masterPlaylist.variants.isEmpty()) {
            this.renditionGroups[trackGroupIndex] = 0;
            trackGroups[trackGroupIndex++] = new TrackGroup(HlsDownloadHelper.toFormats(masterPlaylist.variants));
        }
        if (!masterPlaylist.audios.isEmpty()) {
            this.renditionGroups[trackGroupIndex] = 1;
            trackGroups[trackGroupIndex++] = new TrackGroup(HlsDownloadHelper.toFormats(masterPlaylist.audios));
        }
        if (!masterPlaylist.subtitles.isEmpty()) {
            this.renditionGroups[trackGroupIndex] = 2;
            trackGroups[trackGroupIndex++] = new TrackGroup(HlsDownloadHelper.toFormats(masterPlaylist.subtitles));
        }
        return new TrackGroupArray(Arrays.copyOf(trackGroups, trackGroupIndex));
    }

    public HlsDownloadAction getDownloadAction(@Nullable byte[] data, List<TrackKey> trackKeys) {
        Assertions.checkNotNull((Object)this.renditionGroups);
        return HlsDownloadAction.createDownloadAction(this.uri, data, HlsDownloadHelper.toStreamKeys(trackKeys, this.renditionGroups));
    }

    public HlsDownloadAction getRemoveAction(@Nullable byte[] data) {
        return HlsDownloadAction.createRemoveAction(this.uri, data);
    }

    private static Format[] toFormats(List<HlsMasterPlaylist.HlsUrl> hlsUrls) {
        Format[] formats = new Format[hlsUrls.size()];
        for (int i = 0; i < hlsUrls.size(); ++i) {
            formats[i] = hlsUrls.get((int)i).format;
        }
        return formats;
    }

    private static List<StreamKey> toStreamKeys(List<TrackKey> trackKeys, int[] groups) {
        ArrayList<StreamKey> representationKeys = new ArrayList<StreamKey>(trackKeys.size());
        for (int i = 0; i < trackKeys.size(); ++i) {
            TrackKey trackKey = trackKeys.get(i);
            representationKeys.add(new StreamKey(groups[trackKey.groupIndex], trackKey.trackIndex));
        }
        return representationKeys;
    }
}

