/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.hls;

import android.util.Pair;
import com.vhall.android.exoplayer2.Format;
import com.vhall.android.exoplayer2.drm.DrmInitData;
import com.vhall.android.exoplayer2.extractor.DefaultExtractorInput;
import com.vhall.android.exoplayer2.extractor.Extractor;
import com.vhall.android.exoplayer2.extractor.ExtractorInput;
import com.vhall.android.exoplayer2.extractor.ExtractorOutput;
import com.vhall.android.exoplayer2.metadata.Metadata;
import com.vhall.android.exoplayer2.metadata.id3.Id3Decoder;
import com.vhall.android.exoplayer2.metadata.id3.PrivFrame;
import com.vhall.android.exoplayer2.source.chunk.MediaChunk;
import com.vhall.android.exoplayer2.source.hls.Aes128DataSource;
import com.vhall.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.vhall.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.vhall.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.vhall.android.exoplayer2.upstream.DataSource;
import com.vhall.android.exoplayer2.upstream.DataSpec;
import com.vhall.android.exoplayer2.util.ParsableByteArray;
import com.vhall.android.exoplayer2.util.TimestampAdjuster;
import com.vhall.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class HlsMediaChunk
extends MediaChunk {
    private static final String PRIV_TIMESTAMP_FRAME_OWNER = "com.apple.streaming.transportStreamTimestamp";
    private static final AtomicInteger uidSource = new AtomicInteger();
    public final int uid;
    public final int discontinuitySequenceNumber;
    public final HlsMasterPlaylist.HlsUrl hlsUrl;
    private final DataSource initDataSource;
    private final DataSpec initDataSpec;
    private final boolean isEncrypted;
    private final boolean isMasterTimestampSource;
    private final boolean hasGapTag;
    private final TimestampAdjuster timestampAdjuster;
    private final boolean shouldSpliceIn;
    private final HlsExtractorFactory extractorFactory;
    private final List<Format> muxedCaptionFormats;
    private final DrmInitData drmInitData;
    private final Extractor previousExtractor;
    private final Id3Decoder id3Decoder;
    private final ParsableByteArray id3Data;
    private Extractor extractor;
    private HlsSampleStreamWrapper output;
    private int initSegmentBytesLoaded;
    private int nextLoadPosition;
    private boolean initLoadCompleted;
    private volatile boolean loadCanceled;
    private boolean loadCompleted;

    public HlsMediaChunk(HlsExtractorFactory extractorFactory, DataSource dataSource, DataSpec dataSpec, DataSpec initDataSpec, HlsMasterPlaylist.HlsUrl hlsUrl, List<Format> muxedCaptionFormats, int trackSelectionReason, Object trackSelectionData, long startTimeUs, long endTimeUs, long chunkMediaSequence, int discontinuitySequenceNumber, boolean hasGapTag, boolean isMasterTimestampSource, TimestampAdjuster timestampAdjuster, HlsMediaChunk previousChunk, DrmInitData drmInitData, byte[] fullSegmentEncryptionKey, byte[] encryptionIv) {
        super(HlsMediaChunk.buildDataSource(dataSource, fullSegmentEncryptionKey, encryptionIv), dataSpec, hlsUrl.format, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkMediaSequence);
        this.discontinuitySequenceNumber = discontinuitySequenceNumber;
        this.initDataSpec = initDataSpec;
        this.hlsUrl = hlsUrl;
        this.isMasterTimestampSource = isMasterTimestampSource;
        this.timestampAdjuster = timestampAdjuster;
        this.isEncrypted = fullSegmentEncryptionKey != null;
        this.hasGapTag = hasGapTag;
        this.extractorFactory = extractorFactory;
        this.muxedCaptionFormats = muxedCaptionFormats;
        this.drmInitData = drmInitData;
        Extractor previousExtractor = null;
        if (previousChunk != null) {
            this.id3Decoder = previousChunk.id3Decoder;
            this.id3Data = previousChunk.id3Data;
            this.shouldSpliceIn = previousChunk.hlsUrl != hlsUrl || !previousChunk.loadCompleted;
            previousExtractor = previousChunk.discontinuitySequenceNumber != discontinuitySequenceNumber || this.shouldSpliceIn ? null : previousChunk.extractor;
        } else {
            this.id3Decoder = new Id3Decoder();
            this.id3Data = new ParsableByteArray(10);
            this.shouldSpliceIn = false;
        }
        this.previousExtractor = previousExtractor;
        this.initDataSource = dataSource;
        this.uid = uidSource.getAndIncrement();
    }

    public void init(HlsSampleStreamWrapper output) {
        this.output = output;
    }

    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    public void cancelLoad() {
        this.loadCanceled = true;
    }

    public void load() throws IOException, InterruptedException {
        this.maybeLoadInitData();
        if (!this.loadCanceled) {
            if (!this.hasGapTag) {
                this.loadMedia();
            }
            this.loadCompleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLoadInitData() throws IOException, InterruptedException {
        if (this.initLoadCompleted || this.initDataSpec == null) {
            return;
        }
        DataSpec initSegmentDataSpec = this.initDataSpec.subrange((long)this.initSegmentBytesLoaded);
        try {
            DefaultExtractorInput input = this.prepareExtraction(this.initDataSource, initSegmentDataSpec);
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read((ExtractorInput)input, null);
                }
            }
            finally {
                this.initSegmentBytesLoaded = (int)(input.getPosition() - this.initDataSpec.absoluteStreamPosition);
            }
        }
        finally {
            Util.closeQuietly((DataSource)this.initDataSource);
        }
        this.initLoadCompleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMedia() throws IOException, InterruptedException {
        boolean skipLoadedBytes;
        DataSpec loadDataSpec;
        if (this.isEncrypted) {
            loadDataSpec = this.dataSpec;
            skipLoadedBytes = this.nextLoadPosition != 0;
        } else {
            loadDataSpec = this.dataSpec.subrange((long)this.nextLoadPosition);
            skipLoadedBytes = false;
        }
        if (!this.isMasterTimestampSource) {
            this.timestampAdjuster.waitUntilInitialized();
        } else if (this.timestampAdjuster.getFirstSampleTimestampUs() == Long.MAX_VALUE) {
            this.timestampAdjuster.setFirstSampleTimestampUs(this.startTimeUs);
        }
        try {
            DefaultExtractorInput input = this.prepareExtraction((DataSource)this.dataSource, loadDataSpec);
            if (skipLoadedBytes) {
                input.skipFully(this.nextLoadPosition);
            }
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read((ExtractorInput)input, null);
                }
            }
            finally {
                this.nextLoadPosition = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            Util.closeQuietly((DataSource)this.dataSource);
        }
    }

    private DefaultExtractorInput prepareExtraction(DataSource dataSource, DataSpec dataSpec) throws IOException, InterruptedException {
        long bytesToRead = dataSource.open(dataSpec);
        DefaultExtractorInput extractorInput = new DefaultExtractorInput(dataSource, dataSpec.absoluteStreamPosition, bytesToRead);
        if (this.extractor == null) {
            long id3Timestamp = this.peekId3PrivTimestamp((ExtractorInput)extractorInput);
            extractorInput.resetPeekPosition();
            Pair<Extractor, Boolean> extractorData = this.extractorFactory.createExtractor(this.previousExtractor, dataSpec.uri, this.trackFormat, this.muxedCaptionFormats, this.drmInitData, this.timestampAdjuster, dataSource.getResponseHeaders(), (ExtractorInput)extractorInput);
            this.extractor = (Extractor)extractorData.first;
            boolean reusingExtractor = this.extractor == this.previousExtractor;
            boolean isPackedAudioExtractor = (Boolean)extractorData.second;
            if (isPackedAudioExtractor) {
                this.output.setSampleOffsetUs(id3Timestamp != -9223372036854775807L ? this.timestampAdjuster.adjustTsTimestamp(id3Timestamp) : this.startTimeUs);
            }
            this.initLoadCompleted = reusingExtractor && this.initDataSpec != null;
            this.output.init(this.uid, this.shouldSpliceIn, reusingExtractor);
            if (!reusingExtractor) {
                this.extractor.init((ExtractorOutput)this.output);
            }
        }
        return extractorInput;
    }

    private long peekId3PrivTimestamp(ExtractorInput input) throws IOException, InterruptedException {
        input.resetPeekPosition();
        if (input.getLength() < 10L || !input.peekFully(this.id3Data.data, 0, 10, true)) {
            return -9223372036854775807L;
        }
        this.id3Data.reset(10);
        int id = this.id3Data.readUnsignedInt24();
        if (id != Id3Decoder.ID3_TAG) {
            return -9223372036854775807L;
        }
        this.id3Data.skipBytes(3);
        int id3Size = this.id3Data.readSynchSafeInt();
        int requiredCapacity = id3Size + 10;
        if (requiredCapacity > this.id3Data.capacity()) {
            byte[] data = this.id3Data.data;
            this.id3Data.reset(requiredCapacity);
            System.arraycopy(data, 0, this.id3Data.data, 0, 10);
        }
        if (!input.peekFully(this.id3Data.data, 10, id3Size, true)) {
            return -9223372036854775807L;
        }
        Metadata metadata = this.id3Decoder.decode(this.id3Data.data, id3Size);
        if (metadata == null) {
            return -9223372036854775807L;
        }
        int metadataLength = metadata.length();
        for (int i = 0; i < metadataLength; ++i) {
            Metadata.Entry frame = metadata.get(i);
            if (!(frame instanceof PrivFrame)) continue;
            PrivFrame privFrame = (PrivFrame)frame;
            if (!PRIV_TIMESTAMP_FRAME_OWNER.equals(privFrame.owner)) continue;
            System.arraycopy(privFrame.privateData, 0, this.id3Data.data, 0, 8);
            this.id3Data.reset(8);
            return this.id3Data.readLong() & 0x1FFFFFFFFL;
        }
        return -9223372036854775807L;
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] fullSegmentEncryptionKey, byte[] encryptionIv) {
        if (fullSegmentEncryptionKey != null) {
            return new Aes128DataSource(dataSource, fullSegmentEncryptionKey, encryptionIv);
        }
        return dataSource;
    }
}

