/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import android.content.Context;
import android.os.Environment;
import com.vhall.crash.VHCrashHandler;
import com.vhall.crash.utils.InternalUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;

public class VHFileUtils {
    public static String writeFileToStorage(Context context, String content) {
        String fileName = null;
        String internalName = VHFileUtils.write(content, VHFileUtils.getInternalCrashPath(context));
        if (null != internalName) {
            fileName = internalName;
        }
        String externalName = VHFileUtils.write(content, VHFileUtils.getSDCardCrashPath(context));
        if (null == fileName && null != externalName) {
            fileName = externalName;
        }
        return fileName;
    }

    public static String getInternalCrashPath(Context context) {
        return String.format("%s/%s/%s/%s", context.getFilesDir(), "crash", InternalUtils.getCurrentDay(), InternalUtils.getSpecialCrashName(context));
    }

    public static String getSDCardCrashPath(Context context) {
        return String.format("%s/%s/%s/%s/%s/%s", Environment.getExternalStorageDirectory(), VHCrashHandler.mCrashRootDir, "crash", context.getPackageName(), InternalUtils.getCurrentDay(), InternalUtils.getSpecialCrashName(context));
    }

    public static String write(String content, String destPath) {
        String fileName = null;
        try {
            File destFile = new File(destPath);
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(destPath)));
            writer.write(content);
            writer.flush();
            fileName = destFile.getName();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }
}

