/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import android.content.Context;
import com.vhall.crash.VHCrashHandler;
import com.vhall.crash.utils.CacherManager;
import com.vhall.crash.utils.ICacher;
import com.vhall.logmanager.IReportCallbcak;
import com.vhall.logmanager.LogReporter;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StatAnalyzer {
    private static final String STAT_NAME = "statistic";
    public static final String EVENT_TYPE_LAUNCH = "launch-";
    public static final String EVENT_TYPE_CRASH = "crash-";
    public static final String EVENT_TYPE_CRASH_AID = "crash_aid-";
    private static final String K_LAUNCH = "296001";
    private static final String K_CRASH = "296000";
    private static Set<String> mKeySet;
    private static Map<String, ?> mAllEvent;

    public static void putLaunchEvent(Context context) {
        if (null == context) {
            return;
        }
        CacherManager.getInstance(context.getApplicationContext()).getCacher(STAT_NAME).putString(String.valueOf(System.currentTimeMillis() / 1000L), EVENT_TYPE_LAUNCH);
    }

    public static void putCrashEvent(Context context, String crashJson) {
        if (null == context) {
            return;
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        CacherManager.getInstance(context.getApplicationContext()).getCacher(STAT_NAME).putString(String.valueOf(timestamp), EVENT_TYPE_CRASH + crashJson);
        CacherManager.getInstance(context.getApplicationContext()).getCacher(STAT_NAME).putString(StatAnalyzer.makeCrashRoomKey(String.valueOf(timestamp)), EVENT_TYPE_CRASH_AID + VHCrashHandler.getRoomId());
    }

    public static void doReport(Context context, String uploadUrl) {
        ICacher cacher = CacherManager.getInstance(context.getApplicationContext()).getCacher(STAT_NAME);
        mAllEvent = cacher.getAllEvent();
        mKeySet = mAllEvent.keySet();
        StatAnalyzer.doSingleReport(cacher, uploadUrl);
    }

    private static String makeCrashRoomKey(String timestamp) {
        return EVENT_TYPE_CRASH_AID + timestamp;
    }

    private static void doSingleReport(final ICacher cacher, final String uploadUrl) {
        if (null == mKeySet || mKeySet.size() <= 0 || null == mAllEvent) {
            return;
        }
        String tempValue = null;
        String tempKey = null;
        String kKey = null;
        JSONObject tempExtra = null;
        for (String spKey : mKeySet) {
            try {
                tempValue = mAllEvent.get(spKey).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null == tempValue) continue;
            if (tempValue.equals(EVENT_TYPE_LAUNCH)) {
                kKey = K_LAUNCH;
            } else {
                if (!tempValue.startsWith(EVENT_TYPE_CRASH)) continue;
                kKey = K_CRASH;
                try {
                    tempExtra = new JSONObject();
                    tempExtra.put("crash", (Object)new JSONObject(tempValue.replace(EVENT_TYPE_CRASH, "")));
                    String crashAid = null;
                    try {
                        if (mAllEvent.containsKey(StatAnalyzer.makeCrashRoomKey(spKey))) {
                            crashAid = mAllEvent.get(StatAnalyzer.makeCrashRoomKey(spKey)).toString().replace(EVENT_TYPE_CRASH_AID, "");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (null != crashAid) {
                        tempExtra.put("aid", crashAid);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            tempKey = spKey;
            break;
        }
        if (null == kKey) {
            return;
        }
        try {
            final String rKey = tempKey;
            LogReporter.getInstance().setReportRawCallback(new IReportCallbcak(){

                public void onComplete(boolean succeed) {
                    mKeySet.remove(rKey);
                    mKeySet.remove(StatAnalyzer.makeCrashRoomKey(rKey));
                    if (succeed) {
                        cacher.removeEvent(rKey);
                        cacher.removeEvent(StatAnalyzer.makeCrashRoomKey(rKey));
                    }
                    StatAnalyzer.doSingleReport(cacher, uploadUrl);
                }
            });
            LogReporter.getInstance().onCollection(uploadUrl, Long.parseLong(rKey), kKey, false, tempExtra);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

