/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Process;
import com.vhall.crash.utils.VHDeviceUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class InternalUtils {
    public static String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static String getCurrentDay() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public static String getSpecialCrashName(Context context) {
        PackageInfo info = VHDeviceUtils.getPackageInfo(context);
        int verCode = 0;
        String verName = "1.0.0";
        if (info != null) {
            verCode = info.versionCode;
            verName = info.versionName;
        }
        return String.format("%s-%s-%s-v%s-%s-%s-%s-%s.info", VHDeviceUtils.getAppName(context), context.getPackageName(), verCode, verName, Build.MANUFACTURER, Build.MODEL, Build.VERSION.SDK_INT, UUID.randomUUID());
    }

    public static String getCurrentProcessName(Context context) {
        if (null != context) {
            int pid = Process.myPid();
            ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
            if (mActivityManager == null || mActivityManager.getRunningAppProcesses() == null || mActivityManager.getRunningAppProcesses().size() <= 0) {
                return " ";
            }
            for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
                if (appProcess.pid != pid) continue;
                return appProcess.processName;
            }
        }
        return " ";
    }
}

