/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import com.vhall.crash.utils.VLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class CrashUtils {
    public static final String TYPE_NONVHALL = "nonvhall";
    public static final String K_CRASH = "k_crash";
    public static final String K_TAG = "k_tag";

    public static Map<String, String> dumpCrashInfo(Throwable ex) {
        String crashInfo = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (null != ex) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            ex.setStackTrace(ex.getStackTrace());
            ex.printStackTrace(printWriter);
            printWriter.close();
            crashInfo = ((Object)result).toString();
            if (!crashInfo.contains("com.vhall")) {
                VLog.d(crashInfo);
                resultMap.put(K_TAG, TYPE_NONVHALL);
            }
        }
        if (null != crashInfo) {
            resultMap.put(K_CRASH, crashInfo);
        }
        return resultMap;
    }

    public static String dumpCrashCause(Throwable ex) {
        String cause = null;
        if (null != ex) {
            Throwable innerT = ex.getCause();
            cause = null != innerT ? innerT.toString() : "Non-Chained Exception[vhall tips]";
        }
        return cause;
    }

    public static String dumpCrashMessage(Throwable ex) {
        String msg = null;
        if (null != ex) {
            msg = ex.getMessage();
        }
        return msg;
    }
}

