/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.vhall.crash.utils.CacherManager;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CrashAnalyzer {
    public static final String EX_THRESHOLD = "fingerprint exceeds threshold";
    private static final String CACHE_NAME = "fingerprint";
    private static String[] TAGS_STREAMMEDIA = new String[]{"com.vhall.dispatchswitch", "com.vhall.jni", "com.vhall.vhalllivenative", "org.vhwebrtc", "org.webrtc", "com.vhall.vhallrtc"};

    public static void analyse(Context context, int threshold, String exMsg) throws IllegalAccessException {
        if (null == context) {
            return;
        }
        if (0 == threshold) {
            return;
        }
        String fingerPrint = CrashAnalyzer.exToHex(exMsg);
        if (null != fingerPrint && CrashAnalyzer.ifExceedsThreshold(context, fingerPrint, threshold)) {
            throw new IllegalAccessException(EX_THRESHOLD);
        }
    }

    public static boolean isThresholdEx(String exMsg) {
        return TextUtils.equals((CharSequence)EX_THRESHOLD, (CharSequence)exMsg);
    }

    public static boolean isFromStreamMedia(String exMsg) {
        if (null == exMsg) {
            return false;
        }
        for (String pkgTag : TAGS_STREAMMEDIA) {
            if (!exMsg.contains(pkgTag)) continue;
            return true;
        }
        return false;
    }

    private static String exToHex(String exMsg) {
        String exText = exMsg.replace(" ", "");
        String hexResult = null;
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(exText.getBytes());
            StringBuffer stringBuffer = new StringBuffer();
            for (byte tempByte : digest) {
                String hex = Integer.toHexString(tempByte & 0xFF);
                if (1 == hex.length()) {
                    hex = '0' + hex;
                }
                stringBuffer.append(hex);
            }
            hexResult = stringBuffer.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return hexResult;
    }

    @SuppressLint(value={"ApplySharedPref"})
    private static boolean ifExceedsThreshold(Context context, String fingerprint, int threshold) {
        int hits = CacherManager.getInstance(context).getCacher(CACHE_NAME).getInt(fingerprint, 0);
        CrashAnalyzer.incHits(context, fingerprint, ++hits);
        return hits > threshold;
    }

    private static void incHits(Context context, String fingerprint, int newHits) {
        CacherManager.getInstance(context).getCacher(CACHE_NAME).putInt(fingerprint, newHits);
    }
}

