/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.crash.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.vhall.crash.utils.ICacher;
import java.util.HashMap;
import java.util.Map;

public class CacherManager {
    private static volatile CacherManager mInstance;
    private Context mContext;
    private HashMap<String, SharedPreferences> cacherMap = new HashMap();
    private ICacher mCacher;

    private CacherManager(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacherManager getInstance(Context context) {
        if (null != mInstance) return mInstance;
        Class<CacherManager> clazz = CacherManager.class;
        synchronized (CacherManager.class) {
            if (null != mInstance) return mInstance;
            mInstance = new CacherManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public ICacher getCacher(final String cacherName) {
        this.mCacher = new ICacher(){

            @Override
            public Map<String, ?> getAllEvent() {
                return CacherManager.this.getCacherByName(cacherName).getAll();
            }

            @Override
            @SuppressLint(value={"ApplySharedPref"})
            public void putString(String key, String value) {
                CacherManager.this.getCacherByName(cacherName).edit().putString(key, value).commit();
            }

            @Override
            public String getString(String key) {
                return CacherManager.this.getCacherByName(cacherName).getString(key, "");
            }

            @Override
            @SuppressLint(value={"ApplySharedPref"})
            public void removeEvent(String key) {
                CacherManager.this.getCacherByName(cacherName).edit().remove(key).commit();
            }

            @Override
            @SuppressLint(value={"ApplySharedPref"})
            public void clearEvent() {
                CacherManager.this.getCacherByName(cacherName).edit().clear().commit();
            }

            @Override
            @SuppressLint(value={"ApplySharedPref"})
            public void putInt(String key, int value) {
                CacherManager.this.getCacherByName(cacherName).edit().putInt(key, value).commit();
            }

            @Override
            @SuppressLint(value={"ApplySharedPref"})
            public int getInt(String key, int defValue) {
                return CacherManager.this.getCacherByName(cacherName).getInt(key, defValue);
            }
        };
        return this.mCacher;
    }

    private SharedPreferences createCacher(String cacherName) {
        if (null == this.mContext) {
            return null;
        }
        return this.mContext.getSharedPreferences(cacherName, 0);
    }

    private SharedPreferences getCacherByName(String cacherName) {
        if (!this.cacherMap.containsKey(cacherName)) {
            this.cacherMap.put(cacherName, this.createCacher(cacherName));
        }
        return this.cacherMap.get(cacherName);
    }
}

