/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.core;

import com.github.vertical_blank.sqlformatter.core.Token;
import com.github.vertical_blank.sqlformatter.core.TokenTypes;
import java.util.List;

class InlineBlock {
    private int level;
    private final int maxColumnLength;

    InlineBlock(int maxColumnLength) {
        this.maxColumnLength = maxColumnLength;
        this.level = 0;
    }

    void beginIfPossible(List<Token> tokens, int index) {
        this.level = this.level == 0 && this.isInlineBlock(tokens, index) ? 1 : (this.level > 0 ? ++this.level : 0);
    }

    public void end() {
        --this.level;
    }

    boolean isActive() {
        return this.level > 0;
    }

    private boolean isInlineBlock(List<Token> tokens, int index) {
        int length = 0;
        int level = 0;
        for (int i = index; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if ((length += token.value.length()) > this.maxColumnLength) {
                return false;
            }
            if (token.type == TokenTypes.OPEN_PAREN) {
                ++level;
            } else if (token.type == TokenTypes.CLOSE_PAREN && --level == 0) {
                return true;
            }
            if (!this.isForbiddenToken(token)) continue;
            return false;
        }
        return false;
    }

    private boolean isForbiddenToken(Token token) {
        return token.type == TokenTypes.RESERVED_TOPLEVEL || token.type == TokenTypes.RESERVED_NEWLINE || token.type == TokenTypes.BLOCK_COMMENT || token.value.equals(";");
    }
}

