/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell.paragraph;

import java.awt.Color;
import java.util.Collections;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphProcessable;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.annotations.AnnotatedStyledText;
import rst.pdfbox.layout.text.annotations.Annotations;

public class Hyperlink
implements ParagraphProcessable {
    @NonNull
    private String text;
    @NonNull
    private String url;
    private PDFont font;
    private Float fontSize;
    private Color color;
    private float baselineOffset;

    @Override
    public void process(Paragraph paragraph, Settings settings) {
        Annotations.HyperlinkAnnotation hyperlink = new Annotations.HyperlinkAnnotation(this.getUrl(), Annotations.HyperlinkAnnotation.LinkStyle.ul);
        paragraph.add((TextFragment)new AnnotatedStyledText(this.getText(), this.getFontSize() != null ? this.getFontSize().floatValue() : (float)settings.getFontSize().intValue(), this.getFont() != null ? this.getFont() : settings.getFont(), this.getColor(), this.getBaselineOffset(), Collections.singleton(hyperlink)));
    }

    private static Color $default$color() {
        return Color.BLUE;
    }

    private static float $default$baselineOffset() {
        return 1.0f;
    }

    Hyperlink(@NonNull String text, @NonNull String url, PDFont font, Float fontSize, Color color, float baselineOffset) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.text = text;
        this.url = url;
        this.font = font;
        this.fontSize = fontSize;
        this.color = color;
        this.baselineOffset = baselineOffset;
    }

    public static HyperlinkBuilder builder() {
        return new HyperlinkBuilder();
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public float getBaselineOffset() {
        return this.baselineOffset;
    }

    public static class HyperlinkBuilder {
        private String text;
        private String url;
        private PDFont font;
        private Float fontSize;
        private boolean color$set;
        private Color color$value;
        private boolean baselineOffset$set;
        private float baselineOffset$value;

        HyperlinkBuilder() {
        }

        public HyperlinkBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        public HyperlinkBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public HyperlinkBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public HyperlinkBuilder fontSize(Float fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public HyperlinkBuilder color(Color color) {
            this.color$value = color;
            this.color$set = true;
            return this;
        }

        public HyperlinkBuilder baselineOffset(float baselineOffset) {
            this.baselineOffset$value = baselineOffset;
            this.baselineOffset$set = true;
            return this;
        }

        public Hyperlink build() {
            Color color$value = this.color$value;
            if (!this.color$set) {
                color$value = Hyperlink.$default$color();
            }
            float baselineOffset$value = this.baselineOffset$value;
            if (!this.baselineOffset$set) {
                baselineOffset$value = Hyperlink.$default$baselineOffset();
            }
            return new Hyperlink(this.text, this.url, this.font, this.fontSize, color$value, baselineOffset$value);
        }

        public String toString() {
            return "Hyperlink.HyperlinkBuilder(text=" + this.text + ", url=" + this.url + ", font=" + this.font + ", fontSize=" + this.fontSize + ", color$value=" + this.color$value + ", baselineOffset$value=" + this.baselineOffset$value + ")";
        }
    }
}

