/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing;

import java.awt.Color;

public class PositionedLine {
    private float width;
    private float startX;
    private float startY;
    private float endX;
    private float endY;
    private Color color;
    private Color resetColor;

    PositionedLine(float width, float startX, float startY, float endX, float endY, Color color, Color resetColor) {
        this.width = width;
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.color = color;
        this.resetColor = resetColor;
    }

    public static PositionedLineBuilder builder() {
        return new PositionedLineBuilder();
    }

    public PositionedLineBuilder toBuilder() {
        return new PositionedLineBuilder().width(this.width).startX(this.startX).startY(this.startY).endX(this.endX).endY(this.endY).color(this.color).resetColor(this.resetColor);
    }

    public float getWidth() {
        return this.width;
    }

    public float getStartX() {
        return this.startX;
    }

    public float getStartY() {
        return this.startY;
    }

    public float getEndX() {
        return this.endX;
    }

    public float getEndY() {
        return this.endY;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getResetColor() {
        return this.resetColor;
    }

    public static class PositionedLineBuilder {
        private float width;
        private float startX;
        private float startY;
        private float endX;
        private float endY;
        private Color color;
        private Color resetColor;

        PositionedLineBuilder() {
        }

        public PositionedLineBuilder width(float width) {
            this.width = width;
            return this;
        }

        public PositionedLineBuilder startX(float startX) {
            this.startX = startX;
            return this;
        }

        public PositionedLineBuilder startY(float startY) {
            this.startY = startY;
            return this;
        }

        public PositionedLineBuilder endX(float endX) {
            this.endX = endX;
            return this;
        }

        public PositionedLineBuilder endY(float endY) {
            this.endY = endY;
            return this;
        }

        public PositionedLineBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public PositionedLineBuilder resetColor(Color resetColor) {
            this.resetColor = resetColor;
            return this;
        }

        public PositionedLine build() {
            return new PositionedLine(this.width, this.startX, this.startY, this.endX, this.endY, this.color, this.resetColor);
        }

        public String toString() {
            return "PositionedLine.PositionedLineBuilder(width=" + this.width + ", startX=" + this.startX + ", startY=" + this.startY + ", endX=" + this.endX + ", endY=" + this.endY + ", color=" + this.color + ", resetColor=" + this.resetColor + ")";
        }
    }
}

