/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.geom.Point2D;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.structure.cell.CellBaseData;

public class CellImage
extends CellBaseData {
    @NonNull
    private PDImageXObject image;
    private float maxHeight;
    private final float scale;

    @Override
    public float getHeight() {
        this.assertIsRendered();
        return this.getFitSize().y + this.getVerticalPadding();
    }

    public Point2D.Float getFitSize() {
        Point2D.Float sizes = new Point2D.Float();
        float scaledWidth = (float)this.image.getWidth() * this.getScale();
        float scaledHeight = (float)this.image.getHeight() * this.getScale();
        float resultingWidth = this.getColumn().getWidth() - this.getHorizontalPadding();
        if (scaledWidth > resultingWidth) {
            scaledHeight = resultingWidth / scaledWidth * scaledHeight;
            scaledWidth = resultingWidth;
        }
        if (this.maxHeight > 0.0f && scaledHeight > this.maxHeight) {
            scaledWidth = this.maxHeight / scaledHeight * scaledWidth;
            scaledHeight = this.maxHeight;
        }
        sizes.x = scaledWidth;
        sizes.y = scaledHeight;
        return sizes;
    }

    private static float $default$scale() {
        return 1.0f;
    }

    protected CellImage(CellImageBuilder<?, ?> b) {
        super(b);
        this.image = ((CellImageBuilder)b).image;
        if (this.image == null) {
            throw new NullPointerException("image is marked @NonNull but is null");
        }
        this.maxHeight = ((CellImageBuilder)b).maxHeight;
        this.scale = ((CellImageBuilder)b).scale$set ? ((CellImageBuilder)b).scale : CellImage.$default$scale();
    }

    public static CellImageBuilder<?, ?> builder() {
        return new CellImageBuilderImpl();
    }

    public CellImageBuilder<?, ?> toBuilder() {
        return new CellImageBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    public PDImageXObject getImage() {
        return this.image;
    }

    public float getMaxHeight() {
        return this.maxHeight;
    }

    public float getScale() {
        return this.scale;
    }

    private static final class CellImageBuilderImpl
    extends CellImageBuilder<CellImage, CellImageBuilderImpl> {
        private CellImageBuilderImpl() {
        }

        @Override
        protected CellImageBuilderImpl self() {
            return this;
        }

        @Override
        public CellImage build() {
            return new CellImage(this);
        }
    }

    public static abstract class CellImageBuilder<C extends CellImage, B extends CellImageBuilder<C, B>>
    extends CellBaseData.CellBaseDataBuilder<C, B> {
        private PDImageXObject image;
        private float maxHeight;
        private boolean scale$set;
        private float scale;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CellImageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CellImage instance, CellImageBuilder<?, ?> b) {
            b.image(instance.image);
            b.maxHeight(instance.maxHeight);
            b.scale(instance.scale);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B image(@NonNull PDImageXObject image) {
            if (image == null) {
                throw new NullPointerException("image is marked @NonNull but is null");
            }
            this.image = image;
            return (B)this.self();
        }

        public B maxHeight(float maxHeight) {
            this.maxHeight = maxHeight;
            return (B)this.self();
        }

        public B scale(float scale) {
            this.scale = scale;
            this.scale$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CellImage.CellImageBuilder(super=" + super.toString() + ", image=" + this.image + ", maxHeight=" + this.maxHeight + ", scale=" + this.scale + ")";
        }
    }
}

