/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp.internal;

import com.luciad.imageio.webp.internal.JavaUtilsKt;
import com.luciad.imageio.webp.internal.NativeLoader;
import com.luciad.imageio.webp.internal.OsInfo;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0007J\b\u0010\u001e\u001a\u00020\u0011H\u0002J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/luciad/imageio/webp/internal/NativeLoader;", "", "()V", "extracted", "", "tempDir", "Ljava/io/File;", "getTempDir", "()Ljava/io/File;", "version", "", "getVersion$annotations", "getVersion", "()Ljava/lang/String;", "version$delegate", "Lkotlin/Lazy;", "cleanup", "", "cleanup$webp_imageio", "contentsEquals", "in1", "Ljava/io/InputStream;", "in2", "extractAndLoadLibraryFile", "libFolderForCurrentOS", "libraryFileName", "targetFolder", "hasResource", "path", "initialize", "loadNativeLibrary", "name", "webp-imageio"})
@SourceDebugExtension(value={"SMAP\nNativeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeLoader.kt\ncom/luciad/imageio/webp/internal/NativeLoader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1295#2,2:258\n1#3:260\n731#4,9:261\n*S KotlinDebug\n*F\n+ 1 NativeLoader.kt\ncom/luciad/imageio/webp/internal/NativeLoader\n*L\n84#1:258,2\n215#1:261,9\n*E\n"})
public final class NativeLoader {
    @NotNull
    public static final NativeLoader INSTANCE = new NativeLoader();
    private static boolean extracted;
    @NotNull
    private static final Lazy version$delegate;

    private NativeLoader() {
    }

    @JvmStatic
    public static final synchronized boolean initialize() {
        if (!extracted) {
            INSTANCE.cleanup$webp_imageio();
        }
        INSTANCE.loadNativeLibrary();
        return extracted;
    }

    private final File getTempDir() {
        String string = JavaUtilsKt.findProperty("com.luciad.imageio.webp.tmpdir");
        if (string == null && (string = JavaUtilsKt.findProperty("java.io.tmpdir")) == null) {
            throw new IllegalStateException("Neither `com.luciad.imageio.webp.tmpdir` nor `java.io.tmpdir` was found.".toString());
        }
        return new File(string);
    }

    @JvmStatic
    public static final void cleanup$webp_imageio() {
        String tempFolder = INSTANCE.getTempDir().getAbsolutePath();
        File dir = new File(tempFolder);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkBottomUp((File)dir)), (Function1)cleanup.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File nativeLibFile = (File)element$iv;
            boolean bl = false;
            File lckFile = new File(nativeLibFile.getAbsolutePath() + ".lck");
            if (lckFile.exists()) continue;
            try {
                nativeLibFile.delete();
            }
            catch (SecurityException e) {
                System.err.println("Failed to delete old native lib " + e.getMessage());
            }
        }
    }

    private final boolean contentsEquals(InputStream in1, InputStream in2) {
        int ch2;
        BufferedInputStream input1 = in1 instanceof BufferedInputStream ? (BufferedInputStream)in1 : new BufferedInputStream(in1);
        BufferedInputStream input2 = in2 instanceof BufferedInputStream ? (BufferedInputStream)in2 : new BufferedInputStream(in2);
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        boolean bl;
        String nativeLibraryFilePath = libFolderForCurrentOS + '/' + libraryFileName;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String uuid = string;
        String extractedLibFileName = "webp-imageio-" + NativeLoader.getVersion() + '-' + uuid + '-' + libraryFileName;
        String extractedLckFileName = extractedLibFileName + ".lck";
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        File extractedLckFile = new File(targetFolder, extractedLckFileName);
        try {
            Throwable throwable;
            Closeable closeable;
            Object p0 = NativeLoader.class.getResourceAsStream(nativeLibraryFilePath);
            boolean bl2 = false;
            InputStream inputStream = p0;
            if (inputStream == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Closeable closeable2 = inputStream;
            p0 = null;
            try {
                InputStream reader22 = (InputStream)closeable2;
                boolean bl3 = false;
                if (!extractedLckFile.exists()) {
                    new FileOutputStream(extractedLckFile).close();
                }
                closeable = new FileOutputStream(extractedLibFile);
                throwable = null;
                try {
                    FileOutputStream writer22 = (FileOutputStream)closeable;
                    boolean bl4 = false;
                    long writer22 = ByteStreamsKt.copyTo$default((InputStream)reader22, (OutputStream)writer22, (int)0, (int)2, null);
                }
                catch (Throwable writer22) {
                    throwable = writer22;
                    throw writer22;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                long reader22 = writer22;
            }
            catch (Throwable reader22) {
                p0 = reader22;
                throw reader22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)p0);
            }
            extractedLibFile.deleteOnExit();
            extractedLckFile.deleteOnExit();
            extractedLibFile.setReadable(true);
            extractedLibFile.setWritable(true, true);
            extractedLibFile.setExecutable(true);
            p0 = NativeLoader.class.getResourceAsStream(nativeLibraryFilePath);
            boolean bl5 = false;
            Object object = p0;
            if (object == null) {
                String bl3 = "Required value was null.";
                throw new IllegalStateException(bl3.toString());
            }
            closeable2 = (Closeable)object;
            p0 = null;
            try {
                InputStream nativeIn = (InputStream)closeable2;
                boolean bl6 = false;
                closeable = new FileInputStream(extractedLibFile);
                throwable = null;
                try {
                    FileInputStream extractedLibIn = (FileInputStream)closeable;
                    boolean bl7 = false;
                    if (!INSTANCE.contentsEquals(nativeIn, extractedLibIn)) {
                        throw new IllegalStateException(("Failed to write a native library file at " + extractedLibFile).toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                p0 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)p0);
            }
            bl = this.loadNativeLibrary(targetFolder, extractedLibFileName);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final boolean loadNativeLibrary(String path, String name) {
        boolean bl;
        File libPath = new File(path, name);
        if (libPath.exists()) {
            boolean bl2;
            try {
                System.load(new File(path, name).getAbsolutePath());
                bl2 = true;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Failed to load native library:" + name + ". osinfo:" + OsInfo.getNativeLibFolderPathForCurrentOS());
                System.err.println(e);
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadNativeLibrary() {
        List list;
        void $this$dropLastWhile$iv;
        String string;
        if (extracted) {
            return;
        }
        List triedPaths = new ArrayList();
        String nativeLibraryName = System.mapLibraryName("webp-imageio");
        String nativeLibraryPath = "/native/" + OsInfo.getNativeLibFolderPathForCurrentOS();
        boolean hasNativeLib = this.hasResource(nativeLibraryPath + '/' + nativeLibraryName);
        if (hasNativeLib) {
            String tempFolder = this.getTempDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)nativeLibraryName, (String)"nativeLibraryName");
            Intrinsics.checkNotNullExpressionValue((Object)tempFolder, (String)"tempFolder");
            if (this.extractAndLoadLibraryFile(nativeLibraryPath, nativeLibraryName, tempFolder)) {
                extracted = true;
                return;
            }
            triedPaths.add(nativeLibraryPath);
        }
        if ((string = JavaUtilsKt.findProperty("java.library.path")) == null) {
            string = "";
        }
        String javaLibraryPath = string;
        Object object = javaLibraryPath;
        String string2 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
        String string3 = string2;
        string3 = new Regex(string3);
        int n = 0;
        object = string3.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String p0 = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)p0).length() == 0) continue;
                list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        for (String ldPath : list) {
            if (((CharSequence)ldPath).length() == 0) continue;
            Intrinsics.checkNotNullExpressionValue((Object)nativeLibraryName, (String)"nativeLibraryName");
            if (this.loadNativeLibrary(ldPath, nativeLibraryName)) {
                extracted = true;
                return;
            }
            triedPaths.add(ldPath);
        }
        extracted = false;
        StringBuilder stringBuilder = new StringBuilder().append("No native library found for os.name=").append(OsInfo.getOSName()).append(", os.arch=").append(OsInfo.getArchName()).append(", paths=[");
        Iterable iterable = triedPaths;
        String string4 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
        String string5 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, null, (int)62, null)).append(']').toString();
        throw new IllegalStateException(string5.toString());
    }

    private final boolean hasResource(String path) {
        return NativeLoader.class.getResource(path) != null;
    }

    @NotNull
    public static final String getVersion() {
        Lazy lazy = version$delegate;
        return (String)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getVersion$annotations() {
    }

    static {
        version$delegate = LazyKt.lazy((Function0)version.2.INSTANCE);
    }
}

